<?php
	require_once("../../../classes/main_classes.php");

	//OBJECTS
	$retrieveObj=new RETRIEVE();
	$rowcountObj=new ROWCOUNT();

	$get_running=$retrieveObj->retriever("auction 
      JOIN users ON users.user_id=auction.user_id
      JOIN auction_images ON auction_images.a_id=auction.a_id WHERE auction_images.image_type='primary_image' and auction.a_bid_status='running' GROUP BY auction.a_id","DISTINCT *","fetchAll");

?>

<p class="text_primary_color font-weight-bold mb-1 d-flex justify-content-between">
	<span>Running properties</span>
	<span>
		<a data-toggle="modal" data-target="#generateReportModal" class="nav-link fas fa-1x p-2 mb-2" href="#"><span class="text-dark fas fa-file-export"> Export</span></a>
	</span>
</p>
<div id="remove_auction_property_response"></div>
<div class="bg-white rounded p-3 shadow-sm">
	<?php
		$for_pdf='
			<div class="text-center mt-3">
				<img id="main_logo_img" src="../assets/img/sgw_logo.png" style="width: 172px;">
			</div>
			<div class="text-center mt-3 h3">Running bids(AUCTION SALES)</div>
			<div class="text-center mb-3 mt-2">'.date("d-m-Y").'</div>
			<table class="table" >
			<thead>
	   			<tr>
	   				<td>Image</td>
	   				<td>Name</td>
	   				<td>Bid start date</td>
	   				
	   				<td>Bid end date</td>
	   				
	   				<td>Bid start price</td>
	   				<td>Current max bid</td>
	   				<td>No. bids</td>
	   			</tr>
	   		</thead>
	   		<tbody>

		';
	?>
   	<table class="table" id="running_properties_table">
   		<thead>
   			<tr>
   				<td>Image</td>
   				<td>Name</td>
   				<td>Bid end date</td>
   				<td>Bid end time</td>
   				<td>Current max bid</td>
   				<td>No. bids</td>
   				<td></td>
   			</tr>
   		</thead>
   		<tbody>
   			<?php
				
                    if($get_running!="1020"){
                    	$element_id="element_id";
                        foreach ($get_running as $running) {
                        	$element_id=$element_id."Ot";

                        	$bid_start_date_time=new DateTime($running->a_bid_start_date);
						    $bid_start_date=$bid_start_date_time->format("Y-m-d");
						    $bid_start_time=$bid_start_date_time->format("H:i:s");

						    $bid_end_date_time=new DateTime($running->a_bid_end_date);
						    $bid_end_date=$bid_end_date_time->format("Y-m-d");
						    $bid_end_time=$bid_end_date_time->format("H:i:s");
			?>	
					<tr id="<?php echo $element_id ?>">	    		
						<td class="">
							<?php
								echo $image='<img class="m-1" style="max-height:75px;" src="../img/auctions/'.$running->image.'?timestamp'.time().'"/>';
							?>
						</td>
						<td>
							<?php 
								echo $a_name=$running->a_name;
							?>
						</td>
						
						<td>
							<?php echo $bid_end_date=date("d-m-Y", strtotime($bid_end_date)); ?>
						</td>
						<td>
							<?php 
								echo $bid_end_time;
							?>
						</td>
						
						<td>
							MKW 
							<?php
	                            //get current bid minimum price
	                            $get_current_bid_min_price=$retrieveObj->retriever("auction_bid","*","auction_bid.a_id",$running->a_id,"a_id","DESC","fetch");
	                            $current_bid_min_price="";
	                            if($get_current_bid_min_price=="1020"){
	                                echo $current_bid_min_price=money_format("%!n", $running->a_bid_start_price);
	                            }else{
	                                echo $current_bid_min_price=money_format("%!n", $get_current_bid_min_price->a_bid_price);
	                            }
	                            
	                         ?>
						</td>
						<td>
							<?php
    							echo $no_bids=$rowcountObj->rowcounter("auction_bid","*","a_id",$running->a_id);
    						?>	
						</td>
							
						<td id="<?php echo $element_id.'Dbtn' ?>">
							<?php
								$for_pdf_details_var='
									<div class="text-center mt-3">
										<img id="main_logo_img" src="../assets/img/sgw_logo.png" style="width: 172px;">
									</div>
									<div class="text-center mt-3 h3">Running bid(AUCTION SALES)</div>
									<div class="text-center mb-3 mt-2">'.date("d-m-Y").'</div>

									<div class="container">
										<div style="width:100%" style="p-2">
											<img class="" style="height:300px;" src="../img/auctions/'.$running->image.'?timestamp'.time().'"/>
										</div>
										<div style="width:100%" style="p-2">
											<table class="table table-borderless">
												<tr>
													<td><strong>Name</strong></td> 
													<td>'.$a_name.'</td>
												</tr>
												<tr>
													<td><strong>Bid end date</strong></td>
													<td>'.date("d-m-Y", strtotime($bid_start_date)).'</td>
												</tr>
												<tr>
													<td><strong>Bid end time</strong></td>
													<td>'.$bid_end_time.'</td>
												</tr>
												<tr>
													<td><strong>Bid end date</strong></td>
													<td>'.$bid_end_date.'</td>
												</tr>
												<tr>
													<td><strong>Bid end time</strong></td>
													<td>'.$bid_end_time.'</td>
												</tr>
												<tr>
													<td><strong>Start price</strong></td>
													<td>NKW'.money_format("%!n", $running->a_bid_start_price).'</td>
												</tr>
												<tr>
													<td><strong>Current max bid</strong></td>
													<td>MKW'.$current_bid_min_price.'</td>
												</tr>
												<tr>
													<td><strong>No. bids</strong></td>
													<td>'.$no_bids.'</td>
												</tr>
												<tr>
													<td><strong>Property owner</strong></td>
													<td>
														<p><strong>full name : </strong>'.$running->firstname.' '.$running->lastname.'</p>
														<p><strong>email : </strong>'.$running->email.'</p>
														<p><strong>phone : </strong>'.$running->phone.'</p>
													</td>
												</tr>
												
											</table>
										</div>
										<div class="col-md-12">
											<p><strong>Desctiption</strong></p>
											<p>'.$running->a_description.'</p>
										</div>
									</div>
								';

								$strI = serialize($for_pdf_details_var);
								$pdfDataDetails = urlencode($strI);

							?>
							<button class="btn text-info" data-toggle="modal" data-target="#universalModalXl" onclick="view_running_bid_details(<?php echo $running->a_id ?>)"><span class="fas fa-info"></span> </button>
							<button class="btn text-primary" onclick="edit_auction_property_view(<?php echo $running->a_id ?>)"><span class="fas fa-edit"></span> </button>
							<form action="../file_generators/pdf_generator.php" method="POST" target="_blank" style="display: inline;">
				                <input type="hidden" name="exportPdf" value="<?php echo $pdfDataDetails ?>">
								<input type="hidden" name="downloadBtn">
				                <button type="submit" class="btn"><span class="fas fa-file-pdf text-danger"></span> </button>
				            </form>
				            <form id="<?php echo $element_id.'form' ?>" class="mb-0" style="display: inline;">
				                <input type="hidden" name="remove_auction_property_note" value="<?php echo $running->a_id ?>">
				                <button  onclick="remove_auction_property('<?php echo $element_id.'form' ?>','<?php echo $element_id ?>','remove_auction_property_response')" type="submit" title="Remove" class="btn"><span class="fas fa-trash text-warning"> </span></button>
				            </form>
						</td>
					</tr>
			<?php
				$for_pdf=$for_pdf."
							<tr>
								<td>".$image."</td>
								<td>".$a_name."</td>
								<td>".date("d-m-Y H:i:s", strtotime($running->a_bid_start_date))."</td>
								<td>".date("d-m-Y H:i:s", strtotime($running->a_bid_end_date))."</td>
								<td>MKW".money_format("%!n", $running->a_bid_start_price)."</td>
								<td>MKW".$current_bid_min_price."</td>
								<td>".$no_bids."</td>
							</tr>
						";

					}
					$for_pdf=$for_pdf."</tbody></table>";
				}
			?>
   		</tbody>
   	</table>
   	<?php
		
		//generate data sending variables
		$str = serialize($for_pdf);
		$pdfData = urlencode($str);
	?>
</div>
<!--GENERATE REPORTS MODAL-->
<div class='modal fade transparent mt-5' id='generateReportModal' data-keyboard="false" data-backdrop="static" tabindex="-1">
    <div class='modal-dialog shadow-lg rounded' style="max-height: 400px;" >
		<div class='modal-content' >
			<div  class='text-dark modal-header'>
				<button  class='btn btn-danger btn-sm' data-dismiss='modal'>
					&times;
				</button>
			</div>
			<div class='modal-body text-center bg-light'>
				<div class="text-center row">
					<div style="width: 100%" class="text-center">
						<form action="../file_generators/pdf_generator.php" method="POST" target="_blank">
							<input type="hidden" name="exportPdf" value="<?php echo $pdfData ?>">
							<input type="hidden" name="downloadBtn">
							<button class="btn" type="submit" name=""><span class="fas fa-file-pdf fa-8x text-danger"></span></button><br />
							<label class="text-dark bold lead">Pdf</label>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<script>  
 $(document).ready(function(){  
     var table = $('#running_properties_table').DataTable({
      columnDefs: [
        {bSortable: false, targets: [6]} 
      ]
    }); 
     $("thead").addClass("font-weight-bold");
 });  
 </script> 

