<?php
	$session_path="../../session_check.php";
	$classes="../../../classes/main_classes.php";

	require_once($session_path);
	require_once($classes);

	if($sign_in_status=="out"){
	    die("<p class='alert alert-warning'>You are not logged in</p>");
	}
 
	if(!isset($_POST['v_id'])){
		echo "<p class='alert alert-warning'>Invalid request</p>";
	}
	$v_id=addslashes($_POST["v_id"]);

	//OBJECTS
	$retrieveObj=new RETRIEVE();
	$rowcountObj=new ROWCOUNT();

	//get vehicles purchesed by cutomer
	$get_vehicle=$retrieveObj->retriever("vehicle 
      JOIN vehicle_images ON vehicle_images.v_id=vehicle.v_id 
      JOIN vehicle_make ON vehicle_make.v_make_id=vehicle.v_make_id 
      WHERE vehicle.v_id='$v_id'","*","fetch");
  $vehicle_image=$get_vehicle->image;
?>
<div class="text-left">
    <button class="btn" onclick="available_vehicle_properties()"><span class="fas fa-arrow-left"></span> Back</button>
</div>
<p class="text-center lead">Edit vehicle property</p>
<nav>
  <div class="nav nav-tabs" id="nav-tab" role="tablist">
    <a class="nav-item nav-link active text-dark" id="nav-info-tab" data-toggle="tab" href="#nav-info" role="tab" aria-controls="nav-info" aria-selected="true">Information</a>
    <a class="nav-item nav-link text-dark" id="nav-info-tab" data-toggle="tab" href="#nav-a-status" role="tab" aria-controls="nav-a-status" aria-selected="true">Availability status</a>
    <a class="nav-item nav-link text-dark" id="nav-main-image-tab" data-toggle="tab" href="#nav-main-image" role="tab" aria-controls="nav-main-image" aria-selected="false">Main image</a>
    <a class="nav-item nav-link text-dark" id="nav-other-images-tab" data-toggle="tab" href="#nav-other-images" role="tab" aria-controls="nav-other-images" aria-selected="false">Supporting images</a>
  </div>
</nav>
<div class="tab-content" id="nav-tabContent">
  <div class="tab-pane fade show active py-2" id="nav-info" role="tabpanel" aria-labelledby="nav-info-tab">
  	
  			<form id="edit_vehicle_basic_info_form">
          <div class="row my-2">
            <div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-3">
              <label for="vehicle_name">Vehicle name</label>
            </div>
            <div class="col-12 col-sm-12 col-md-6 col-lg-9 col-xl-9">
              <input class="form-control" type="text" name="vehicle_name" id="vehicle_name" value="<?php echo $get_vehicle->v_name; ?>">
            </div>
          </div>
          <div class="row my-2">
            <div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-3">
              <label for="vehicle_type">Body type</label>
            </div>
            <div class="col-12 col-sm-12 col-md-6 col-lg-9 col-xl-9">
              <?php
                //get types
                $get_types=$retrieveObj->retriever("vehicle_type","*","fetchAll");

                if($get_types!="1020"){

              ?>
              <select class="form-control" name="vehicle_type">
              <?php
                $select_type_status="";
                foreach ($get_types as $type) {
                  if($type->v_type_id==$get_vehicle->v_type_id){
                    $select_type_status="selected";
                  }else{
                    $select_type_status="";
                  }
            ?>
                  <option <?php echo $select_type_status ?> value='<?php echo $type->v_type_id ?>'><?php echo $type->v_type; ?></option>
            <?php
                }
              ?>
              </select>
            <?php 
              }else{
                echo "<p class='alert alert-warning'>Please add vehicle body types to continue</p>";
              } 
            ?>
            </div>
          </div>
          <div class="row my-2">
            <div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-3">
              <label for="vehicle_type">Make</label>
            </div>
            <div class="col-12 col-sm-12 col-md-6 col-lg-9 col-xl-9">
              <?php
                //get types
                $get_makes=$retrieveObj->retriever("vehicle_make","*","fetchAll");

                if($get_makes!="1020"){

              ?>
              <select class="form-control" name="vehicle_make">
              <?php
                $select_make_status="";
                foreach ($get_makes as $make) {
                  if($make->v_make_id==$get_vehicle->v_make_id){
                    $select_make_status="selected";
                  }else{
                    $select_make_status="";
                  }
            ?>
                  <option <?php echo $select_make_status ?> value='<?php echo $make->v_make_id ?>'><?php echo $make->v_make; ?></option>
            <?php
                }
              ?>
              </select>
            <?php 
              }else{
                echo "<p class='alert alert-warning'>Please add vehicle make to continue</p>";
              } 
            ?>
            </div>
          </div>

          <div class="row my-2">
            <div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-3">
              <label for="vehicle_model">Model</label>
            </div>
            <div class="col-12 col-sm-12 col-md-6 col-lg-9 col-xl-9">
              <input class="form-control" type="text" name="vehicle_model" id="vehicle_model" value="<?php echo $get_vehicle->v_model ?>">
            </div>
          </div>
          <div class="row my-2">
            <div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-3">
              <label for="vehicle_year">Year</label>
            </div>
            <div class="col-12 col-sm-12 col-md-6 col-lg-9 col-xl-9">
              <input class="form-control" type="text" name="vehicle_year" id="vehicle_year" value="<?php echo $get_vehicle->v_year ?>">
            </div>
          </div>
          
          
          <div class="row my-3 rounded">
            <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12">
              <div class="p-2 shadow-sm">
                <label for="vehicle_description">Description</label>
                <textarea class="form-control" name="vehicle_description" id="vehicle_description" rows="3"><?php echo $get_vehicle->v_description ?></textarea>
              </div>
            </div>
          </div>
          <div id="edit_vehicle_basic_info_response">
            
          </div>
          <div class="py-3 text-right">
            <input type="hidden" name="edit_vehicle_basic_info_note">
            <input type="hidden" name="v_id" value="<?php echo $get_vehicle->v_id ?>">
            <button class="btn bg_primary_color text-light ml-auto" type="submit" onclick="edit_vehicle_basic_info()"><span class="fas fa-save"></span> Save </button>
          </div>
        </form>
  	
  </div>
  <div class="tab-pane fade py-4 text-center" id="nav-a-status" role="tabpanel" aria-labelledby="nav-a-status-tab">
        <div class="text-left" >
          <?php
            $checkboxStatusAvailable="";
            $checkboxStatusSold="";
            if($get_vehicle->v_status=="available"){
              $checkboxStatusAvailable="checked";
              
              $checkboxStatusSold="";
            }else if($get_vehicle->v_status=="not_available"){
              $checkboxStatusAvailable="";
              
              $checkboxStatusSold="";
            }else if($get_vehicle->v_status=="sold"){
              $checkboxStatusAvailable="";
              
              $checkboxStatusSold="checked";
            }
          ?>
          <label class='switch' >
            <div class="input-group">
              <input class="mx-2" <?php echo $checkboxStatusAvailable ?> type='radio' id='vehicle_status_available' name='vehicle_status_name' value="available" onclick='setVehicleStatus(<?php echo $get_vehicle->v_id; ?>)'>
              <label class="input-group-append my-2" for="vehicle_status_available">Available</label>
            </div>

            <div class="input-group">
              <input class="mx-2" <?php echo $checkboxStatusSold ?> type='radio' id='vehicle_status_sold' name='vehicle_status_name' value="sold"  onclick='setVehicleStatus(<?php echo $get_vehicle->v_id; ?>)'>
              <label class="input-group-append my-2" for="vehicle_status_sold">Sold</label>
            </div>
            <span class='slider round'></span>
          </label>
        </div>
      
  </div>
  <div class="tab-pane fade py-2 text-center" id="nav-main-image" role="tabpanel" aria-labelledby="nav-main-image-tab">
  	<span class="hand_cursor mx-auto" data-toggle="collapse" data-target="#update_profile_container" id="profilePhotoContainer">
        <?php 
          if(!empty($get_vehicle->image)){
            echo '<img id="vehicle_picture" src="../img/vehicles/'.$get_vehicle->image.'" alt="..." style="max-height:250px" class="rounded mb-2 img-thumbnail" > ';
          }else{
            echo "<span class='fas fa-image fa-5x text-dark bg-light shadow-sm rounded border border-white' style='padding:8px 10px;'></span>";
          }
        ?>
    </span>
	<div id="update_profile_container" class="collapse" >
		<span class="btn btn-dark btn-file my-1">
		    Browse...<input type="file" id="upload_image">
		</span>
	</div>
	<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12" id="uploadimageContainer" style="display: none;">
		<div class="row">
            <div class="col-md-8 text-center">
              <div id="image_demo" style="width:350px; margin-top:30px"></div>
            </div>
            <div class="col-md-4" style="padding-top:30px;">
              <button class="btn btn-block btn-primary crop_image my-1">Update</button>
          </div>
        </div>
	</div>
  </div>
  <div class="tab-pane fade py-2" id="nav-other-images" role="tabpanel" aria-labelledby="nav-other-images-tab">
  	<div class="container-fluid">
  		<p class="text-right">
        <form class="text-right" id="add_vehicle_supporting_image_form" enctype="multipart/form-data">
          <input type="hidden" name="add_vehicle_supporting_image_note" value="<?php echo $v_id ?>">
          <a class="btn btn-file text-primary hand_cursor" href="#!">
            <span class="fas fa-plus"></span> 
              add supporting image
              <input type="file" multiple name="upload_other_images[]" id="upload_other_images" onchange="add_vehicle_supporting_images(<?php echo $v_id ?>)">
          </a>
        </form>
    			
  		</p>
      <div id="add_supporting_image_response">
        
      </div>
  		<div id="supporting_images_container">
  			
  		</div>
	    	
    </div>
  </div>
</div>



<script>  
  var editor = new Simditor({
    textarea: $('#vehicle_description')
    //optional options
  });
	
	var vehicle_image='<?php echo $vehicle_image ?>';
$(document).ready(function(){
	view_vehicle_supporting_images(<?php echo $v_id ?>)

  var d=new Date();
  var upload_btn_action=$(this).text();
  var image_crop = $('#image_demo').croppie({
    enableExif: true,
    viewport: {
      width:200,
      height:119,
      type:'square' //circle
    },
    boundary:{
      width:300,
      height:300
    }
  });
  


  $('#upload_image').on('change', function(){
    var reader = new FileReader();
    reader.onload = function (event) {
      image_crop.croppie('bind', {
        url: event.target.result
      }).then(function(){
        console.log('jQuery bind complete');
      });
    }
    reader.readAsDataURL(this.files[0]);
    $('#uploadimageContainer').show();
    $('html, body').animate({
        scrollTop: $("#uploadimageContainer").offset().top
    }, 1000);
  });

  $('.crop_image').click(function(event){
    $.LoadingOverlay("show");
  	upload_btn_action=$(this).text();
    image_crop.croppie('result', {
      type: 'canvas',
      size: "original", 
      format: "png",
      quality: 1
    }).then(function(response){
      $.ajax({
        url:"includes_/vehicle/upload_vehicle_main_image_edit.php",
        type: "POST",
        data:{"image": response,v_id:<?php echo $v_id ?>},
        
        cache: false,
           
        success:function(data)
        { 
          alert(data)
          $.LoadingOverlay("hide", true); 
          //$('#uploadimageContainer').modal('hide');
          if(data==1){
          	$("#vehicle_picture").attr("src","../img/vehicles/"+vehicle_image+"?timestamp"+d.getTime())
          	$("#uploadimageContainer").hide()
          }
        }
      });
    })
  });

});  
</script>

