<?php
    require_once("../../session_check.php");
    require_once("../../classes/main_classes.php");

    function create_range($max_price,$min_price){
        if($max_price!=null and $min_price!=null){
            //generate range
            $price_dif=$max_price-$min_price;
            $price_div=$price_dif/5;

            //min range
            $min_range=$price_div+$min_price;

            //generate range2
            $price_div2=$max_price/$min_range;
            $price_div2;

            $min_range2=$max_price/$price_div2;
            ceil($min_range2);


            $range_array=array();
            for ($i=1; $i <=ceil($price_div2) ; $i++) { 
                array_push($range_array, $i*$min_range2);
            } 
            return $range_array;
        }
    }

    //OBJECTS
    $rowcountObj=new ROWCOUNT();
    $allrowcountObj=new ALLROWCOUNT();
    $retrieveObj=new RETRIEVE();

    //get pricing ranges
    $get_pricing_ranges=$retrieveObj->retriever("auction","MIN(a_bid_start_price) as min_price, MAX(a_bid_start_price) as max_price","fetch");
    $max_price=$get_pricing_ranges->max_price;
    $min_price=$get_pricing_ranges->min_price;

    $range_array=create_range($max_price,$min_price);

    //get counts
    $get_running_count=$allrowcountObj->allrowcounter("auction  
      JOIN auction_images ON auction_images.a_id=auction.a_id WHERE auction_images.image_type='primary_image' and auction.a_bid_status='running' GROUP BY auction.a_id","*");
    $get_pending_count=$allrowcountObj->allrowcounter("auction  
      JOIN auction_images ON auction_images.a_id=auction.a_id WHERE auction_images.image_type='primary_image' and auction.a_bid_status='pending' GROUP BY auction.a_id","*");
    $get_closed_count=$allrowcountObj->allrowcounter("auction  
      JOIN auction_images ON auction_images.a_id=auction.a_id WHERE auction_images.image_type='primary_image' and auction.a_bid_status='closed' and auction.a_id NOT IN(SELECT auction_sold.a_id FROM auction_sold) GROUP BY auction.a_id","*");

?>
<ul class="nav nav-tabs " id="myTab" role="tablist">
    <li class="nav-item">
      <a class="nav-link active text-dark" id="running_bids-tab" data-toggle="tab" href="#running_bids" role="tab" aria-controls="running_bids" aria-selected="true">Running <small class="badge bg_primary_color text-light"><?php echo $get_running_count ?></small></a>
    </li>
    <li class="nav-item">
      <a class="nav-link text-dark" id="pending_bids-tab" data-toggle="tab" href="#pending_bids" role="tab" aria-controls="pending_bids" aria-selected="false">Pending <small class="badge badge-secondary text-light"><?php echo $get_pending_count ?></small></a>
    </li>
    <li class="nav-item ">
      <a class="nav-link text-dark" id="closed_bids-tab" data-toggle="tab" href="#closed_bids" role="tab" aria-controls="closed_bids" aria-selected="false">Closed <small class="badge badge-danger text-light"><?php echo $get_closed_count ?></small></a>
    </li>
  </ul>

  <div class="tab-content text-dark py-2">
    <div class="tab-pane fade show active" id="running_bids" role="tabpanel" aria-labelledby="running_bids-tab">
      <div class="row">
            <div class="col-lg-12 col-lg-12">
              <div class="row mt-3">
                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 my-1">
                    <select class="form-control bg-light btn" id="running_price_range" onchange="viewauctionsSpecialII(null,'running')" style="border: 1px solid #E0E6EB;">
                        <option disabled selected value="null">Price range</option>
                        <?php
                            for ($i=0; $i <count($range_array)-1 ; $i++) { 

                                $start_=$range_array[$i];
                                if($i==0){
                                    $start_=0;
                                }
                                $start=money_format("%!n", (int)$range_array[$i]);
                                $end_=$range_array[$i+1]-1;
                                $end=money_format("%!n", (int)$range_array[$i+1]-1);
                                $auctions_count=$allrowcountObj->allrowcounter("auction WHERE auction.a_bid_status='running' and a_bid_start_price>'".$start_."' and a_bid_start_price<='".$end_."'","*");
                                if($i==0){
                                    echo "<option value='".$start_." - ".$end_."'>less than MKW".$end." (".$auctions_count.")</option>";
                                }else{
                                    echo "<option value='".$start_." - ".$end_."'>MKW".$start." - MKW".$end." (".$auctions_count.")</option>";
                                }
                                
                            }
                        ?>
                    </select>
                </div>
                
                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 my-1">
                    <p class="mb-0">
                        <div class="input-group bg-light border border-light">
                            <input type="text" class="form-control rounded" name="auction_running_search_data" id="auction_running_search_data" placeholder="Search" style="border: 1px solid #E0E6EB;">
                            <button class="btn input-group-append bg_primary_color border_radius_0" onclick="search_auction(null,'running')" ><span class="fas fa-search  text-light px-0 py-1 "><span></button>
                        </div>
                    </p>
                </div>
                    
              </div>
              <div class="container-fluid mb-4" id="auction_running_sub_section">
                    <div class="row mb-4" id="running_ads">
                        <?php include("auctions_running_content.php"); ?>
                    </div>
               </div>
            </div>            
      </div>
                        
    </div>
    <div class="tab-pane fade" id="pending_bids" role="tabpanel" aria-labelledby="pending_bids-tab">
      <div class="row">
            <div class="col-lg-12 col-lg-12">
              <div class="row mt-3">
                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 my-1">
                    <select class="form-control bg-light btn" id="pending_price_range" onchange="viewauctionsSpecialII(null,'pending')" style="border: 1px solid #E0E6EB;">
                        <option disabled selected value="null">Price range</option>
                        <?php
                            for ($i=0; $i <count($range_array)-1 ; $i++) { 

                                $start_=$range_array[$i];
                                if($i==0){
                                    $start_=0;
                                }
                                $start=money_format("%!n", (int)$range_array[$i]);
                                $end_=$range_array[$i+1]-1;
                                $end=money_format("%!n", (int)$range_array[$i+1]-1);
                                $auctions_count=$allrowcountObj->allrowcounter("auction WHERE auction.a_bid_status='pending' and a_bid_start_price>'".$start_."' and a_bid_start_price<='".$end_."'","*");
                                if($i==0){
                                    echo "<option value='".$start_." - ".$end_."'>less than MKW".$end." (".$auctions_count.")</option>";
                                }else{
                                    echo "<option value='".$start_." - ".$end_."'>MKW".$start." - MKW".$end." (".$auctions_count.")</option>";
                                }
                                
                            }
                        ?>
                    </select>
                </div>
                
                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 my-1">
                    <p class="mb-0">
                        <div class="input-group bg-light border border-light">
                            <input type="text" class="form-control rounded" name="auction_pending_search_data" id="auction_pending_search_data" placeholder="Search" style="border: 1px solid #E0E6EB;">
                            <button class="btn input-group-append bg_primary_color border_radius_0" onclick="search_auction(null,'pending')" ><span class="fas fa-search  text-light px-0 py-1 "><span></button>
                        </div>
                    </p>
                </div>
                    
              </div>
              <div class="container-fluid mb-4" id="auction_pending_sub_section">
                    <div class="row mb-4" id="pending_ads">
                        <?php include("auctions_pending_content.php"); ?>
                    </div>
               </div>
            </div>            
      </div>
    </div>
    <div class="tab-pane fade" id="closed_bids" role="tabpanel" aria-labelledby="closed_bids-tab">
      <div class="row">
            <div class="col-lg-12 col-lg-12">
              <div class="row mt-3">
                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 my-1">
                    <select class="form-control bg-light btn" id="closed_price_range" onchange="viewauctionsSpecialII(null,'closed')" style="border: 1px solid #E0E6EB;">
                        <option disabled selected value="null">Price range</option>
                        <?php
                            for ($i=0; $i <count($range_array)-1 ; $i++) { 

                                $start_=$range_array[$i];
                                if($i==0){
                                    $start_=0;
                                }
                                $start=money_format("%!n", (int)$range_array[$i]);
                                $end_=$range_array[$i+1]-1;
                                $end=money_format("%!n", (int)$range_array[$i+1]-1);
                                $auctions_count=$allrowcountObj->allrowcounter("auction WHERE auction.a_bid_status='closed' and a_bid_start_price>'".$start_."' and a_bid_start_price<='".$end_."'","*");
                                if($i==0){
                                    echo "<option value='".$start_." - ".$end_."'>less than MKW".$end." (".$auctions_count.")</option>";
                                }else{
                                    echo "<option value='".$start_." - ".$end_."'>MKW".$start." - MKW".$end." (".$auctions_count.")</option>";
                                }
                                
                            }
                        ?>
                    </select>
                </div>
                
                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 my-1">
                    <p class="mb-0">
                        <div class="input-group bg-light border border-light">
                            <input type="text" class="form-control rounded" name="auction_closed_search_data" id="auction_closed_search_data" placeholder="Search" style="border: 1px solid #E0E6EB;">
                            <button class="btn input-group-append bg_primary_color border_radius_0" onclick="search_auction(null,'closed')" ><span class="fas fa-search  text-light px-0 py-1 "><span></button>
                        </div>
                    </p>
                </div>
                    
              </div>
              <div class="container-fluid mb-4" id="auction_closed_sub_section">
                    <div class="row mb-4" id="closed_ads">
                        <?php include("auctions_closed_content.php"); ?>
                    </div>
               </div>
            </div>
      </div>
            
    </div>
</div>


<script type="text/javascript">
    //load all cars on main section
    /*function load_vehicle_sub_section(){
        loading("vehicle_sub_section");
        $("#vehicle_sub_section").load("includes_/vehicle/vehicles_content.php");
    }*/
    $(document).ready(function () {
        //load_vehicle_sub_section()
    })
</script>
