<?php
	require_once("../session_check.php");
	require_once("../classes/main_classes.php");
	require_once("mailer_data.php");

	//OBJECTS
	$insertObj=new INSERT();
	$updateObj=new UPDATE();
	$retrieveObj=new RETRIEVE();
	$deleteObj=new DELETE();
	$rowcountObj=new ROWCOUNT();
	$root_dir_getObj=new ROOTDIRGET();
	$sendemailObj=new SEND_EMAIL();
	
	$mailer_r_path="../";

	//get root dir
	$root_dir=$root_dir_getObj->root_dir_getter();

	//send email
	function send_verify_email($email){
		global $rowcountObj;
		global $insertObj;
		global $deleteObj;
		global $updateObj;
		global $retrieveObj;
		global $sendemailObj;
		global $root_dir;
		global $mailer_r_path;

		$email = filter_var($email, FILTER_SANITIZE_EMAIL);
		$email = filter_var($email, FILTER_VALIDATE_EMAIL);

		if (!$email) {
		   die("<p>Invalid email address please type a valid email address!</p>");
		}

	   $expFormat = mktime(
	   	date("H"), date("i"), date("s"), date("m") ,date("d")+1, date("Y")
	   );
		$expDate = date("Y-m-d H:i:s",$expFormat);
		$key = password_hash((string)(2418*2).$email, PASSWORD_DEFAULT);

		//$addKey = substr(md5(uniqid(rand(),1)),3,10);
		//$key = $key . $addKey;
		// Insert Temp Table
		$fields=array("email","token","expdate");
		$data=array($email,$key,$expDate);
		$insert_token=$insertObj->inserter("users_account_verification",$fields,$data);

		if($insert_token!=1){
			die("<p class='alert alert-warning'>Something went wrong, try again later</p>");
		}
		 
		$output='<p>Dear '.$email.',</p>'
			;
		$output.='<p>Thanks for creating an account with SGW Auctioneers & Estate Agents. Please click the key link below to verify your email address.</p>';
		$output.='<p align="center">	
			<a href="'.$root_dir.'/includes_/account_verification.php?email='.$email.'&key='.$key.'&verify_email_note="">KEY='.$key.'</a>
		</p>'; 
		$output.='<p>
		The verification session will expire after 1 day for security reasons.</p>';
		$output.='<p>If your email is not verified in 24 hours, your account will be deleted automatically.</p>';   
		$output.='<p>Regards,</p>';
		$output.='<p><strong>SGW Auctioneers & Estate Agents TEAM</strong></p>';
		$body = $output; 
		$subject = "Verify Your Email Address - SGW Auctioneers & Estate Agents";
		 
		$email_to = $email;

		$send_email=$sendemailObj->phpmailer_send($mailer_r_path,$subject,$body,$email_to);

		if($send_email=="1"){
			return 1;
		}else{
			return 0;
		}
	}
	if(isset($_POST["resend_email"])){
		$email=addslashes($_POST["resend_email"]);
		echo send_verify_email($email);
	}

	if(isset($_POST["verify_email_note"]) and !empty($_POST["verify_email_note"]) and isset($_POST["email"]) and !empty($_POST["email"])){
		if(empty($_POST["verification_code"])){

		}
		$key=$_POST["verify_email_note"];
		$email=$_POST["email"];
		$verification_code=addslashes($_POST["verification_code"]);

		//get token
        $get_token_2=$retrieveObj->retriever("users_verify_email","*","verification_code='$verification_code' and email",$email,"verify_email_id","DESC","fetch");
        if($get_token_2=="1020"){
            die("<p class='alert alert-warning'>Something went wrong, try restarting the password reset process</p>");
        }

        $md5_token=$get_token_2->token_2;
        if($md5_token!=$key){
        	die("<p class='alert alert-warning'>The system has detected a security problem in the Email verification process, It may be because you are trying to verify an email that does not belong to you. If this is really your email and the problem keeps of occuring even if the restart the verification process, contact the super user administrator</p>");
        }

		$update_password=$updateObj->updater("users","account_verify_status='verified'","email",$email);

		if($update_password==1){
			$deleteObj->deleter("users_verify_email","email",$email);
			echo 1;
		}else{
			die("<p class='alert alert-warning'>We could not verify your email, please try again later.</p>");
		}
	}

	//USER SIGNUP
	if(isset($_POST["user_signup_note"])){
		//VALIDATION
		if(empty($_POST["firstname"])){
			die("<p class='alert alert-warning'>Enter your firstname</p>");
		}else if(empty($_POST["lastname"])){
			die("<p class='alert alert-warning'>Enter your lastname</p>");
		}else if(empty($_POST["email"])){
			die("<p class='alert alert-warning'>Enter your email</p>");
		}else if(empty($_POST["phone_code"])){
			die("<p class='alert alert-warning'>Select phone code</p>");
		}else if(empty($_POST["phone"])){
			die("<p class='alert alert-warning'>Enter your phone number</p>");
		}else if(empty($_POST["address"])){
			die("<p class='alert alert-warning'>Enter your address</p>");
		}else if(empty($_POST["password"])){
			die("<p class='alert alert-warning'>Enter your password</p>");
		}else if(empty($_POST["rpassword"])){
			die("<p class='alert alert-warning'>Re-enter your password</p>");
		}else if($_POST["password"]!=$_POST["rpassword"]){
			die("<p class='alert alert-warning'>Passwords do not match</p>");
		}else if(strlen($_POST["password"])<8){
			die("<p class='alert alert-warning'>Your password is too short, Make sure your password is has at least 8 characters</p>");
		}

		//GET VALUES
		$firstname=addslashes($_POST["firstname"]);
		$lastname=addslashes($_POST["lastname"]);
		$email=addslashes($_POST["email"]);
		$phone_code=addslashes($_POST["phone_code"]);
		$phone=addslashes($_POST["phone"]);
		$address=addslashes($_POST["address"]);
		$password=addslashes($_POST["password"]);

		//Generate hash
		$password=password_hash($password, PASSWORD_DEFAULT);

		$phone=ltrim($phone, '0');
		$phone=$phone_code.$phone;

		$fields=array("firstname","lastname","email","phone","address","password");
		$data=array($firstname,$lastname,$email,$phone,$address,$password);

		$insert=$insertObj->inserter("users",$fields,$data);

		if($insert=="1"){
			//get user id
			$get_user=$retrieveObj->retriever("users","*","users.email",$email,"user_id","DESC","fetch");
			$get_user_id=$get_user->user_id;

			$get_user_id=$retrieveObj->retriever("users","*","email",$email,"fetch");
			if( $get_user_id!="1020"){
				$get_role_id=$retrieveObj->retriever("user_role","*","user_role","customer","fetch");
				//insert role
				$fields2=array("user_id","role_id");
				$data2=array($get_user_id->user_id,$get_role_id->role_id);

				$create_account2=$insertObj->inserter("user_roles",$fields2,$data2);
				if($create_account2=="1"){
					//send email
					$send_verification_email=send_verify_email($email);
		 		    if($send_verification_email==0) {
		 		        $deleteObj->deleter("users","user_id",$get_user_id->user_id);
		 		        echo "<p class='alert alert-warning'>Sorry, We could not create your account, please try again later</p>";
		 		    }else if($send_verification_email==1){
						//echo "<p class='alert alert-success'>Account created, please login</p>";
						echo 1;
					}
					echo 1;
				}else{
					//failed
					$deleteObj->deleter("users","email",$email);
					echo 0;
				}
			}else{
				//failed
				$deleteObj->deleter("users","email",$email);
				echo 0;
			}

					
			

		}else if ($insert=="0"){
			echo 0;
		}else if($insert=="entry_exists"){
			die("<p class='alert alert-warning'>The email you entered is already registered by another user</p>");
		}else{
			die("<p class='alert alert-warning'>Something went wrong, please try again later</p>");
		}

	}

	//USER SIGNIN
	if(isset($_POST["user_signin_note"])){
	 	if(!empty($_POST["email"]) and !empty($_POST["password"])){
	 		$email=addslashes($_POST["email"]);
	 		$password=addslashes($_POST["password"]);
	 		
	 		//get user info
	 		$getUserInfo=$retrieveObj->retriever("users
	 			JOIN user_roles ON user_roles.user_id=users.user_id
			JOIN user_role ON user_roles.role_id=user_role.role_id","*","user_role.user_role='customer' and email",$email,"fetch");

	 		if($getUserInfo!="1020"){
	 			//get password
		 		$hash=$getUserInfo->password;

		 		if(password_verify($password, $hash)){
		 			//verify email
			 			/*if($getUserInfo->account_verify_status!="verified"){
			 				die("verify_account");
			 			}*/
 					if (session_status() == PHP_SESSION_NONE) {
					  session_start();
					}
		 			$_SESSION["sgw_user_in_email"]=$getUserInfo->email;
		 			$_SESSION["sgw_user_in_id"]=$getUserInfo->user_id;
		 			$_SESSION["sgw_user_in_type"]=$getUserInfo->user_id;
		 			echo 1;
	 				
		 		}else{
		 			echo "<p class='alert alert-warning'>Password is wrong</p>";
		 		}
	 		}else{
	 			echo "<p class='alert alert-warning'>The email you entered is not registered</p>";
	 		}	
	 	}else{
	 		echo "<p class='alert alert-warning'>Email or Password is empty</p>";
	 	}
	 
	}

	//USER SIGN OUT
	if(isset($_POST["user_signout_note"])){
		try{
			unset($_SESSION['sgw_user_in_email']);
			unset($_SESSION['sgw_user_in_id']);
			unset($_SESSION['sgw_user_in_type']);
			session_destroy();
			echo 1;
		}catch(Exception $e){
			echo 0;
		}
	}

	//RESET PASSWORD send email
	if(isset($_POST["reset_password_email"])){
		global $rowcountObj;
		global $insertObj;
		global $deleteObj;
		global $updateObj;
		global $retrieveObj;
		global $sendemailObj;
		global $root_dir;
		global $mailer_r_path;

		if(empty($_POST["reset_password_email"])){
			die("<p class='alert alert-warning'>Enter your email</p>");
		}
		$email = $_POST["reset_password_email"];
		$email = filter_var($email, FILTER_SANITIZE_EMAIL);
		$email = filter_var($email, FILTER_VALIDATE_EMAIL);

		if (!$email) {
		   die("<p>Invalid email address please type a valid email address!</p>");
		}else{
		   if (!($rowcountObj->rowcounter("users","*","email",$email)>=1)){
		   		die("<p class='alert alert-warning'>No user is registered with this email address!</p>");
		   }
		}

	   $expFormat = mktime(
	   	date("H"), date("i"), date("s"), date("m") ,date("d")+1, date("Y")
	   );
		$expDate = date("Y-m-d H:i:s",$expFormat);
		$key = password_hash((string)(2418*2).$email, PASSWORD_DEFAULT);

		$fields=array("email","token","expdate");
		$data=array($email,$key,$expDate);
		$insert_token=$insertObj->inserter("password_reset",$fields,$data);

		if($insert_token!=1){
			die("<p class='alert alert-warning'>Something went wrong, try again later</p>");
		}
		 
		$output='<p>Dear '.$email.',</p>'
			;
		$output.='<p>Please click on the following button to reset your password.</p>';
		$output.='<p align="center">	
			<a href="'.$root_dir.'/includes_/reset_password.php?email='.$email.'&key='.$key.'&reset_password_note="">KEY='.$key.'</a>
		</p>'; 
		$output.='<p>
		The reset session will expire after 1 day for security reason.</p>';
		$output.='<p>If you did not request this forgotten password email, no action 
		is needed, your password will not be reset. However, you may want to log into 
		your account and change your security password.</p>';   
		$output.='<p>Thanks,</p>';
		$output.='<p><strong>SGW Auctioneers & Estate Agents TEAM</strong></p>';
		$body = $output; 
		$subject = "Password Recovery - SGW Auctioneers & Estate Agents";

		/*echo $output;
		die();*/
		 
		$email_to = $email;
		$send_email=$sendemailObj->phpmailer_send($mailer_r_path,$subject,$body,$email_to);

		if($send_email=="1"){
			echo 1;
		}else{
			echo 0;
		}
	   
	}


	if(isset($_POST["reset_password_note"]) and !empty($_POST["reset_password_note"]) and isset($_POST["email"]) and !empty($_POST["email"])){
		$key=$_POST["reset_password_note"];
		$email=$_POST["email"];

        //VALIDATION
		if(empty($_POST["password"])){
			die("<p class='alert alert-warning'>Enter new password</p>");
		}else if(empty($_POST["repeat_password"])){
			die("<p class='alert alert-warning'>Re-enter new password</p>");
		}else if($_POST["password"]!=$_POST["repeat_password"]){
			die("<p class='alert alert-warning'>Passwords do not match</p>");
		}else if(strlen($_POST["password"])<8){
			die("<p class='alert alert-warning'>Make sure your password length is not less than 8 characters long</p>");
		}

		$password=addslashes($_POST["password"]);
		$password_hash=password_hash($password, PASSWORD_DEFAULT);

		//check if the password entered is equal the current password
        $get_current_password=$retrieveObj->retriever("users","*","email",$email,"fetch");
        if($get_current_password=="1020"){
            die("<p class='alert alert-warning'>Something went wrong, restarting the password reset process</p>");
        }
        if(password_verify($password, $get_current_password->password)){
        	die("<p class='alert alert-warning text-center'>Password entered is equal to the current password</p>");
        }

		$update_password=$updateObj->updater("users","password='$password_hash'","email",$email);

		if($update_password==1){
			$deleteObj->deleter("password_reset","email",$email);
			die("<p class='alert alert-success'>Password reset successful, please login with the new password.</p>");
		}else{
			die("<p class='alert alert-warning'>Password reset failed try again later</p>");
		}
	}
?>




