<?php
  require_once("../session_check.php");
  require_once("../../classes/main_classes.php");

  //OBJECTS
  $retrieveObj=new RETRIEVE();
  $rowcountObj=new ROWCOUNT();
  $allrowcountObj=new AllROWCOUNT();

  $get_news=$retrieveObj->retriever("news ORDER BY n_id DESC","*","fetchAll");
  $get_latest_donation=$retrieveObj->retriever("donation_status ORDER BY ds_id DESC","*","fetch");
  $get_ppp=$retrieveObj->retriever("psl_plant_purchased ORDER BY ppp_id DESC","*","fetch");

  $get_donations_=$retrieveObj->retriever("donation_status ORDER BY ds_id DESC LIMIT 5","*","fetchAll");
  $get_ppp_=$retrieveObj->retriever("psl_plant_purchased ORDER BY ppp_id DESC LIMIT 5","*","fetchAll");
?>

<div class="px-2 py-3 mb-4" style="background-color: white;">
  <h4 class="lead bg-white mb-0">
    <span class="fas fa-home"></span>
    Home
  </h4>
</div>

<!--***** REPORT-1 *****-->     
<div class="row" id="report1">
  <div class="col-12 col-sm-6 col-md-3 col-lg-3">
        <div class="card">
            <div class="card-block">
                <div class="text-left report1-cont">
                    <h2 class="font-light m-b-0 h4">
                      <i class="fas fa-hand-holding-usd text-secondary"></i>
                      Donations
                    </h2>
                    <span class="text-muted">
                      MKW 
                      <?php
                        if($get_latest_donation!="1020"){
                          echo number_format($get_latest_donation->ds_amount);
                        }
                      ?>
                    </span>
                </div>
                <!--div class="mb-2">
                  <hr class="my-2" style="margin-right: 30px;">
                  <p class="text-dark mb-0 text-right" style="margin-right: 30px;"> 
                    &nbsp;
                  </p>
                  <p class="text-dark mb-0 text-right" style="margin-right: 30px;">
                   &nbsp;
                  </p>
                </div-->
            </div>
        </div>
    </div>
  <div class="col-12 col-sm-6 col-md-3 col-lg-3">
        <div class="card">
            <div class="card-block">
                <div class="text-left report1-cont">
                    <h2 class="font-light m-b-0 h4">
                      <i class="fas fa-newspaper text-secondary"></i>
                      News
                    </h2>
                    <span class="text-muted">
                      <?php
                        echo $allrowcountObj->allrowcounter("news","*");
                      ?>
                    </span>
                </div>
                
            </div>
        </div>
    </div> 
    <div class="col-12 col-sm-6 col-md-3 col-lg-3">
        <div class="card">
            <div class="card-block">
                <div class="text-left report1-cont">
                    <h2 class="font-light m-b-0 h4">
                      <i class="fas fa-cash-register text-secondary"></i>
                      PSA Purchases
                    </h2>
                    <span class="text-muted">
                      <?php
                        if($get_ppp!="1020"){
                          echo number_format($get_ppp->ppp_number);
                        }
                      ?>
                    </span>
                </div>
                
            </div>
        </div>
    </div> 
    <div class="col-12 col-sm-6 col-md-3 col-lg-3">
        <div class="card">
            <div class="card-block">
                <div class="text-left report1-cont">
                    <h2 class="font-light m-b-0 h4">
                      <i class="fas fa-users text-secondary"></i>
                      Users
                    </h2>
                    <span class="text-muted">
                      <?php
                        echo $allrowcountObj->allrowcounter("users","*");
                      ?>
                    </span>
                </div>
                
            </div>
        </div>
    </div> 
    
   
</div>

<!--***** REPORT-3 *****-->     
<div class="row" id="report3">
    <div class="col-md-6">
        <div class="card card-c2 p-3">
            <div class="card-header">
              <span class="fas fa-hand-holding-usd"></span>
              Latest Donation Updates
            </div>
            <div class="card-body">
              <table class="table table-responsive-lg table-hover" >
                <thead>
                  <tr>
                    <th>Date</th>
                    <th>Total Amount</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                      
                      if($get_donations_!="1020"){
                        foreach ($get_donations_ as $donations_) {
                      ?>
                        <tr >
                          
                          <td>
                            <?php 
                              if(!empty($donations_->ds_date)){
                                echo date("d-m-Y H:i:s", strtotime($donations_->ds_date));
                              } 
                            ?>
                          </td>
                          <td>MKW <?php echo number_format($donations_->ds_amount);  ?></td>
                          
                        </tr>
                      <?php
                        }
                      } 
                    ?>
                </tbody>
            </table>
            </div>
        </div>
    </div> 
    <div class="col-md-6">
        <div class="card card-c2 p-3">
            <div class="card-header">
              <span class="fas fa-cash-register"></span>
              Latest Total PSA Plants Purchase
            </div>
            <div class="card-body">
              <table class="table table-responsive-lg table-hover" >
                <thead>
                  <tr>
                    <th>Date</th>
                    <th>Total Purchased</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                      
                      if($get_ppp_!="1020"){
                        foreach ($get_ppp_ as $ppp_) {
                      ?>
                        <tr >
                          
                          <td>
                            <?php 
                              if(!empty($ppp_->ppp_date)){
                                echo date("d-m-Y H:i:s", strtotime($ppp_->ppp_date));
                              } 
                            ?>
                          </td>
                          <td><?php echo $ppp_->ppp_number;  ?></td>
                          
                        </tr>
                      <?php
                        }
                      } 
                    ?>
                </tbody>
            </table>
            </div>
        </div>
    </div> 
</div>

