 <?php
	include("connection/Functions.php");
	$operation = new Functions();

	//get donations
	$donations = $operation->retrieveSingle("SELECT * FROM `donation_status` ORDER BY ds_id DESC");
	$plants = $operation->retrieveSingle("SELECT * FROM `psl_plant_purchased` ORDER BY ppp_id DESC");
	$news = $operation->retrieveMany("SELECT * FROM `news`  WHERE n_status = 'active' ORDER BY n_id DESC  LIMIT 2");
 ?>

<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="utf-8">
<meta name="description" content="The second wave of the covid-19 pandemic has hit Malawi hard. Hospitals are suffocating, systems are overwhelmed. There is a shortage of cylinders and concentrators – essential for the supply of oxygen to covid patients. Diagnostic kits are also in short supply, as is personal protective equipment. Apart from that, essential medicines are in insufficient amounts. The government is doing the best it can, but all systems are overstretched, and critical gaps have emerged. This calls for all hands on deck. Because of this, citizens came together to crowdfund and cover any gaps that cannot be covered by the government’s efforts.">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="keywords" content="Covid, Malawi, Response, Private, Citizens, Donations, Malawi, Corona, Pandemic, Non profit, Oxygen, Cylinder, Hospitals, Pressure, Swing, Absorption, PSA" />
<meta name="author" content="NetSoft Malawi">
<meta name="viewport" content="width=device-width, initial-scale=1">

<!-- Title -->
<title>Covid Response Private Citizens</title>

<!-- Favicon -->
<link rel="shortcut icon" type="image/png" href="assets/images/fevicon.png">

<!-- Bootstrap CSS -->
<link rel="stylesheet" href="assets/css/bootstrap.min.css">

<!-- Font awesome CSS --
<link rel="stylesheet" href="assets/css/font-awesome.min.css"-->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.2/css/all.min.css">
<!-- Animate CSS -->
<link rel="stylesheet" href="assets/css/animate.min.css">

<!-- OwlCarousel CSS -->
<link rel="stylesheet" href="assets/css/owl.carousel.min.css">

<!-- Magnific popup CSS -->
<link rel="stylesheet" href="assets/css/fancybox.min.css">

<!-- Main CSS -->
<link rel="stylesheet" href="style.css">
<link rel="stylesheet" href="organizers.css">
<link rel="stylesheet" href="blog-style.css">

<!-- Responsive CSS -->
<link rel="stylesheet" href="assets/css/responsive.css">

<!-- Red color CSS -->
<link rel="stylesheet" href="assets/css/color-red.css">

<!-- jQuery -->
<script src="assets/js/jquery-3.4.1.min.js"></script>
</head>
<body>
<div class="main-wrapper">

<!-- Preloader start -->
  <div class="site-preloader-wrapper">
   <div class="preloader-block"> 
     <div class="logo"> <a href="index.php" title="Covid Response Private Citizens">Covid Response Private Citizens</a> </div>
     <div class="bar"></div>
   </div>  
  </div>
<!-- Preloader End -->

  <header class="for-sticky"> 
    <!-- Header area start -->
    <div class="container-fluid">
      <div class="header-block"> 
        <!-- Site logo Start -->
        <div class="logo"> <a href="index.php" title="Covid Response Private Citizens">Covid Response Private Citizens</a> </div>
        <!-- Site logo end --> 
        
        <!-- Main menu start -->
        <nav class="mainmenu home-nav">
          <ul id="navigation">
            <li class="nav-active"><a href="#home" title="Home">Home</a></li>
            <li><a href="#about-us" title="About Us">About Us</a></li>
            <li><a href="#news" title="News &amp; Events">News &amp; Events</a></li>
            <li><a href="#contact" title="Contact">Contact</a></li>
            <li><a href="#updates_covid" title="COVID-19 Updates">COVID-19 Updates</a></li>
            <li><a href="#organizers" title="Organizers">Organizers</a></li>
            <!--li><a href="#" title="Pages">Pages</a>
              <ul>
                <li><a href="index.php" title="Home with color 1">Home with color 1</a></li>
                <li><a href="home-slider-color-2.php" title="Home Slider with color 2">Home Slider with color 2</a></li>
                <li><a href="bg-video-color-3.php" title="Home bg video with color 3">Home bg video with color 3</a></li>
                <li><a href="rtl-version-color-4.php" title="RTL Version with color 4">RTL Version with color 4</a></li>
                <li><a href="gallery.php" title="Gallery page">Gallery page</a></li>
                <li><a href="donate.php" title="Cause Details with donate">Cause Details with donate</a></li>
              </ul>
            </li-->
          </ul>
        </nav>
        <!-- Main menu end -->
        <div class="header-login-link">
          <ul>
<!--
            <li><a href="#" title="" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false"><img src="assets/images/flag-1.png" alt=""/> EN</a>
              <ul class="dropdown-menu">
                <li><a href="" title=""><img src="assets/images/flag-1.png" alt=""/> EN</a></li>
                <li><a href="" title=""><img src="assets/images/flag-2.png" alt=""/> TR</a></li>
                <li><a href="" title=""><img src="assets/images/flag-3.png" alt=""/> BR</a></li>
                <li><a href="" title=""><img src="assets/images/flag-4.png" alt=""/> SR</a></li>
              </ul>
            </li>
-->
          </ul>
        </div>
        <div class="header-button"><a href="donate.php" title="">Donate</a></div>
        <div class="mobile-menu-wrapper home-nav"></div>
      </div>
    </div>
    <!-- Header area End --> 
  </header>
  
  <!-- Slider Start -->
  <section id="home">
    <div class="homepage-slides-wrapper">
    <div class="owl-carousel homepage-slides text-center"> 
      <!-- Slider item1 start-->
      <div class="single-slide-item slider-overlay slide-bg-1">
        <div class="item-table">
          <div class="item-tablecell">
            <div class="container">
              <div class="row">
                <div class="col-lg-10 offset-lg-1">
                 <h2>Stay Home<br>
                  Stay Safe With Your Family.</h2>
                 <h3>Covid-19 is a deadly virus, let's fight it  together</h3>
                 <p class="" style="visibility: hidden;">Lorem Ipsum</p>
              </div>
            </div>
          </div>
        </div>
       </div>
      </div>
      <!-- Slider item1 end--> 
      
      <!-- Slider item2 start-->
      <div class="single-slide-item slider-overlay slide-bg-2">
        <div class="item-table">
          <div class="item-tablecell">
            <div class="container">
              <div class="row">
                <div class="col-lg-10 offset-lg-1">
                  <h2>Your <br>
                  Contribution Matters</h2>
                 <h3>Save the Beautiful Souls in our Hospitals</h3>
                 <p class="" style="visibility: hidden;">Lorem Ipsum</p>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-- Slider item2 end--> 
    </div>
   </div>
  </div>
    
    <div class="featured-fund-sec">
      <div class="container">
        <div class="featured-fund">
          <div class="featured-fund-left">
            <div class="featured-fund-raise">
              <div class="featured-fund-raise-block">
                <div class="progress ">
                  <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100" style="width: 50%"><span></span></div>
                </div>
                <div class="raise-total "> <span class=""><b>K<?=number_format($donations['ds_amount'],2)?></b> raised</span></div>
                <div class="text-center mt-2"><a href="donate.php" title="" class="main-btn feature-main-btn">Donate Now</a></div>
              </div>
            </div>
<!--
            <div class="featured-fund-end">
              <div class="timer">
                <div class="days"></div>
                <div class="hours"></div>
                <div class="minutes"></div>
                <div class="seconds"></div>
                <input type="hidden" class="end_time" value="1 April 2021 9:56:00 GMT+01:00" />
              </div>
            </div>
-->
          </div>
          <div class="featured-fund-right">
            <h3>Fund collections </h3>
            <p>We have successfully purchased <?=$plants['ppp_number']?> Cylinders/Flowmeters. </p>
            <p>We are still collecting funds to save more lives.</p>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- Slider End -->
  
<section id="about-us"> 
    <!-- Other Causes start -->
    <div class="page-content-block py-3 " style="background: #3399cc;">
      <div class="container ">
        <div class="row">
            <div class="col-12">
                <h2 class="title-bottom-border text-light">Background</h2>
				<p class="text-justify text-light">
					The second wave of the covid-19 pandemic has hit Malawi hard. Hospitals are suffocating, systems are overwhelmed. There is a shortage of cylinders and concentrators – essential for the supply of oxygen to covid patients. Diagnostic kits are also in short supply, as is personal protective equipment. Apart from that, essential medicines are in insufficient amounts. The government is doing the best it can, but all systems are overstretched, and critical gaps have emerged. This calls for all hands on deck. Because of this, citizens came together to crowdfund and cover any gaps that cannot be covered by the government’s efforts.
				</p>
            </div>
        </div>
          
      </div>
    </div>
    <!-- Other Causes End --> 
  </section>

	
	
  <section id=""> 
    <!-- Our Mission Start -->
    <div class="page-content-block">
      <div class="container">
        <div class="row"> 
          <!-- Factory Gallery start -->
          <div class="col-12 col-lg-4">
            <div class="mission-picture"> <img src="assets/images/objectives.png" alt=""/>
<!--              <div class="video-block"> <a class="ico-video" href="https://www.youtube.com/watch?v=oytpJAVBkX8" data-fancybox><span></span></a> </div>-->
            </div>
          </div>
          <!-- Factory gallery end -->
          <div class="col-12 col-lg-7 offset-lg-1">
            <div class="mission-text">
              <h2 class="title-bottom-border">Our Objectives</h2>
              <ul>
                <li class="my-2 text-justify">
                    To raise funds by appealing to members of the general public, corporate entities, national and international charitable institutions, non-Malawian citizens and any other well-wishers for the sole purpose of contributing to and complementing government efforts in fighting the covid pandemic, with a view to responding to the covid pandemic as swiftly as circumstances permit.
                </li>
                <li class="my-2 text-justify">
                    To report and be accountable to the public for all the money collected, and to share with the public any reports or updates they might seek.
                </li>
                <li class="my-2 text-justify">
                    To liaise with suppliers to procure medicines, medical supplies and equipment in so far as such equipment is essential to the fight of the covid pandemic.
                </li>
            
                <li class="my-2 text-justify">
                    To liaise and coordinate with the government, hospitals and institutions of a similar nature, where needs be, to ensure that interventions are not duplicative or lacking in value added.
                </li>
                
              </ul>    
              

            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- Our Mission end --> 
    
    <!-- How we work Start -->
    <div class="page-content-block how-we-work green-bg">
      <div class="container">
        <div class="row">
          <div class="col-12 col-lg-8 wow fadeInRight">
            <h2 class="title-bottom-border">How do We work?</h2>
            <div class="row">
              <div class="col-12 col-lg-6">
                <div class="how-work-block"> <span>01</span>
                  <h3>We target our cause</h3>
                  <p style="width: 90%;" class="text-justify">Supply and deliver oxygen to the hospitals by purchasing and repurposing more cylinders, refilling oxygen into these cylinders and delivering to hospitals.</p>
                </div>
              </div>
              <div class="col-12 col-lg-6">
                <div class="how-work-block"> <span>02</span>
                  <h3>Fund collection start</h3>
                  <p style="width: 90%;" class="text-justify">Appeal to any other well-wishers for the sole purpose of contributing to and complementing government efforts in fighting the covid pandemic.</p>
                </div>
              </div>
              <div class="col-12 col-lg-6">
                <div class="how-work-block"> <span>03</span>
                  <h3>Repair/Purchase of PSA plant</h3>
                  <p style="width: 90%;" class="text-justify"> Pressure Swing Adsorption (PSA) plant. We plan to buy 56 oxygen cylinders, 56 flowmeters and fill in oxygen in those 56 cylinders - to be distributed two cylinders per district hospital.</p>
                </div>
              </div>
              <div class="col-12 col-lg-6">
                <div class="how-work-block"> <span>04</span>
                  <h3>Delivery to Hospitals</h3>
                  <p style="width: 90%;" class="text-justify">Pressure Swing Adsorption (PSA) plant, at the hospital near the treatment centre and reticulate pipes to each bed. The medical oxygen suppliers will refill the tank at the hospital as per demand.</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- How we work end --> 
  </section>
  <section id="updates_covid"> 
    <!-- Other Causes start -->
    <div class="page-content-block">
      <div class="container">
        <div class="row">
            <div class="col-12">
                <h2 class="title-bottom-border mb-3">MALAWI COVID-19 UPDATE</h2>
				<div class="card-deck">
				  <div class="card">
					<div class="card-header text-center bg-danger text-light">CONFIRMED</div>
					<div class="card-body text-center lead font-weight-bold" id="mwCovidConfirmed"></div>
				  </div>
				  <div class="card">
					<div class="card-header text-center text-light" style="background-color: darkred;">DEATHS</div>
					<div class="card-body text-center lead font-weight-bold" id="mwCovidDeaths"></div>
				  </div>
				  <div class="card">
					<div class="card-header text-center bg-success text-light">RECOVERED</div>
					<div class="card-body text-center lead font-weight-bold" id="mwCovidRecovered"></div>
				  </div>
				  <div class="card">
					<div class="card-header text-center bg-warning text-light">ACTIVE</div>
					<div class="card-body text-center lead font-weight-bold" id="mwCovidActive"></div>
				  </div>
				</div>
            </div>
        </div>
          
      </div>
    </div>
    <!-- Other Causes End --> 
  </section>
	
  <section id="organizers" > 
    <!-- Other Causes start -->
    <div class="page-content-block featured-fund-sec" style="background: rgba(237, 237, 237, 0.53);">
      <div class="container">
        <div class="row">
            <div class="col-12">
                <h2>Organizers</h2>
				
				<div class="container">
					<div class="row">
<!--						<div class="col-lg-1"></div>-->
					<!--team-1-->
					<div class="col-lg-4">
						<div class="our-team-main">

						<div class="team-front">
						<img src="http://placehold.it/110x110/3399cc/fff?text=Stanley" class="img-fluid" />
						<h3>Stanley Onjezani Kenani </h3>
						<p>Lead Organizer</p>
						</div>

						<div class="team-back">
						<span class="" style="">
						kenani@covid.org.mw
						</span>
						</div>

						</div>
					</div>
					<!--team-1-->

				<!--team-2-->
				<div class="col-lg-4">
				<div class="our-team-main">

				<div class="team-front">
				<img src="http://placehold.it/110x110/3399cc/fff?text=Thandi" class="img-fluid" />
				<h3>Dr. Thandi Hara </h3>
				<p>Deputy Lead Organizer</p>
				</div>

				<div class="team-back">
				<span>
				thara@covid.org.mw
				</span>
				</div>

				</div>
				</div>
				<!--team-2-->

				<!--team-3-->
				<div class="col-lg-4">
				<div class="our-team-main">

				<div class="team-front">
				<img src="http://placehold.it/110x110/3399cc/fff?text=Victor" class="img-fluid" />
				<h3>Dr. Victor Mgonjetsi Mithi</h3>
				<p>Organizer</p>
				</div>

				<div class="team-back">
				<span>
				vsmithi@covid.org.mw
				</span>
				</div>

				</div>
				</div>
				<!--team-3-->

				<!--team-4-->
				<div class="col-lg-4">
				<div class="our-team-main">

				<div class="team-front">
				<img src="http://placehold.it/110x110/3399cc/fff?text=Masankho" class="img-fluid" />
				<h3>Masankho Stable Mbizi </h3>
				<p>Organizer</p>
				</div>

				<div class="team-back">
				<span>
					kuntiya@covid.org.mw
				</span>
				</div>

				</div>
				</div>
				<!--team-4-->

				<!--team-5-->
				<div class="col-lg-4">
				<div class="our-team-main">

				<div class="team-front">
				<img src="http://placehold.it/110x110/3399cc/fff?text=Polesana" class="img-fluid" />
				<h3>Polesana Tembo </h3>
				<p>Focal point-cylinders &amp; concentrators</p>
				</div>

				<div class="team-back">
				<span>
				ptembo@covid.org.mw
				</span>
				</div>

				</div>
				</div>
				<!--team-5-->





				</div>
				</div>
				
				
            </div>
        </div>
          
      </div>
    </div>
    <!-- Other Causes End --> 
  </section>	
	

  <section id="news"> 
    <!-- News Start -->
    <div class="page-content-block news-sec">
      <div class="container">
        <div class="row">
          <div class="col-12 col-lg-7">
            <div class="news-block-section">
              <h2 class="title-bottom-border">Latest News &amp; Events</h2>
              	  
				<div class=" cta-100 ">
					<div class="">
					  <div class="row blog">
						<div class="col-md-12">
						  <div id="blogCarousel" class="carousel slide container-blog" data-ride="carousel">
<!--
							<ol class="carousel-indicators">
							  <li data-target="#blogCarousels" data-slide-to="0" class="active"></li>
							  <li data-target="#blogCarousels" data-slide-to="1"></li>
							</ol>
-->
							<!-- Carousel items -->
							<div class="carousel-inner">
								 <div >
									<div class="row">
								<?php
									$i = 0;
									foreach($news as $row){
										$active = "active";
										$i++;
										if($i >= 2){
											$active = "";
										}
										
											
										
										
										
									$date1=date_create($row['n_date_posted']);
                 					$dt1 = date_format($date1,"Y M d");
//										echo "<h2 class='text-light'>".$dt1."</h2>";
										
								?>
								 
									  <div class="col-md-6" >
										<div class="item-box-blog">
										  <div class="item-box-blog-image">
											<!--Date-->
											<div class="item-box-blog-date bg-blue-ui white"> <span class="mon"><?=$dt1?></span> </div>
											<!--Image-->
											<figure> <img alt="" src="assets/images/news/<?=$row['n_image']?>"> </figure>
										  </div>
										  <div class="item-box-blog-body">
											<!--Heading-->
											<div class="item-box-blog-heading">
											  <a href="single_article.php?view=<?=$row['n_id']?>" tabindex="0">
												<h5 style="overflow: hidden;text-overflow: ellipsis;display: -webkit-box;  -webkit-box-orient: vertical;  -webkit-line-clamp: 2; " ><?=$row['n_title']?></h5>
											  </a>
											</div>
											<!--Data-->
											<div class="item-box-blog-data" style="padding: px 15px;">
											  <p class="text-light"><i class="fa fa-user-o"></i>  </p>
											</div>
											<!--Text-->
											<div class="item-box-blog-text">
											  <div  style="" class="text-light para"><?=$row['n_body']?></div>
											</div>
											<div class="header-button"> <a href="single_article.php?view=<?=$row['n_id']?>" tabindex="0" class="">read more</a> </div>
											<!--Read More Button-->
										  </div>
										</div>
									  </div>
									  
								
							<?php
									}
							?>
							  <!--.item-->
											</div>
									<!--.row-->
								  </div>
								  <!--.item-->
							</div>
							<!--.carousel-inner-->
						  </div>
						  <!--.Carousel-->
							<div class="container">
							<div class="row ">

									<div class="col-md-3"></div>
									<div class="col-md-6">
										<div class="header-button"><a class=" text-center" href="news.php"> More News</a></div>
									</div>
									<div class="col-md-3"></div>
								</div>
							</div>
						</div>
					  </div>
					</div>
				 </div>
   

            </div>
          </div>
          <div class="col-12 col-lg-4 offset-lg-1">
            <div class="newsletter">
              <div class="newsletter-block">
                <form action="" id="subscribeForm">
                  <h2>Newsletter</h2>
                  <p>Sign up for our daily newsletter to get the latest news &amp; events.</p>
                  <input type="text" id="email" name="email" required placeholder="Enter your email" value="" class="news-input">
					<div id="responseSubscribe"></div>
                  <button type="submit" value="" id="subscribeBtn" class="news-btn">Subscribe <i class="fa fa-location-arrow"></i></button>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- News end --> 
  </section>
 

  <!-- Contact Section Start -->
  <section id="contact"> 
    <!-- Contact Form Start -->
    <div class="page-content-block contact-form-sec">
      <div class="container">
        <div class="row">
          <div class="col-12 col-lg-10 offset-lg-1">
            <div class="section-title wow fadeInUp">
              <h2>Contact Us</h2>
              <div class="title-border"><span><i class="fas fa-hand-holding-heart"></i></span></div>
<!--              <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry.</p>-->
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-12 col-md-6">
            <div class="contact-form">
              <form class="" name="sentMessage" id="contactForm" accept-charset="UTF-8" enctype="multipart/form-data">
                <div class="row">
                  <div class="form-group col-12">
                    <input type="text" class="form-control" id="name" name="name" value="" placeholder="Your Full Name" required/>
                    <span class="error1"> <i class="error-log fa fa-exclamation-triangle"></i> This field is required </span>
                  </div>
                </div>
                <div class="row">
                  <div class="form-group col-12">
                    <input type="email" id="email" name="email" required class="form-control" value="" placeholder="Email"/>
					  <span class="error1"> <i class="error-log fa fa-exclamation-triangle"></i> This field is required </span>
                  </div>
                </div>
                <div class="row">
                  <div class="form-group col-12">
                    <input type="text" class="form-control" id="phone" name="phone" value="" placeholder="Phone Number" required/>
					  <span class="error1"> <i class="error-log fa fa-exclamation-triangle"></i> This field is required </span>
                  </div>
                </div>
                <div class="row">
                  <div class="form-group col-12">
                    <textarea required class="form-control" id="message" name="message" placeholder="Message"></textarea>
					  <span class="error1"> <i class="error-log fa fa-exclamation-triangle"></i> This field is required </span>
                  </div>
                </div>
                <div class="row">
					<div id="loginResponse"></div>
                  <div class="form-group col-12 text-right">
                    <button id="loginBtn" type="submit" class="main-btn mt-0">Submit</button>
                  </div>
                </div>
              </form>
            </div>
          </div>
          <div class="col-12 col-md-6 col-lg-5 offset-lg-1">
            <div class="address">
              <h2 class="title-bottom-border">Our Address</h2>
              <div class="address-block">
                <ul>
<!--
                  <li class="address-icon"><strong>Adderss:</strong><br>
                    Lorem Ipsum is simply dummy text of the printing and typesetting industry.</li>
-->
                  <li class="phone-icon"><strong>Telephone No:</strong><br>
                    +41767563588, +447888712327, +265994642331, +265999961000, +265888866033</li>
               
                  <li class="email-icon"><strong>Email:</strong><br>
                    <a href="mailto:response@covid.org.mw" title="">response@covid.org.mw</a></li>
                </ul>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- Contact Form End --> 
  </section>
  <!-- Contact Section End --> 
  
  <!-- Footer start -->
  <footer class="site-footer"> 
    <!-- Footer Top start -->
    <div class="footer-top-area">
      <div class="container">
        <div class="row flex-lg-row-reverse">
          <div class="col-12 col-lg-9">
            <div class="counter-block">
           
             
              <div class="counter-holder"> <span class="counter-icon"><img src="assets/images/complete-project-icon.png" alt="Supporter" /></span><span>K<?=number_format($donations['ds_amount'])?></span> 
                <h5>Total Amount Raised</h5>
              </div>
			
			<div class="counter-holder"> <span class="counter-icon"><img src="assets/images/supporter-icon.png" alt="Supporter" /></span> <span></span><span class="counter" data-count="<?=$plants['ppp_number']?>"></span>
                <h5>PSA Plants/Cyclinders Purchased</h5>
             </div>
				
				<div class="counter-holder"> <div class="bg-light"><a class="py-2 btn" href="donate.php" title="">Donate</a></div>
              </div>
				
            </div>
          </div>
          <div class="col-12 col-lg-3">
            <div class="social-block">
              <h4>Connect with us</h4>
              <div class="bottom-social"> <a href="https://www.facebook.com/stanley.kenani"><i class="fab fa-facebook-f"></i><span>Facebook</span></a> <a href="https://twitter.com/onjezani"><i class="fab fa-twitter"></i><span>Twitter</span></a> </div>
            </div>
          </div>
          
        </div>
      </div>
    </div>
    <!-- footer top end --> 
    
    <!-- copyright start -->
    <div class="footer-bottom-area">
      <div class="container">
        <div class="row">
          <div class="col-12 col-md-6 wow fadeInLeft">&copy; <script>document.write(new Date().getFullYear());</script> <span>Covid Response Private Citizens</span>.All Rights Reserved</div>
          <div class="col-12 col-md-6 text-right wow ">Design &amp; Development By: <a href="https://netsoftmw.com/" title="NetSoft Malawi" target="_blank">NetSoft Malawi</a></div>
        </div>
      </div>
    </div>
    <!-- copyright end --> 
  </footer>
  <!-- Footer end --> 
</div>
<!-- Main Wrapper end -->

<div class="scrollup"><i class="fa fa-angle-up"></i></div>
<!-- Footer end --> 

<!-- Tether JS --> 
<script src="assets/js/tether.min.js"></script> 

<!-- Popper JS --> 
<script src="assets/js/popper.min.js"></script> 

<!-- Bootstrap JS --> 
<script src="assets/js/bootstrap.min.js"></script> 

<!-- OwlCarousel JS --> 
<script src="assets/js/owl.carousel.min.js"></script> 

<!-- SlickNav JS --> 
<script src="assets/js/jquery.slicknav.min.js"></script> 

<!-- fancybox Popup JS --> 
<script src="assets/js/jquery.fancybox.min.js"></script> 

<!-- WOW JS --> 
<script src="assets/js/wow-1.3.0.min.js"></script> 

<!-- Step Form with validate --> 
<script src="assets/js/jquery.validate.js"></script> 
<script src="assets/js/form-step.js"></script> 

<!-- Youtube JS --> 
<script src="assets/js/youtube-background.js"></script> 

<!-- Coming Soon JS --> 
<script src="assets/js/coming-soon.js"></script> 

<!-- Active JS --> 
<script src="assets/js/active.js"></script>
<script src="assets/js/contact_me.js"></script>
	
	<script type="text/javascript">
  $(document).ready(function(){
    var malawi_covid_update;

    fetch('https://api.covid19api.com/live/country/malawi/status/confirmed/date/<?php echo date('Y-m-d', strtotime(date("Y-m-d")." -1 days"))  ?>T00:00:00Z')
      .then(res => res.json())
      .then(data => malawi_covid_update = data)
      .then(() => $("#mwCovidConfirmed").html(malawi_covid_update[0]["Confirmed"]))
      .then(() => $("#mwCovidDeaths").html(malawi_covid_update[0]["Deaths"]))
      .then(() => $("#mwCovidRecovered").html(malawi_covid_update[0]["Recovered"]))
      .then(() => $("#mwCovidActive").html(malawi_covid_update[0]["Active"]))
  })
    
</script>
</body>
</html>
