<?php
  require_once("../session_check.php");
  require_once("../../classes/main_classes.php");

  //OBJECTS
  $retrieveObj=new RETRIEVE();

  $get_contact_messages=$retrieveObj->retriever("contact_messages ORDER BY contact_message_id DESC","*","fetchAll");
?>

<div class="page-header flex-wrap">
  <h3 class="page-title "> 
    Contact messages
  </h3>
</div>
<div class="row">
  <div class="col-xl-12 col-lg-12 stretch-card grid-margin">
    <div class="card bg_primary_dark_ascent p-3">
        <div class="card-header bg-white px-0 border_0">
          <div class="font-weight-bold">Contact messages</div>
          <div class="row">
            <div class="col-md-12" id="delete_contact_message_response"></div>
          </div>
        </div>
        <div class="table-responsive p-2">
          <!-- Projects table -->
          <table class="table align-items-center table-flush" id="contact_messages_table">
            <thead class="text-dark">
              <tr>
                <th scope="col">Fullname</th>
                <th scope="col">Email</th>
                <th scope="col">Phone</th>
                <th scope="col">Subject</th>
                <th scope="col">Date</th>
                <th scope="col">Options</th>
              </tr>
            </thead>
            <tbody>
              <?php
              if($get_contact_messages!="1020"){
                $element_id="element_id";
                  foreach ($get_contact_messages as $contact_message) {
                    $element_id=$element_id."Ot";
            ?>  
                <tr id="<?php echo $element_id ?>"> 
                  <td>
                    <?php 
                      echo $contact_message->firstname." ".$contact_message->lastname;
                    ?>
                  </td>
                  <td>
                    <a href="mailto:<?php echo $contact_message->email ?>">
                      <u>
                        <?php 
                          echo $contact_message->email;
                        ?>
                      </u>
                    </a>
                  </td>
                  <td>
                    <a href="tel:<?php echo $contact_message->phone ?>">
                      <u>
                        <?php 
                          echo $contact_message->phone;
                        ?>
                      </u>
                    </a>
                  </td>
                  <td>
                    <?php 
                      echo $contact_message->subject;
                    ?>
                  </td>
                  <td>
                    <span style="display:none;"><?php echo strtotime($contact_message->date_added) ?></span>
                    <?php echo date("M j, Y", strtotime($contact_message->date_added))."<br> @".date("H:i A", strtotime($contact_message->date_added)); ?>
                  </td>
                  <td id="<?php echo $element_id.'Dbtn' ?>">
                      <div class="">
                        <a href="#contact-message-details-view" title="Details" class="btn btn-sm hand_cursor text-light btn-primary my-1 px-2" onclick="contact_message_details_view(<?php echo $contact_message->contact_message_id ?>)"><span class="fas fa-info-circle"></span></a>

                        <?php
                          if($user_in_type=="su_admin"){
                        ?>
                          <form id="<?php echo 'R'.$element_id.'form' ?>" class="mb-0 hand_cursor" style="display: inline;">
                              <input type="hidden" name="delete_contact_message_note" value="<?php echo $contact_message->contact_message_id; ?>">
                              <button id="<?php echo $element_id.'Rbtn' ?>" onclick="delete_contact_message('<?php echo 'R'.$element_id.'form' ?>','<?php echo $element_id; ?>','delete_contact_message_response')" type="submit" title="Delete" class="btn btn-sm text-light hand_cursor btn-danger my-1 px-2"><span class="fas fa-times"></span></button>
                          </form>
                        <?php
                          }
                        ?>
                        
                      </div>  
                      
                  </td>
                </tr>
              <?php
                  }
                }
              ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">
  $(document).ready(function () {
    var table = $('#contact_messages_table').DataTable({
      columnDefs: [
        {bSortable: false, targets: [5]} 
      ],
      order: [[4, 'desc']],
      language: {
        paginate: {
          next: '&#8594;', // or '→'
          previous: '&#8592;' // or '←' 
        }
      }
    });
  })
</script>