<?php
  require_once("../../session_check.php");
  require_once("../../../classes/main_classes.php");

  if(!isset($_POST["SchoolRegisterRequestId"])){
    die("<p class='alert alert-warning'>Invalid request</p>");
  }

  $SchoolRegisterRequestId=addslashes($_POST["SchoolRegisterRequestId"]);

  //OBJECTS
  $retrieveObj=new RETRIEVE();
  $updateObj=new UPDATE();

  $SchoolRegisterRequestDetails=$retrieveObj->retriever("SchoolRegisterRequests
    JOIN Schools ON Schools.SchoolID=SchoolRegisterRequests.SchoolID
    JOIN Users ON Users.UserId=SchoolRegisterRequests.UserId
    JOIN SchoolTypes ON SchoolTypes.SchoolTypeId=Schools.SchoolTypeId","*","SchoolRegisterRequestId",$SchoolRegisterRequestId,"fetch");

  if($SchoolRegisterRequestDetails=="1020"){
    die("<p class='alert alert-warning mt-2'>Message details not found. This could be because the message was deleted.</p>");
  }
?>
<div class="page-header flex-wrap">
  <h3 class="page-title"> 
    Register Requests
  </h3>
  <p class="mt-1">
    <a href="#register-request-view" onclick="register_requests_view()" class="text_cprimary_color"><u>Register Request</u></a> > 
      <span>Register Details > <?php echo $SchoolRegisterRequestDetails->SchoolName; ?></span>
  </p>
</div>
<div class="row">
  <div class="col-xl-12 col-lg-12 mb-3">
    <div class="card">
      <div class="card-body p-3">
        <div class="card-deck">
          <div class="card">
            <div class="card-header">
              Personal Information
            </div>
            <div class="card-body">
              <table class="table table-borderless">
                <tbody>
                  <tr>
                    <th>Firstname</th>
                    <td><?php echo $SchoolRegisterRequestDetails->Firstname ?></td>
                  </tr>
                  <tr>
                    <th>Lastname</th>
                    <td><?php echo $SchoolRegisterRequestDetails->Lastname ?></td>
                  </tr>
                  <tr>
                    <th>Email</th>
                    <td><?php echo $SchoolRegisterRequestDetails->EmailAddress ?></td>
                  </tr>
                  <tr>
                    <th>Phone</th>
                    <td><?php echo $SchoolRegisterRequestDetails->PhoneNumber ?></td>
                  </tr>
                  <tr>
                    <th>Username</th>
                    <td><?php echo $SchoolRegisterRequestDetails->Username ?></td>
                  </tr>
                  <tr>
                    <th>Gender</th>
                    <td><?php echo $SchoolRegisterRequestDetails->Gender ?></td>
                  </tr>
                </tbody>
              </table>
            </div>
          </div>

          <div class="card">
            <div class="card-header">
              School Information
            </div>
            <div class="card-body">
              <table class="table table-borderless">
                <tbody>
                  <tr>
                    <th>School Name</th>
                    <td><?php echo $SchoolRegisterRequestDetails->SchoolName ?></td>
                  </tr>
                  <tr>
                    <th>School Name Initials</th>
                    <td><?php echo $SchoolRegisterRequestDetails->SchoolNameInitials ?></td>
                  </tr>
                  <tr>
                    <th>School Email</th>
                    <td><?php echo $SchoolRegisterRequestDetails->SchoolEmailAddress ?></td>
                  </tr>
                  <tr>
                    <th>School Telephone</th>
                    <td><?php echo $SchoolRegisterRequestDetails->SchoolTelephone1 ?></td>
                  </tr>
                  <tr>
                    <th>School Phone Number</th>
                    <td><?php echo $SchoolRegisterRequestDetails->SchoolPhoneNumber1 ?></td>
                  </tr>
                  <tr>
                    <th>School Type</th>
                    <td><?php echo $SchoolRegisterRequestDetails->SchoolType ?></td>
                  </tr>
                </tbody>
              </table>
            </div>
          </div>
        </div>

        <div class="text-center mt-2">
          <?php
            if($SchoolRegisterRequestDetails->Status=="DECLINED"){
          ?>
            <div class="alert alert-warning text-left">
              <h6 class="font-weight-bold">THIS REQUEST WAS DECLINED</h6>
              <p><span class="font-weight-bold">Decline reason :</span> <?php echo $SchoolRegisterRequestDetails->DeclineReason ?></p>
            </div>
          <?php 
            }
          ?>
          <?php
            if($SchoolRegisterRequestDetails->Status=="ACCEPTED"){
          ?>
            <div class="text-center alert alert-primary">
              <i class="fas fa-check-circle text-primary "></i>
              THIS REQUEST WAS ACCEPTED
            </div>

            <!--<div class="my-2">
              <a id="decline_collapse_btn" href="#!" class="btn btn-warning text-light btn-block enter-btn" data-toggle="collapse" data-target="#decline_reason_container">DECLINE</a>
            </div>

            <div class="collapse" id="decline_reason_container">
              <div class="card text-left">
                <div class="card-header">State the reason for declining</div>
                <div class="card-body">
                  <form id="decline_school_register_request_form">
                    <div class="form-group" id="decline_school_register_request_response">
                      
                    </div>
                    <div class="form-group">
                      <label for="decline_reason">Reason for declining</label>
                      <textarea name="decline_reason" id="decline_reason" class="form-control"></textarea>
                    </div>
                    <input type="hidden" name="decline_school_register_request_note" value="<?php echo $SchoolRegisterRequestDetails->SchoolRegisterRequestId ?>">
                    <button type="submit" class="btn btn-danger btn-block enter-btn" onclick="decline_school_register_request(<?php echo $SchoolRegisterRequestDetails->SchoolRegisterRequestId; ?>)">DECLINE NOW</button>
                  </form>
                </div>
              </div>
            </div>-->
          <?php
            }else if($SchoolRegisterRequestDetails->Status=="REQUEST" or $SchoolRegisterRequestDetails->Status=="DECLINED"){
          ?>
            <form id="accept_school_register_request_form">
              <div class="form-group" id="accept_school_register_request_response">
                
              </div>
              <input type="hidden" name="accept_school_register_request_note" value="<?php echo $SchoolRegisterRequestDetails->SchoolRegisterRequestId ?>">
              <button type="submit" class="btn btn-primary btn-block enter-btn" onclick="accept_school_register_request(<?php echo $SchoolRegisterRequestDetails->SchoolRegisterRequestId; ?>)">ACCEPT</button>
            </form>

            <?php 
              if($SchoolRegisterRequestDetails->Status=="REQUEST"){
            ?>
                <div class="my-2">
                  <a id="decline_collapse_btn" href="#!" class="btn btn-warning text-light btn-block enter-btn" data-toggle="collapse" data-target="#decline_reason_container">DECLINE</a>
                </div>

                <div class="collapse" id="decline_reason_container">
                  <div class="card text-left">
                    <div class="card-header">State the reason for declining</div>
                    <div class="card-body">
                      <form id="decline_school_register_request_form">
                        <div class="form-group" id="decline_school_register_request_response">
                          
                        </div>
                        <div class="form-group">
                          <label for="decline_reason">Reason for declining</label>
                          <textarea name="decline_reason" id="decline_reason" class="form-control"></textarea>
                        </div>
                        <input type="hidden" name="decline_school_register_request_note" value="<?php echo $SchoolRegisterRequestDetails->SchoolRegisterRequestId ?>">
                        <button type="submit" class="btn btn-danger btn-block enter-btn" onclick="decline_school_register_request(<?php echo $SchoolRegisterRequestDetails->SchoolRegisterRequestId; ?>)">DECLINE NOW</button>
                      </form>
                    </div>
                  </div>
                </div>
            <?php
              }
            ?>
          <?php
            }
          ?>
        </div>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">
  $(document).ready(function () {
    var table = $('#register_request_table').DataTable({
      columnDefs: [
        {bSortable: false, targets: [4]} 
      ],
      order: [[3, 'desc']],
      language: {
        paginate: {
          next: '&#8594;', // or '→'
          previous: '&#8592;' // or '←' 
        }
      }
    });

    $("#decline_collapse_btn").click(function() {
        $("html, body").animate({
            scrollTop: $(
              'html, body').get(0).scrollHeight
        }, 2000);
    });
  })
</script>
