<?php
  require_once("../../../session_check.php");
  require_once("../../../../classes/main_classes.php");

  //OBJECTS
  $retrieveObj=new RETRIEVE();

  if(!isset($_POST["SchoolID"])){
    die("<p class='alert alert-warning'>Invalid request</p>");
  }

  $SchoolID=addslashes($_POST["SchoolID"]);

  $get_school=$retrieveObj->retriever("Schools WHERE SchoolID='$SchoolID'","*","fetch");

  $get_staff_overview=$retrieveObj->retriever("Staff WHERE SchoolID='".$SchoolID."' AND Position<>'' GROUP BY Staff.Position ORDER BY StaffID ASC","Position","fetchAll");
?>

<div class="page-header flex-wrap">
  <h3 class="page-title"> 
    Schools
  </h3>
  <p class="mt-1">
    <a href="#schools-view" onclick="schools_view()" class="text_cprimary_color"><u>Schools</u></a> > 
    <a href="#schools-view" onclick="single_school_view(<?php echo $SchoolID ?>)" class="text_cprimary_color"><u><?php echo $get_school->SchoolName ?></u></a> > 
    <span>Staff overview</span>
  </p>
</div>
<div class="row">
  <div class="col-md-12">
    <div class="card">
      <div class="card-header border-0">
        <div class="row align-items-center">
          <div class="col-md-12">
            <h5 class="mb-0">Active Staff Summary</h5>
          </div>
          <div class="col-md-12 my-2 pt-1">
            <div class="row">
              <div class="col-12 col-sm-12 col-md-12 col-lg-12 text-right">
                <button class="btn btn-sm btn-primary" onclick="school_staff_list_view(<?php echo $SchoolID ?>)"> School staff</button>
                <a href="#add-user-view" onclick="add_school_staff_view(<?php echo $SchoolID ?>)" class="btn btn-sm btn-primary my-1"><span class="fas fa-plus"></span> Add school staff</a>
              </div>
            </div>
              
          </div>
          <div class="col-md-12" id="user_response"></div>
        </div>
      </div>
      <div class="table-responsive p-2">
        <table class="table" id="active_staff_summary_table">
            <thead class="bg-light">
                <tr>
                    <th>Position</th>
                    <th>Male Staff</th>
                    <th>Female Staff</th>
                    <th>Total</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                    $male_staff_total_count=0;
                    $female_staff_total_count=0;
                    $grand_total_male_female_staff=0;
                    if($get_staff_overview!="1020"){
                        foreach ($get_staff_overview as $staff_overview) {
                            $male_staff_count=$retrieveObj->retriever("Staff JOIN Users ON Users.UserId=Staff.UserId WHERE Users.Gender='M' and Staff.Position='".$staff_overview->Position."' and SchoolID='".$SchoolID."'","COUNT(*) as male_staff_count","fetch");
                            $male_staff_count=$male_staff_count->male_staff_count;

                            $female_staff_count=$retrieveObj->retriever("Staff JOIN Users ON Users.UserId=Staff.UserId WHERE Users.Gender='F' and Staff.Position='".$staff_overview->Position."' and SchoolID='".$SchoolID."'","COUNT(*) as female_staff_count","fetch");
                            $female_staff_count=$female_staff_count->female_staff_count;

                            $male_staff_total_count+=$male_staff_count;
                            $female_staff_total_count+=$female_staff_count;
                            $total_male_female_staff=$male_staff_count+$female_staff_count;
                            $grand_total_male_female_staff+=$total_male_female_staff;

                ?>
                            <tr>
                                <td><?php echo $staff_overview->Position ?></td>
                                <td><?php echo $male_staff_count ?></td>
                                <td><?php echo $female_staff_count ?></td>
                                <td><?php echo $total_male_female_staff ?></td>
                            </tr>
                <?php
                        }
                    }
                ?>  
            </tbody>
            <tfoot>
                <tr>
                    <th>Grant total</th>
                    <th><?php echo $male_staff_total_count ?></th>
                    <th><?php echo $female_staff_total_count ?></th>
                    <th><?php echo  $grand_total_male_female_staff ?></th>
                </tr>
            </tfoot>
        </table>
      </div>
    </div>
  </div>
</div>

<script>  
 $(document).ready(function(){  
    if(document.getElementById("active_staff_summary_table")!==null){
      $('#active_staff_summary_table').DataTable({
        
      });
    }
 });  
 </script>