<?php
  require_once("../../../session_check.php");
  require_once("../../../../classes/main_classes.php");

  //OBJECTS
  $retrieveObj=new RETRIEVE();

  if(!isset($_POST["SchoolID"])){
    die("<p class='alert alert-warning'>Invalid request</p>");
  }

  $SchoolID=addslashes($_POST["SchoolID"]);

  $get_school=$retrieveObj->retriever("Schools WHERE SchoolID='$SchoolID'","*","fetch");

  $get_students=$retrieveObj->retriever("Students JOIN Users ON Users.UserId=Students.UserId WHERE SchoolID='".$SchoolID."'","*","fetchAll");
?>

<div class="page-header flex-wrap">
  <h3 class="page-title"> 
    Schools
  </h3>
  <p class="mt-1">
    <a href="#schools-view" onclick="schools_view()" class="text_cprimary_color"><u>Schools</u></a> > 
    <a href="#schools-view" onclick="single_school_view(<?php echo $SchoolID ?>)" class="text_cprimary_color"><u><?php echo $get_school->SchoolName ?></u></a> > 
    <span>School student list</span>
  </p>
</div>
<div class="row">
  <div class="col-md-12">
    <div class="card">
      <div class="card-header border-0">
        Students in form 1
      </div>
      <div class="card">
        <div class="mb-4 row p-2">
            <div class="col-12 col-sm-5 col-md-4 col-lg-3">
                <select class="form-control form-control-sm my-1 border border-secondary rounded" style="border:1px !important">
                    <option value="all" selected>Current form (all)</option>
                    <option value="1">Form 1</option>
                    <option value="2">Form 2</option>
                    <option value="3">Form 3</option>
                    <option value="4">Form 4</option>
                    <option value="4">Form 5</option>
                    <option value="4">Form 6</option>
                </select>
            </div>
            <div class="col-12 col-sm-4 col-md-3 col-lg-2">
                <select class="form-control form-control-sm my-1 border border-secondary rounded" style="border:1px !important">
                    <option value="all" selected >Subject (all)</option>
                    <option value="1">Biology</option>
                    <option value="2">Mathematics</option>
                </select>
            </div>
            <div class="col-12 col-sm-3 col-md-3 col-lg-2">
                <select class="form-control form-control-sm my-1 border border-secondary rounded" style="border:1px !important">
                    <option value="all" selected >Term (all)</option>
                    <option value="1">Term 1</option>
                    <option value="2">Term 2</option>
                    <option value="3">Term 3</option>
                </select>
            </div>
        </div>
        <div class="table-responsive p-2">
          <table class="table" id="student_classes_table">
              <thead class="bg-light">
                  <tr>
                      <th>Name</th>
                      <th>Student Id Number</th>
                      <th>Gender</th>
                      <th>Current Form</th>
                      <th>Enrollment Year</th>
                      <th>Status</th>
                      <th></th>
                  </tr>
              </thead>
              <tbody>
                  <?php 
                      if($get_students!="1020"){
                          foreach ($get_students as $student) {
                  ?>
                              <tr>
                                  <td><?php echo $student->Firstname." ".$student->Lastname; ?></td>
                                  <td><?php if(!empty($student->StudentIdNumber) and $student->StudentIdNumber!=0){echo $student->StudentIdNumber;}else{echo "Not available";}; ?></td>
                                  <td><?php echo $student->Gender; ?></td>
                                  <td><?php echo $student->CurrentForm; ?></td>
                                  <td><?php echo $student->EnrollmentYear; ?></td>
                                  <td><?php echo $student->StudentStatus; ?></td>
                                  <td>
                                      <div class="dropdown">
                                        <button class="btn btn-primary btn-sm dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                          <span class="fas fa-cog"> Options</span>
                                        </button>
                                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                          <a class="dropdown-item text_theme_primary" href="#!" onclick="edit_school_student_view(<?php echo $SchoolID ?>,<?php echo $student->UserId; ?>)">
                                              <small><span class="fas fa-edit"></span> Edit</small>
                                          </a>
                                          <a class="dropdown-item text_theme_primary" href="#!" onclick="school_student_record_view(<?php echo $SchoolID ?>,<?php echo $student->UserId ?>)">
                                              <small><span class="fas fa-file-alt"></span> Student records</small>
                                          </a>
                                        </div>
                                      </div>
                                  </td>
                              </tr>
                  <?php
                          }
                      }
                  ?>
              </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<script>  
 $(document).ready(function(){  
    if(document.getElementById("student_classes_table")!==null){
      $('#student_classes_table').DataTable({
        columnDefs: [
          {bSortable: false, targets: [5]} 
        ]
      });
    }
        
 });  
 </script>