<?php
  require_once("../../session_check.php");
  require_once("../../../classes/main_classes.php");

  if(!isset($_POST["sp_id"])){
    die("<p class='alert alert-warning'>Invalid request</p>");
  }

  $sp_id=addslashes($_POST["sp_id"]);

  //OBJECTS
  $retrieveObj=new RETRIEVE();

  $get_subscription_plan=$retrieveObj->retriever("subscription_plan","*","sp_id",$sp_id,"fetch");
?>

<div class="page-header flex-wrap">
  <h3 class="page-title "> 
    Subscriptions
  </h3>
  <p class="mt-1">
    <a href="#subscriptions-view" onclick="subscription_view()" class="text_cprimary_color"><u>Subscriptions</u></a> > 
    <a href="#subscription-plans-view" onclick="subscription_plans_view()" class="text_cprimary_color"><u>Subscription plans</u></a> > 
      <span>Edit subscription plans</span>
  </p>
</div>
<div class="row">
  <div class="col-xl-12 col-lg-12 stretch-card grid-margin">
    <div class="card bg_primary_dark_ascent p-3">
        <div class="card-header bg-white px-0 border_0">
          <div class="font-weight-bold">Edit subscription plans</div>
        </div>
        <div class="table-responsive p-2">
            <form id="edit_subscription_plan_form" class="row">
              <div class="col-md-6 my-2">
                <label class="text-dark font-weight-normal" for="sp_name">Plan Name</label>
                <input class="form-control" type="text" name="sp_name" id="sp_name" placeholder="Enter plan name" value="<?php echo $get_subscription_plan->sp_name ?>">
              </div>
              <div class="col-md-6 my-2">
                <label class="text-dark font-weight-normal" for="sp_price_per_month">Price/month(USD)</label>
                <input class="form-control" type="number" min="0" name="sp_price_per_month" id="sp_price_per_month" placeholder="Enter price per month" value="<?php echo $get_subscription_plan->sp_price_per_month ?>">
              </div>
              <div class="col-md-12 my-2">
                <label class="text-dark font-weight-normal" for="sp_display_order">
                  Display Order &nbsp;
                  <a href="#!" class="fas fa-question-circle shadow rounded-circle" data-toggle="popover" title="Display order" data-content="Determines how the plan will be displayed to customers on the pricing table"></a></label>
                <input class="form-control" type="number" min="0" name="sp_display_order" id="sp_display_order" placeholder="Enter display order number" value="<?php echo $get_subscription_plan->sp_display_order ?>">
              </div>
              <div class="col-md-12 my-2">
                <label class="text-dark font-weight-normal" for="sp_description">Description</label>
                <textarea rows="4" class="form-control" name="sp_description" id="sp_description" placeholder="Subscription description"><?php echo $get_subscription_plan->sp_description ?></textarea>
              </div>
              <div class="col-md-12 my-2" id="edit_subscription_plan_response">
                
              </div>
              <div class="col-md-12 my-2 text-center">
                <input type="hidden" name="edit_subscription_plan_note" value="<?php echo $sp_id ?>">
                <button type="submit" class="btn btn-primary btn-block enter-btn" onclick="edit_subscription_plan()"><span class="fas fa-plus"></span> Update</button>
              </div>
            </form>
        </div>
      </div>
    </div>
  </div>
</div>


<script type="text/javascript">
  var editor = new Simditor({
    textarea: $('#sp_description'),
    upload: false
    
  });
</script>



<script type="text/javascript">
  $(function () {
    $('[data-toggle="popover"]').popover()
  })
  $('body').on('click', function (e) {
      //did not click a popover toggle or popover
      if ($(e.target).data('toggle') !== 'popover'
          && $(e.target).parents('.popover.in').length === 0) { 
          $('[data-toggle="popover"]').popover('hide');
      }
  });
</script>

<script type="text/javascript">
  $(document).ready(function () {
    //$("#selected_role").select2();
    var table = $('#users_table').DataTable({
      columnDefs: [
        {bSortable: false, targets: [4]} 
      ],
      language: {
        paginate: {
          next: '&#8594;', // or '→'
          previous: '&#8592;' // or '←' 
        }
      },
      "order": [[ 3, "asc" ]]
    });
  })
</script>