<?php
  require_once("../../session_check.php");
  require_once("../../../classes/main_classes.php");

  //OBJECTS
  $retrieveObj=new RETRIEVE();
  $updateObj=new UPDATE();
  
  if(!isset($_POST["subscription_id"])){
    die("<p class='alert alert-warning'>Invalid request</p>");
  }

  $subscription_id=addslashes($_POST["subscription_id"]);

  $get_subscription="";
  $selected_status="";
  if(isset($_POST["selected_status"]) and !empty($_POST["selected_status"]) and $_POST["selected_status"]!="all"){
    $selected_status=addslashes($_POST["selected_status"]);
    $get_subscription = $retrieveObj->retriever("subscription
      JOIN subscription_plan ON subscription_plan.sp_id = subscription.sp_id 
      JOIN transaction ON transaction.transaction_id=subscription.transaction_id
      JOIN customer ON customer.customer_id = subscription.customer_id
      JOIN users ON users.user_id = customer.user_id
      WHERE subscription.subscription_status='$selected_status' and subscription.subscription_id=$subscription_id","*","fetch");
  }else{
    $get_subscription=$retrieveObj->retriever("subscription
      JOIN subscription_plan ON subscription_plan.sp_id = subscription.sp_id
      JOIN transaction ON transaction.transaction_id=subscription.transaction_id
      JOIN customer ON customer.customer_id = subscription.customer_id
      JOIN users ON users.user_id = customer.user_id 
      WHERE subscription.subscription_id=$subscription_id","*","fetch");
  }
?>


<div class="page-inner">
  <div class="mt-2 mb-4">
    <h2 class="text-white pb-2"><span class="fas fa-rocket"></span> Subscriptions</h2>
    <h5 class="text-white op-7 mb-4">
      <a href="#subscription-view" onclick="subscription_view()" class="text-light"><u>Subscriptions</u></a> > 
      <span>Subscription Details > <i>Subscription ID : <?php echo $get_subscription->subscription_id ?></i></span>
    </h5>
  </div>
  <div class="row">
    <div class="col-md-12">
      <div class="card-deck">
        <div class="card">
          <div class="card-header font-weight-bold text-light">
            Subscription Information
          </div>
          <div class="card-body">
            <table class="table">
              <tr>
                <th>Subscription Name</th>
                <td><?php echo $get_subscription->sp_name; ?></td>
              </tr>
              <tr>
                <th>Subscription Status</th>
                <td>
                  <?php
                    if($get_subscription->subscription_status=="active"){
                      echo "<span class='badge badge-primary'>Active</span>";
                    }else{
                      echo "<span class='badge badge-primary'>Expired</span>";
                    }
                  ?>
                </td>
              </tr>
              <tr>
                <th>Subscription Type</th>
                <td><?php echo $get_subscription->subscription_type; ?></td>
              </tr>
              <tr>
                <th>Subscription From</th>
                <td><?php echo date("d-m-Y", strtotime($get_subscription->subscription_from))."<br> @".date("H:i A", strtotime($get_subscription->subscription_from)); ?></td>
              </tr>
              <tr>
                <th>Subscription To</th>
                <td><?php echo date("d-m-Y", strtotime($get_subscription->subscription_to))."<br> @".date("H:i A", strtotime($get_subscription->subscription_to)); ?></td>
              </tr>
              <tr>
                <th>Subscribed on</th>
                <td><?php echo date("d-m-Y", strtotime($get_subscription->subscription_date))."<br> @".date("H:i A", strtotime($get_subscription->subscription_date)); ?></td>
              </tr>
            </table>
          </div>
        </div>

        <div class="card">
          <div class="card-header font-weight-bold text-light">
            Transaction Information
          </div>
          <div class="card-body">
            <table class="table">
              <tr>
                <th>Transaction Mode</th>
                <td><?php echo $get_subscription->transaction_mode; ?></td>
              </tr>
              <tr>
                <th>Transaction Mode ID</th>
                <td><?php echo $get_subscription->transaction_mode_id; ?></td>
              </tr>
              <tr>
                <th>Amount</th>
                <td><?php echo $get_subscription->transaction_amount; ?></td>
              </tr>
              <tr>
                <th>Currency</th>
                <td><?php echo $get_subscription->transaction_currency; ?></td>
              </tr>
              <tr>
                <th>Amount in USD</th>
                <td><?php echo "$".$get_subscription->transaction_amount_usd; ?></td>
              </tr>
              <tr>
                <th>Transaction Date</th>
                <td><?php echo date("d-m-Y", strtotime($get_subscription->transaction_date_created))."<br> @".date("H:i A", strtotime($get_subscription->transaction_date_created)); ?></td>
              </tr>
            </table>
          </div>
        </div>
      </div>

      <div class="pt-4">
        <div class="card">
          <div class="card-header font-weight-bold text-light">
            Payer Information
          </div>
          <div class="card-body">
            <table class="table">
              <tr>
                <th>Payer ID</th>
                <td><?php echo $get_subscription->payer_id; ?></td>
              </tr>
              <tr>
                <th>Firstname</th>
                <td><?php echo $get_subscription->payer_firstname; ?></td>
              </tr>
              <tr>
                <th>Lastname</th>
                <td><?php echo $get_subscription->payer_lastname; ?></td>
              </tr>
              <tr>
                <th>Email</th>
                <td><?php echo $get_subscription->payer_email; ?></td>
              </tr>
              
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<?php
    //check if there is a notofication
    $get_notification=$retrieveObj->retriever("staff_notifications JOIN staff_notification_targets ON staff_notifications.sn_id=staff_notification_targets.sn_id","*","sn_source='subscription' and staff_notification_targets.snt_seen_status='0' and staff_notifications.sn_source_id='$subscription_id' and staff_notification_targets.user_id",$user_id,"fetch");
    if($get_notification!="1020"){
        echo $updateObj->updater("staff_notification_targets","snt_seen_status='1'","snt_id",$get_notification->snt_id);
    }
?>




<script type="text/javascript">
  refresh_notifications_count()
  $(document).ready(function () {
    //$("#selected_role").select2();
    var table = $('#users_table').DataTable({
      columnDefs: [
        {bSortable: false, targets: [5]} 
      ],
      language: {
        paginate: {
          next: '&#8594;', // or '→'
          previous: '&#8592;' // or '←' 
        }
      }
    });
  })
</script>