<?php
  require_once("../../session_check.php");
  require_once("../../../classes/main_classes.php");

  //OBJECTS
  $retrieveObj=new RETRIEVE();

  $get_subscription_plans=$retrieveObj->retriever("subscription_plan ORDER BY sp_display_order ASC","*","fetchAll");
?>

<div class="page-header flex-wrap">
  <h3 class="page-title "> 
    Subscriptions
  </h3>
  <p class="mt-1">
    <a href="#subscriptions-view" onclick="subscription_view()" class="text_cprimary_color"><u>Subscriptions</u></a> > 
      <span>Subscription plans</span>
  </p>
</div>
<div class="row">
  <div class="col-xl-12 col-lg-12 stretch-card grid-margin">
    <div class="card bg_primary_dark_ascent p-3">
        <div class="card-header bg-white px-0 border_0">
          <div class="font-weight-bold">Subscription plans</div>
          <div class="row">
            <div class="col-md-12 d-flex justify-content-end my-2">
              <div>
                <?php
                  if($user_in_type=="su_admin"){
                ?>
                  <a href="#add-user-view" onclick="add_subscription_plan_view()" class="btn btn-sm btn-primary my-1"><span class="fas fa-plus"></span> Add subscription plans</a>
                <?php
                  }
                ?>
              </div>
                
            </div>
            <div class="col-md-12" id="subscription_plan_response"></div>
          </div>
        </div>
        <div class="table-responsive p-2">
            <table class="table align-items-center table-flush" id="subscription_table">
              <thead class="thead-light">
                <tr>        
                  <th scope="col">Plan Name</th>
                  <th scope="col">Price/Month</th>
                  <th scope="col">Display Order</th>
                  <th scope="col">Options</th>
                </tr>
              </thead>
              <tbody>
                <?php 
                  if($get_subscription_plans!="1020"){
                    $element_id="element_id";
                      foreach ($get_subscription_plans as $subscription_plan) {
                        $element_id=$element_id."Ot";

                        //$get_user_roles=$retrieveObj->retriever("user_roles JOIN user_role ON user_roles.role_id=user_role.role_id","*","user_id",$user->user_id,"fetchAll");
                ?>  
                    <tr id="<?php echo $element_id ?>">         
                      <td>
                        <?php 
                          echo $subscription_plan->sp_name;
                        ?>
                      </td>
                      <td>
                        <?php 
                          echo "MWK ".number_format($subscription_plan->sp_price_per_month);
                        ?>
                      </td>
                      <td>
                        <?php 
                          echo $subscription_plan->sp_display_order;
                        ?>
                      </td>
                      
                      <td id="<?php echo $element_id.'Dbtn' ?>">
                      <?php
                        if($user_in_type=="su_admin"){
                      ?>
                          <a href="#edit-subscription-plan-view" title="Edit" class="btn btn-sm btn-primary hand_cursor my-1 px-2" onclick="edit_subscription_plan_view(<?php echo $subscription_plan->sp_id ?>)">
                              <span class="fas fa-edit"></span> Edit
                            </a>
                           
                            <form id="<?php echo 'R'.$element_id.'form' ?>" class="mb-0 hand_cursor" style="display: inline;">
                                <input type="hidden" name="delete_subscription_plan_note" value="<?php echo $subscription_plan->sp_id; ?>">
                                <button id="<?php echo $element_id.'Rbtn' ?>" onclick="delete_subscription_plan('<?php echo 'R'.$element_id.'form' ?>','<?php echo $element_id; ?>','subscription_plan_response')" type="submit" title="Delete" class="btn btn-sm btn-danger text-light hand_cursor my-1 px-2"><span class="fas fa-times"></span> Delete</button>
                            </form>
                      <?php
                        }
                      ?>
                          
                      </td>
                    </tr>
                  <?php
                      }
                    }
                  ?>
              </tbody>
            </table>
        </div>
      </div>
    </div>
  </div>
</div>




<script type="text/javascript">
  $(document).ready(function () {
    //$("#selected_role").select2();
    var table = $('#subscription_table').DataTable({
      columnDefs: [
        {bSortable: false, targets: [3]} 
      ],
      language: {
        paginate: {
          next: '&#8594;', // or '→'
          previous: '&#8592;' // or '←' 
        }
      },
      "order": [[ 3, "asc" ]]
    });
  })
</script>