<?php
  require_once("../session_check.php");
  require_once("../../classes/main_classes.php");

  //OBJECTS
  $retrieveObj=new RETRIEVE();

  $get_users="";
  if(isset($_POST["UserType"]) and !empty($_POST["UserType"]) and $_POST["UserType"]!="all"){
    $UserType=addslashes($_POST["UserType"]);
    $get_users = $retrieveObj->retriever("Users 
      JOIN UserTypes ON Users.UserId = UserTypes.UserId 
      JOIN UserType ON UserType.UserTypeId = UserTypes.UserTypeId 
      WHERE Users.UserStatus='Active' and UserType.UserType='$UserType'
      GROUP BY Users.UserId ORDER BY Users.UserId DESC","DISTINCT *","fetchAll");
  }else{
    $get_users=$retrieveObj->retriever("Users 
      JOIN UserTypes ON Users.UserId = UserTypes.UserId 
      JOIN UserType ON UserType.UserTypeId = UserTypes.UserTypeId 
      WHERE Users.UserStatus='Active' and (UserType.UserType='su_admin' || UserType.UserType='admin')
      GROUP BY Users.UserId ORDER BY Users.UserId DESC","DISTINCT *","fetchAll");
  }

  //GET USER ROLES
  $get_user_types=$retrieveObj->retriever("UserType","*","fetchAll");
?>


<div class="page-header flex-wrap">
  <h3 class="page-title"> 
    SchoolWeb Staff
    <!--<br><span class="font-weight-normal"></span>-->
  </h3>
  <p class="mt-1">
    <a href="#users-view" onclick="users_view()" class="text_cprimary_color"><u>SchoolWeb Staff</u></a> > 
      <span>Active staff</span>
  </p>
</div>
<div class="row">
  <div class="col-xl-12 col-lg-12 stretch-card grid-margin">
    <div class="card">
      <div class="card-header border-0">
        <div class="row align-items-center">
          <div class="col-md-12">
            <h5 class="mb-0">Active staff</h5>
          </div>
          <div class="col-md-12 my-2 pt-1">
            <div class="row">
              <div class="col-12 col-sm-4 col-md-3 col-lg-2">
                <select class="form-control form-control-sm" name="UserType" id="UserType" onchange="users_view()">
                  <option selected value="all">All users</option>
                  <?php
                    if($get_user_types!="1020"){
                      foreach ($get_user_types as $UserType) {
                        if($UserType->UserType=="student" || $UserType->UserType=="school_staff"){
                          continue;
                        }
                        echo "<option value='".$UserType->UserTypeId."' >".$UserType->UserType."</option>";
                      }
                    }
                  ?>
                </select>
              </div>
              <div class="col-12 col-sm-8 col-md-9 col-lg-10 text-left text-sm-left text-md-right text-lg-right">
                <?php
                  if($user_in_type=="su_admin"){
                ?>
                  <a href="#add-user-view" onclick="add_user_view()" class="btn btn-sm btn-primary my-1"><span class="fas fa-plus"></span> Add staff</a>
                  <a href="#!" class="btn btn-sm btn-danger my-1" onclick="users_trash_view()"><span class="fas fa-ban"></span> Inactive Staff</a>
                <?php
                  }
                ?>
              </div>
            </div>
              
          </div>
          <div class="col-md-12" id="user_response"></div>
        </div>
      </div>
      <div class="table-responsive p-2">
        <!-- Projects table -->
        <table class="table align-items-center table-flush" id="users_table">
          <thead class="thead-light">
            <tr>        
              <th scope="col">Firstname</th>
              <th scope="col">Lastname</th>
              <th scope="col">Phone</th>
              <th scope="col">Email</th>
              <th scope="col">User Type</th>
              <th scope="col"></th>
            </tr>
          </thead>
          <tbody>
            <?php 
              if($get_users!="1020"){
                $element_id="element_id";
                  foreach ($get_users as $user) {
                    $element_id=$element_id."Ot";
            ?>  
                <tr id="<?php echo $element_id ?>">         
                  
                  <td>
                    <?php 
                      echo $user->Firstname;
                    ?>
                  </td>
                  <td>
                    <?php 
                      echo $user->Lastname;
                    ?>
                  </td>
                  <td>
                    <?php 
                      echo $user->PhoneNumber;
                    ?>
                  </td>
                  <td>
                    <?php 
                      echo $user->EmailAddress;
                    ?>
                  </td>
                  <td>
                    <?php 
                      echo $user->UserType;
                    ?>
                  </td>
                  <td id="<?php echo $element_id.'Dbtn' ?>">
                  <?php
                    if($user_in_type=="su_admin" and !($user_id==$user->UserId)){
                  ?>
                      <div class="">
                        <button title="Edit" class="btn btn-sm btn-primary hand_cursor my-1 px-2" onclick="edit_user_view(<?php echo $user->UserId ?>)"><span class="fas fa-edit"></span></button>
                        <form id="<?php echo 'R'.$element_id.'form' ?>" class="mb-0 hand_cursor" style="display: inline;">
                            <input type="hidden" name="deactivate_user_note" value="<?php echo $user->UserId; ?>">
                            <button id="<?php echo $element_id.'Rbtn' ?>" onclick="deactivate_user('<?php echo 'R'.$element_id.'form' ?>','<?php echo $element_id; ?>','user_response')" type="submit" title="Deactivate" class="btn btn-sm btn-warning text-light hand_cursor my-1 px-2"><span class="fas fa-ban"></span> </button>
                        </form>
                        
                      </div>
                  <?php
                    }
                  ?>
                      
                  </td>
                </tr>
              <?php
                  }
                }
              ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">
  $(document).ready(function () {
    var table = $('#users_table').DataTable({
      columnDefs: [
        {bSortable: false, targets: [5]} 
      ],
      language: {
        paginate: {
          next: '&#8594;', // or '→'
          previous: '&#8592;' // or '←' 
        }
      }
    });
  })
</script>