<?php
  require_once("../../session_check.php");
  require_once("../../../classes/main_classes.php");

  //OBJECTS
  $retrieveObj=new RETRIEVE();

  //get roles
  $get_user_types=$retrieveObj->retriever("UserType","*","fetchAll");
?>

<div class="page-header flex-wrap">
  <h3 class="page-title"> 
    SchoolWeb Staff
    <!--<br><span class="font-weight-normal"></span>-->
  </h3>
  <p class="mt-1">
    <a href="#users-view" onclick="users_view()" class="text_cprimary_color"><u>SchoolWeb Staff</u></a> > 
      <span>Add staff</span>
  </p>
</div>
<div class="row">
  <div class="col-xl-12 col-lg-12">
    <div class="card">
      <div class="card-header border-0">
        <div class="row align-items-center">
          <div class="col">
            <h5 class="mb-0">Add staff</h5>
          </div>
        </div>
      </div>
      <div class="px-2">
        <form id="add_user_form" class="row">
            <div class="col-md-6 my-2">
              <input class="form-control" type="text" name="firstname" placeholder="Firstname">
            </div>
            <div class="col-md-6 my-2">
              <input class="form-control" type="text" name="lastname" placeholder="Lastname">
            </div>
            <div class="col-md-6 my-2">
              <input class="form-control" type="text" name="username" placeholder="Username">
            </div>
            <div class="col-md-6 my-2">
              <input class="form-control" type="text" name="email" placeholder="Email">
            </div>
            <div class="col-md-6 my-2">
              <input class="form-control" type="text" name="phone" placeholder="Phone">
            </div>
            <div class="col-md-6 my-2">
              <select class="form-control" name="user_type">
                <?php
                  if($get_user_types!="1020"){
                    $usertype_selected_status="";

                    foreach ($get_user_types as $usertype) {
                      if($usertype->UserType=="student" || $usertype->UserType=="school_staff"){
                        continue;
                      }
                      if($usertype->UserType=="admin"){
                        $usertype_selected_status="selected";
                      }else{
                        $usertype_selected_status="";
                      }
                      echo "<option $usertype_selected_status value='".$usertype->UserTypeId."' >".$usertype->UserType."</option>";
                    }
                  }
                ?>
              </select>
            </div>
            <div class="col-md-6 my-2">
              <input class="form-control" type="password" name="password" placeholder="Password">
            </div>
            <div class="col-md-6 my-2">
              <input class="form-control" type="password" name="rpassword" placeholder="Repeat password">
            </div>
            <div class="col-md-12 my-2" id="add_user_response">
              
            </div>
            <div class="col-md-12 my-2">
              <input type="hidden" name="add_user_note">
              <button type="submit" class="btn btn-primary btn-block enter-btn" onclick="add_user()">Add</button>
            </div>
          </form>
      </div>
    </div>
  </div>
</div>

