<!DOCTYPE html>
<html>
	<head>
		<title>Home - School Web</title>
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
		<meta name="format-detection" content="telephone=no">
		<meta name="apple-mobile-web-app-capable" content="yes">
		<!-- Fonts-->
		<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.2/css/all.min.css">
		<link rel="stylesheet" type="text/css" href="assets/fonts/themify-icons/themify-icons.css">
		<!-- Vendors-->
		<link rel="stylesheet" type="text/css" href="assets/vendors/bootstrap/css/bootstrap-grid.min.css">
		<link rel="stylesheet" type="text/css" href="assets/vendors/bootstrap/css/bootstrap.min.css">
		<link rel="stylesheet" type="text/css" href="assets/vendors/magnific-popup/magnific-popup.min.css">
		<link rel="stylesheet" type="text/css" href="assets/vendors/owl.carousel/owl.carousel.css">
		<link rel="stylesheet" type="text/css" href="assets/vendors/_jquery/jquery.min.css">
		<!-- <link rel="stylesheet" type="text/css" href="assets/vendors/bootstrap4/bootstrap-grid.min.css"> -->
		<!-- <link rel="stylesheet" type="text/css" href="assets/vendors/bootstrap4/bootstrap-grid.min.css"> -->
		<!-- App & fonts-->
		<link rel="stylesheet" type="text/css" href="https://fonts.googleapis.com/css?family=Roboto:300,300i,400,400i,700,700i&amp;amp;subset=latin-ext">
		<link rel="stylesheet" type="text/css" href="assets/css/main.css"><!--[if lt IE 9]>
			<script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
		<![endif]-->
	</head>
	
	<body>
		<div class="page-wrap">
			
			<?php
				include("main_nav.php");
			?>
			
			<!-- Content-->
			<div class="md-content">
				
				<!-- slider -->
				<div class="slider">
					
					<!-- carousel__element owl-carousel -->
					<div class="carousel__element owl-carousel" data-options='{"items":1,"loop":true,"dots":false,"nav":false,"margin":0, "autoplay": true, "autoplayTimeout": 3000}'>
						<div class="slider__item" style="background:  linear-gradient(to bottom, rgba(0, 0, 0, 0.5) 0%, rgba(0, 0, 0, 0.2) 75%, #000000 100%), url('assets/img/slider.jpg');background-size: cover; background-position: top;">
							<div class="md-tb">
								<div class="md-tb__cell">
									<div class="slider__content">
										<div class="container">
											<h2>The Power of SchoolWeb</h2>
											<p class="text-light">
												SchoolWeb sofware has several excellent features that you can get in one bundle once you register. These include student records, school timetables, teacher subject allocation, student school reports emailing or texts to parents/guardians etc. 
											</p>
										</div>
									</div>
								</div>
							</div>
						</div>
						<!--div class="slider__item" style="background-image: url('https://picsum.photos/1920/1080');">
							<div class="md-tb">
								<div class="md-tb__cell">
									<div class="slider__content">
										<div class="container">
											<h2>We create the trend</h2>
											<p>Curabitur elementum urna augue, eu porta purus gravida in. Cras consectetur, lorem a cursus vestibulum, ligula purus iaculis nulla, in dignissim risus turpis id justo. Sed eleifend ante et ligula elei</p>
										</div>
									</div>
								</div>
							</div>
						</div-->
					</div><!-- End / carousel__element owl-carousel -->
					
				</div><!-- End / slider -->
				
				<!-- Service-->
				
				<!-- Section -->
				<section class="md-section" style="background-color:#f7f7f7;padding:0;">
					<div class="container">
						<div class="textbox-group">
							<div class="row">
								<div class="col-12 col-sm-6 col-md-3 col-lg-3 ">
									
									<!-- textbox -->
									<div class="textbox mb-0">
										<div class="textbox__image"><a href="#"><img style="max-height: 100px; max-width: 100px;" src="assets/img/icons/student_records_icon.png" alt=""/></a></div>
										<div class="textbox__body">
											<h2 class="textbox__title"><a href="#">Student Records</a></h2>
											<div class="textbox__description text-center text-secondary">
												SchoolWeb helps you manage your students term and year records.
												<span class="collapse" id="more_student_records_details">
													 This helps to keep your student records from point entry until he/she exists from your school. Total marks calculation,marks to letter grades conversion, student position in class etc are all automatic. 
												</span>
												<a href="#!" id="more_student_records_details_btn" class="d-block bg-secondary text-light text-center mt-3"><i class="fa fa-arrow-down" id="more_student_records_details_btn_icon"></i></a>
											</div>
										</div>
									</div><!-- End / textbox -->
									
								</div>
								<div class="col-12 col-sm-6 col-md-3 col-lg-3 ">
									
									<!-- textbox -->
									<div class="textbox mb-0">
										<div class="textbox__image"><a href="#"><img style="max-height: 100px; max-width: 100px;" src="assets/img/icons/staff_records_icon.png" alt=""/></a></div>
										<div class="textbox__body">
											<h2 class="textbox__title"><a href="#">Staff Records</a></h2>
											<div class="textbox__description text-center text-secondary">Manage your staff data with SchoolWeb. </div>
											<span class="d-block mt-3">&nbsp;</span>
											<span class="d-block">&nbsp;</span>

										</div>
									</div><!-- End / textbox -->
									
								</div>
								<div class="col-12 col-sm-6 col-md-3 col-lg-3 ">
									
									<!-- textbox -->
									<div class="textbox mb-0">
										<div class="textbox__image"><a href="#"><img style="max-height: 100px; max-width: 100px;" src="assets/img/icons/state_of_the_art_icon.png" alt=""/></a></div>
										<div class="textbox__body">
											<h2 class="textbox__title"><a href="#">State of the Art</a></h2>
											<div class="textbox__description text-center text-secondary" ><span class="d-none d-md-none d-lg-inline">&nbsp;&nbsp;&nbsp;</span> SchoolWeb is highly optimised for fast performance and easy   
												<span class="collapse" id="more_state_of_the_art_details">
													 usage or all devices. You dont have computers for your school, dont worry because your smart phone is enough and you will get the same experience as on a computer.
												</span>
											</div>
											
											<a href="#!" id="more_state_of_the_art_details_btn" class="d-block bg-secondary text-light text-center mt-3"><i class="fa fa-arrow-down" id="more_state_of_the_art_details_btn_icon"></i></a>
										</div>
									</div><!-- End / textbox -->
									
								</div>
								<div class="col-12 col-sm-6 col-md-3 col-lg-3 ">
									
									<!-- textbox -->
									<div class="textbox mb-0">
										<div class="textbox__image"><a href="#"><img style="max-height: 100px; max-width: 100px;" src="assets/img/icons/rocket_icon.png" alt=""/></a></div>
										<div class="textbox__body">
											<h2 class="textbox__title"><a href="#">Dependable</a></h2>
											<div class="textbox__description text-center text-secondary">
												SchoolWeb has been fully tested and developed to perfection. 

												<span class="collapse" id="more_dependable_details">
													 We continually provide free software updates once you register and pay the subscription fee. Support is always available 24 hrs. We further value the security of your data. 
												</span>
												<a href="#!" id="more_dependable_details_btn" class="d-block bg-secondary text-light text-center mt-3"><i class="fa fa-arrow-down" id="more_dependable_details_btn_icon"></i></a>
											</div>
										</div>
									</div><!-- End / textbox -->
									
								</div>
							</div>
						</div>
					</div>
				</section>
				<!-- End / Section -->
				
				
				<!-- Contact us-->
				
				<!-- Section -->
				<section class="md-section md-skin-dark js-consult-form" style="background-image:  linear-gradient(to bottom, rgba(0, 0, 0, 0.5) 0%, rgba(0, 0, 0, 0.2) 75%, #000000 100%),url(&quot;assets/img/backgrounds/1.jpg&quot;);">
					<div class="md-overlay"></div>
					<div class="container">
						<div class="row">
							<div class="col-lg-8 offset-0 offset-sm-0 offset-md-0 offset-lg-2 ">
								
								<!-- title-01 -->
								<div class="title-01 title-01__style-02">
									<h2 class="title-01__title">Contact With Us via Hot Line</h2>
									<!--div>Sed ante nisl, fermentum et facilisis in, maximus </div-->
								</div><!-- End / title-01 -->
								
								<!--<div class="consult-phone">(+265)  995 684 047</div>-->
							</div>
						</div>
						
						<!-- form-01 -->
						<div class="form-01 consult-form js-consult-form__content">
							<h2 class="form-01__title">Give Us Your Feedback</h2>
							<form class="form-01__form">
								<div class="form__item form__item--03">
									<input type="text" name="name" placeholder="Your name"/>
								</div>
								<div class="form__item form__item--03">
									<input type="text" name="email" placeholder="Your Email"/>
								</div>
								<div class="form__item">
									<select>
										<option selected disabled>Subject</option>
										<option value="service">General Customer Service</option>
										<option value="suggestions">Suggestions</option>
										<option value="product">Product Support</option>
									</select>
								</div>
								<div class="form__item">
									<textarea rows="3" name="Your message" placeholder="Your message"></textarea>
								</div>
								<div class="form__button"><a class="btn btn-primary btn-w180" href="#">send message</a>
								</div>
							</form>
						</div><!-- End / form-01 -->
						
					</div>
				</section>
				<!-- End / Section -->
				
				<!-- What’s Client Say ?-->
				
				<!-- Section -->
				<section class="md-section" style="padding-bottom:0;">
					<div class="container">
						<div class="row">
							<div class="col-md-8 col-lg-8 offset-0 offset-sm-0 offset-md-2 offset-lg-2 ">
								<!-- title-01 -->
								<div class="title-01" style="margin-bottom:50px;">
									<h2 class="title-01__title">We Always Try to Create a Difference</h2>
									<p class="text-center">Thank you for visiting our site </p>
									<p class="text-center">
										<a href="register.php" class="btn btn-primary text-light shadow-sm">START YOUR FREE TRIAL TODAY</a>
									</p>
								</div><!-- End / title-01 -->
							</div>
						</div>
					</div>
				</section>
				<!-- End / Section -->
				
			</div>
			<!-- End / Content-->
			
			<?php
				include("footer.php");
			?>
			
		</div>
		<!-- Vendors-->
		<script type="text/javascript" src="assets/vendors/jquery/jquery.min.js"></script>
		<script type="text/javascript" src="assets/vendors/imagesloaded/imagesloaded.pkgd.js"></script>
		<script type="text/javascript" src="assets/vendors/isotope-layout/isotope.pkgd.js"></script>
		<script type="text/javascript" src="assets/vendors/jquery.countdown/jquery.countdown.min.js"></script>
		<script type="text/javascript" src="assets/vendors/jquery.countTo/jquery.countTo.min.js"></script>
		<script type="text/javascript" src="assets/vendors/jquery.countUp/jquery.countup.min.js"></script>
		<script type="text/javascript" src="assets/vendors/jquery.matchHeight/jquery.matchHeight.min.js"></script>
		<script type="text/javascript" src="assets/vendors/jquery.mb.ytplayer/jquery.mb.YTPlayer.min.js"></script>
		<script type="text/javascript" src="assets/vendors/magnific-popup/jquery.magnific-popup.min.js"></script>
		<script type="text/javascript" src="assets/vendors/masonry-layout/masonry.pkgd.js"></script>
		<script type="text/javascript" src="assets/vendors/owl.carousel/owl.carousel.js"></script>
		<script type="text/javascript" src="assets/vendors/jquery.waypoints/jquery.waypoints.min.js"></script>
		<script type="text/javascript" src="assets/vendors/menu/menu.min.js"></script>
		<script type="text/javascript" src="assets/vendors/smoothscroll/SmoothScroll.min.js"></script>
		<!-- App-->
		<script type="text/javascript" src="assets/js/main.js"></script>
		<script type="text/javascript">
			$(document).ready(function(){
				$("#more_student_records_details_btn").click(function() {
					if($("#more_student_records_details").is(":visible")){
						$("#more_student_records_details").hide();
						$("#more_student_records_details_btn_icon").removeClass("fa-arrow-up");
						$("#more_student_records_details_btn_icon").addClass("fa-arrow-down");
					}else{
						$("#more_student_records_details").show();
						$("#more_student_records_details_btn_icon").removeClass("fa-arrow-down");
						$("#more_student_records_details_btn_icon").addClass("fa-arrow-up");
					}
				})

				$("#more_state_of_the_art_details_btn").click(function() {
					if($("#more_state_of_the_art_details").is(":visible")){
						$("#more_state_of_the_art_details").hide();
						$("#more_state_of_the_art_details_btn_icon").removeClass("fa-arrow-up");
						$("#more_state_of_the_art_details_btn_icon").addClass("fa-arrow-down");
					}else{
						$("#more_state_of_the_art_details").show();
						$("#more_state_of_the_art_details_btn_icon").removeClass("fa-arrow-down");
						$("#more_state_of_the_art_details_btn_icon").addClass("fa-arrow-up");
					}
				})

				$("#more_dependable_details_btn").click(function() {
					if($("#more_dependable_details").is(":visible")){
						$("#more_dependable_details").hide();
						$("#more_dependable_details_btn_icon").removeClass("fa-arrow-up");
						$("#more_dependable_details_btn_icon").addClass("fa-arrow-down");
					}else{
						$("#more_dependable_details").show();
						$("#more_dependable_details_btn_icon").removeClass("fa-arrow-down");
						$("#more_dependable_details_btn_icon").addClass("fa-arrow-up");
					}
				})
			})
		</script>
	</body>
</html>
