<?php
    require_once("../../session_check.php");
    require_once("../../../classes/main_classes.php");

    if($sign_in_status=="out"){
       die("<p class='alert alert-warning'>Access denied, this maybe because the login session has expired. Please try refleshing the page.<p>");
    }

    //OBJECTS
    $retrieveObj=new RETRIEVE();

    //get announcements
    $get_announcements=$retrieveObj->retriever("Announcements","*","SchoolID",$_SESSION["user_details"]["SchoolID"],"fetchAll");

?>

<!-- ============================================================== -->
<!-- Bread crumb and right sidebar toggle -->
<!-- ============================================================== -->
<div class="row page-titles">
    <div class="col-md-5 col-8 align-self-center">
        <h3 class="text-themecolor">Announcements</h3>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
            <li class="breadcrumb-item active">Announcements</li>
        </ol>
    </div>
    <div class="col-md-7 col-4 align-self-center">
        <!--a href="https://themewagon.com/themes/bootstrap-4-responsive-admin-template/" class="btn waves-effect waves-light btn-danger pull-right hidden-sm-down"></a-->
    </div>
</div>
<!-- ============================================================== -->
<!-- End Bread crumb and right sidebar toggle -->
<!-- ============================================================== -->
<!-- ============================================================== -->
<!-- Start Page Content -->
<!-- ============================================================== -->
<!-- Row -->
<div class="row">
    <!-- Column -->
    <div class="col-sm-12 col-lg-12">
        <div class="card">
            <div class="card-header text-center lead bg-light mb-3 ">
                Announcements
            </div>
            <div class="card-body p-4">
                <table class="table" id="announcements_table">
                    <thead class="bg-light">
                        <tr>
                            <th>Title</th>
                            <th>Date added</th>
                            <th>
                                
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                          
                          if($get_announcements!="1020"){
                            $element_id="element_id";
                              foreach ($get_announcements as $announcement) {
                                $element_id=$element_id."Ot";
                        ?>  
                            <tr id="<?php echo $element_id ?>">         
                              
                              <td>
                                <?php 
                                  echo $announcement->Heading;
                                ?>
                              </td>
                              <td>
                                <span class="d-none"><?php echo strtotime($announcement->Date) ?></span>
                                <?php 
                                  echo $announcement->Date;
                                ?>
                              </td>
                              
                              <td id="<?php echo $element_id.'Dbtn' ?>" >
                                <button class="btn btn-primary btn-sm m-1" onclick="edit_announcement_view(<?php echo $announcement->AnnouncementID ?>)">
                                    <span class="fa fa-edit "></span>
                                </button>
                                
                                <form id="<?php echo 'R'.$element_id.'form' ?>" class="mb-0 hand_cursor m-1" style="display: inline;">
                                    <input type="hidden" name="delete_announcement_note" value="<?php echo $announcement->AnnouncementID; ?>">
                                    <button id="<?php echo $element_id.'Rbtn' ?>" onclick="delete_announcement('<?php echo 'R'.$element_id.'form' ?>','<?php echo $element_id; ?>','delete_announcement_response')" type="submit" title="Delete" class="btn btn-danger btn-sm hand_cursor"><span class="fas fa-trash"></span></button>
                                </form>    
                              </td>
                            </tr>
                          <?php
                              }
                            }
                          ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>     

<script>  
 $(document).ready(function(){  
    if(document.getElementById("announcements_table")!==null){
      $('#announcements_table').DataTable({
        columnDefs: [
          {bSortable: false, targets: [2]} 
        ],
        order: [[1, 'desc']],
      });
    }
        
 });  
 </script>