<?php
    require_once("../../../session_check.php");
    require_once("../../../../classes/main_classes.php");
    require_once("../../../../assets/vendors/phpspreadsheet/vendor/autoload.php");

    $retrieveObj=new RETRIEVE();

    //check get values
    if(
        !isset($_GET['get_template']) or
        !isset($_GET['school']) or
        !isset($_GET['subject']) or
        !isset($_GET['year']) or
        !isset($_GET['form']) or
        !isset($_GET['term']) or
        empty($_GET['school']) or
        empty($_GET['subject']) or
        empty($_GET['year']) or
        empty($_GET['form']) or
        empty($_GET['term'])
    ){
        die("Something went wrong");
    }

    $school=addslashes($_GET['school']);
    $subject=addslashes($_GET['subject']);
    $year=addslashes($_GET['year']);
    $form=addslashes($_GET['form']);
    $term=addslashes($_GET['term']);

    //Get school information
    $get_school=$retrieveObj->retriever("Schools","*","SchoolID",$school,"fetch");

    if($get_school=="1020"){
        die("Something went wrong");
    }

    $school_name=$get_school->SchoolName;

    $template_name='GRADES ENTRY TEMPLATE - '.$year.' Form '.$form.' Term '.$term.' '.$subject;

    // Import the core class of PhpSpreadsheet
    use PhpOffice\PhpSpreadsheet\Spreadsheet;

    // Import the Xlsx writer class
    use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

    // Create a new Spreadsheet object
    $spreadsheet = new Spreadsheet();

    // Retrieve the current active worksheet
    $sheet = $spreadsheet->getActiveSheet();

    // Set cell A1 with the "Hello World !" string value
    $sheet->setCellValue('A1', $school_name);
    $sheet->setCellValue('B1', '');
    $sheet->setCellValue('C1', '');
    $sheet->setCellValue('D1', '');
    $sheet->setCellValue('E1', '');

    $sheet->setCellValue('A2', $template_name);
    $sheet->setCellValue('B2', '');
    $sheet->setCellValue('C2', '');
    $sheet->setCellValue('D2', '');
    $sheet->setCellValue('E2', '');

    $sheet->setCellValue('A3', 'StudentIDNumber');
    $sheet->setCellValue('B3', 'Student Name');
    $sheet->setCellValue('C3', 'Continuous Assessment');
    $sheet->setCellValue('D3', 'Final Exam');
    $sheet->setCellValue('E3', 'Comment');
    

    // Apply a solid type background to 'A1'
    $sheet->getStyle('A1')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);
    $sheet->getStyle('B1')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);
    $sheet->getStyle('C1')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);
    $sheet->getStyle('D1')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);
    $sheet->getStyle('E1')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);

    $sheet->getStyle('A2')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);
    $sheet->getStyle('B2')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);
    $sheet->getStyle('C2')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);
    $sheet->getStyle('D2')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);
    $sheet->getStyle('E2')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);

    $sheet->getStyle('A3')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);
    $sheet->getStyle('B3')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);
    $sheet->getStyle('C3')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);
    $sheet->getStyle('D3')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);
    $sheet->getStyle('E3')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);

    // Fill up the background of 'A1' with color blue
    $sheet->getStyle('A1')->getFill()->getStartColor()->setARGB(\PhpOffice\PhpSpreadsheet\Style\Color::COLOR_GREEN);
    $sheet->getStyle('B1')->getFill()->getStartColor()->setARGB(\PhpOffice\PhpSpreadsheet\Style\Color::COLOR_GREEN);
    $sheet->getStyle('C1')->getFill()->getStartColor()->setARGB(\PhpOffice\PhpSpreadsheet\Style\Color::COLOR_GREEN);
    $sheet->getStyle('D1')->getFill()->getStartColor()->setARGB(\PhpOffice\PhpSpreadsheet\Style\Color::COLOR_GREEN);
    $sheet->getStyle('E1')->getFill()->getStartColor()->setARGB(\PhpOffice\PhpSpreadsheet\Style\Color::COLOR_GREEN);

    $sheet->getStyle('A2')->getFill()->getStartColor()->setARGB(\PhpOffice\PhpSpreadsheet\Style\Color::COLOR_BLUE);
    $sheet->getStyle('B2')->getFill()->getStartColor()->setARGB(\PhpOffice\PhpSpreadsheet\Style\Color::COLOR_BLUE);
    $sheet->getStyle('C2')->getFill()->getStartColor()->setARGB(\PhpOffice\PhpSpreadsheet\Style\Color::COLOR_BLUE);
    $sheet->getStyle('D2')->getFill()->getStartColor()->setARGB(\PhpOffice\PhpSpreadsheet\Style\Color::COLOR_BLUE);
    $sheet->getStyle('E2')->getFill()->getStartColor()->setARGB(\PhpOffice\PhpSpreadsheet\Style\Color::COLOR_BLUE);

    $sheet->getStyle('A3')->getFill()->getStartColor()->setARGB(\PhpOffice\PhpSpreadsheet\Style\Color::COLOR_RED);
    $sheet->getStyle('B3')->getFill()->getStartColor()->setARGB(\PhpOffice\PhpSpreadsheet\Style\Color::COLOR_RED);
    $sheet->getStyle('C3')->getFill()->getStartColor()->setARGB(\PhpOffice\PhpSpreadsheet\Style\Color::COLOR_RED);
    $sheet->getStyle('D3')->getFill()->getStartColor()->setARGB(\PhpOffice\PhpSpreadsheet\Style\Color::COLOR_RED);
    $sheet->getStyle('E3')->getFill()->getStartColor()->setARGB(\PhpOffice\PhpSpreadsheet\Style\Color::COLOR_RED);

    foreach (range('A','E') as $col) {
       $sheet->getColumnDimension($col)->setWidth(25);
    }

    // Write a new .xlsx file
    $writer = new Xlsx($spreadsheet);

    // Save the new .xlsx file
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="'.$template_name.'.xlsx"');
    $writer->save("php://output");


?>