<!DOCTYPE html>
<html lang="en">
<head>

<!-- meta tags -->
<meta charset="utf-8">
<meta name="keywords" content="bootstrap 5, premium, multipurpose, sass, scss, saas, software" />
<meta name="description" content="HTML5 Template" />
<meta name="author" content="www.themeht.com" />
<meta name="viewport" content="width=device-width, initial-scale=1">

<!-- Title -->
<title>Contact - School Web</title>

<!-- favicon icon -->
<link rel="shortcut icon" href="assets/img/logos/swb_logo.png" />

<!-- inject css start -->

<!--== bootstrap -->
<link href="css/bootstrap.min.css" rel="stylesheet" type="text/css" />

<link href="https://fonts.googleapis.com/css?family=Nunito:300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">
 
<!--== animate -->
<link href="css/animate.css" rel="stylesheet" type="text/css" />

<!--== fontawesome -->
<link href="css/fontawesome-all.css" rel="stylesheet" type="text/css" />

<!--== line-awesome -->
<link href="css/line-awesome.min.css" rel="stylesheet" type="text/css" />

<!--== magnific-popup -->
<link href="css/magnific-popup/magnific-popup.css" rel="stylesheet" type="text/css" />

<!--== owl-carousel -->
<link href="css/owl-carousel/owl.carousel.css" rel="stylesheet" type="text/css" />

<!--== base -->
<link href="css/base.css" rel="stylesheet" type="text/css" />

<!--== shortcodes -->
<link href="css/shortcodes.css" rel="stylesheet" type="text/css" />

<!--== default-theme -->
<link href="css/style.css" rel="stylesheet" type="text/css" />

<!--== responsive -->
<link href="css/responsive.css" rel="stylesheet" type="text/css" />

<!-- inject css end -->

</head>

<body>

<!-- page wrapper start -->

<div class="page-wrapper">

<!-- preloader start -->

<div id="ht-preloader">
  <div class="loader clear-loader">
    <div class="loader-box"></div>
    <div class="loader-box"></div>
    <div class="loader-box"></div>
    <div class="loader-box"></div>
    <div class="loader-wrap-text">
      <div class="text">
        <span>S</span>
        <span>C</span>
        <span>H</span>
        <span>O</span>
        <span>O</span>
        <span>L</span>
        <span></span>
        <span>W</span>
        <span>E</span>
        <span>B</span>
      </div>
    </div>
  </div>
</div>

<!-- preloader end -->


<!--header start-->

<?php include("main_header.php"); ?>

<!--header end-->


<!--page title start-->

<section class="page-title overflow-hidden position-relative" data-bg-color="#F2F0F7">
  <canvas id="confetti"></canvas>
  <div class="container">
    <div class="row align-items-center">
      <div class="col-lg-7 col-md-12">
        <h1 class="title"><span>C</span>ontact Us</h1>
        <!--<p>The best school management platform.</p>-->
      </div>
      <div class="col-lg-5 col-md-12 text-lg-end mt-3 mt-lg-0">
        <nav aria-label="breadcrumb" class="page-breadcrumb">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="index.html">Home</a>
            </li>
            <!--<li class="breadcrumb-item"><a href="#">Pages</a>
            </li>-->
            <li class="breadcrumb-item active" aria-current="page">Contact Us</li>
          </ol>
        </nav>
      </div>
    </div>
  </div>
  <div class="page-title-pattern">
    <img class="img-fluid" src="images/bg/11.png" alt="">
  </div>
</section>

<!--page title end-->


<!--body content start-->

<div class="page-content">
  <section class="contact-1">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-lg-6 col-md-12">
          <img class="img-fluid" src="images/banner/06.png" alt="">
        </div>
        <div class="col-lg-6 col-md-12 mt-5 mt-lg-0">
          <div class="section-title">
            <div class="title-effect title-effect-2">
              <div class="ellipse"></div> <i class="la la-info"></i>
            </div>
            <h2>Stay Contact Us</h2>
            <p>Get in touch and let us know how we can help. Fill out the form and we’ll be in touch as soon as possible.</p>
          </div>
          <form id="contact-form" method="post" action="php/contact.php">
            <div class="messages"></div>
            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <input id="form_name" type="text" name="name" class="form-control" placeholder="Type First name" required="required" data-error="Firstname is required.">
                  <div class="help-block with-errors"></div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <input id="form_lastname" type="text" name="surname" class="form-control" placeholder="Type Last name" required="required" data-error="Lastname is required.">
                  <div class="help-block with-errors"></div>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <input id="form_email" type="email" name="email" class="form-control" placeholder="Type Email" required="required" data-error="Valid email is required.">
                  <div class="help-block with-errors"></div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <input id="form_phone" type="tel" name="phone" class="form-control" placeholder="Type Phone" required="required" data-error="Phone is required">
                  <div class="help-block with-errors"></div>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-md-12">
                <div class="form-group">
                  <textarea id="form_message" name="message" class="form-control" placeholder="Type Message" rows="4" required="required" data-error="Please,leave us a message."></textarea>
                  <div class="help-block with-errors"></div>
                </div>
              </div>
              <div class="col-md-12 mt-2">
                <button class="btn btn-theme btn-circle" data-text="Send Message"><span>S</span><span>e</span><span>n</span><span>d</span>
                  <span> </span><span>M</span><span>e</span><span>s</span><span>s</span><span>a</span><span>g</span><span>e</span>
                </button>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </section>

  <section class="contact-info p-0 z-index-1">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-lg-4 col-md-12">
          <div class="contact-media"> <i class="flaticon-paper-plane"></i><span>Address:</span>
            <p>Shire Building, Opposite Airtel Malawi, Limbe.</p>
            <!--<p>P. O. Box 5113, Limbe.</p>-->
          </div>
        </div>
        <div class="col-lg-4 col-md-6 mt-5 mt-lg-0">
          <div class="contact-media"> <i class="flaticon-email"></i><span>Email Address</span><a href="mailto:info@schoolweb.com"> info@schoolweb.com</a>
          </div>
        </div>
        <div class="col-lg-4 col-md-6 mt-5 mt-lg-0">
          <div class="contact-media"> 
            <i class="flaticon-social-media"></i>
            <span>Phone Numbers</span>
            <a href="tel:+265995684047">+265 995 684 047</a><br>
            <a href="tel:+265881250897">+265 881 250 897</a>
          </div>
        </div>
      </div>
    </div>
  </section>

  <section class="overflow-hidden p-0 custom-mt-10 z-index-0">
    <div class="container-fluid p-0">
      <div class="row align-items-center">
        <div class="col-md-12">
          <div class="map iframe-h-2">
            <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3151.840108181602!2d144.95373631539215!3d-37.8172139797516!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x6ad65d4c2b349649%3A0xb6899234e561db11!2sEnvato!5e0!3m2!1sen!2sin!4v1497005461921" allowfullscreen=""></iframe>
          </div>
        </div>
      </div>
    </div>
  </section>


<!--body content end--> 


<!--footer start-->

<?php include("main_footer.php"); ?>

<!--footer end-->


</div>

<!-- page wrapper end -->


<!--back-to-top start-->

<div class="scroll-top"><a class="smoothscroll" href="#top"><i class="flaticon-go-up-in-web"></i></a></div>

<!--back-to-top end-->

 
<!-- inject js start -->

<!--== jquery -->
<script src="js/theme.js"></script>

<!--== owl-carousel -->
<script src="js/owl-carousel/owl.carousel.min.js"></script> 

<!--== magnific-popup --> 
<script src="js/magnific-popup/jquery.magnific-popup.min.js"></script>

<!--== counter -->
<script src="js/counter/counter.js"></script> 

<!--== countdown -->
<script src="js/countdown/jquery.countdown.min.js"></script> 

<!--== canvas -->
<script src="js/canvas.js"></script>

<!--== confetti -->
<script src="js/confetti.js"></script>

<!--== step animation -->
<script src="js/snap.svg.js"></script>
<script src="js/step.js"></script>

<!--== contact-form -->
<script src="js/contact-form/contact-form.js"></script>

<!--== wow -->
<script src="js/wow.min.js"></script>

<!--== theme-script -->
<script src="js/theme-script.js"></script>

<!-- inject js end -->

</body>

</html>