<?php
  require_once("../../session_check.php");
  require_once("../../../classes/main_classes.php");

  if(!isset($_POST["contact_message_id"])){
    die("<p class='alert alert-warning'>Invalid request</p>");
  }

  $contact_message_id=addslashes($_POST["contact_message_id"]);

  //OBJECTS
  $retrieveObj=new RETRIEVE();
  $updateObj=new UPDATE();

  $get_contact_message=$retrieveObj->retriever("contact_messages","*","contact_message_id",$contact_message_id,"fetch");

  if($get_contact_message=="1020"){
    die("<p class='alert alert-warning mt-2'>Message details not found. This could be because the message was deleted.</p>");
  }
?>

<div class="page-header flex-wrap">
  <h3 class="page-title"> 
    Contact messages
  </h3>
  <p class="mt-1">
    <a href="#contact-messages-view" onclick="contact_messages_view()" class="text_cprimary_color"><u>Contact messages</u></a> > 
      <span>Message > <?php echo $get_contact_message->subject; ?></span>
  </p>
</div>
<div class="row">
  <div class="col-xl-12 col-lg-12">
    <div class="card-deck">
      <div class=" card mb-3 p-2">
        <div class="card-header border-0">
          <div class="row align-items-center">
            <div class="col-md-12">
              <h5 class="mb-0">User contacts</h5>
            </div>
            
            <div class="col-md-12" id="delete_user_response"></div>
          </div>
        </div>
        <div class="card-body">
          <table class="table table-borderless">
            <tr>
              <th>Firstname</th>
              <td><?php echo $get_contact_message->firstname ?></td>
            </tr>
            <tr>
              <th>Lastname</th>
              <td><?php echo $get_contact_message->lastname ?></td>
            </tr>
            <tr>
              <th>Email</th>
              <td>
                <a href="mailto:<?php echo $get_contact_message->email ?>" class="">
                  <u><?php echo $get_contact_message->email ?></u>
                </a>
              </td>
            </tr>
            <tr>
              <th>Phone</th>
              <td>
                <a href="tel:<?php echo $get_contact_message->phone ?>" class="">
                  <u><?php echo $get_contact_message->phone ?></u>
                </a>
              </td>
            </tr>
            <tr>
              <th>Date</th>
              <td><?php echo date("M j, Y", strtotime($get_contact_message->date_added))." @".date("H:i A", strtotime($get_contact_message->date_added)) ?></td>
            </tr>
          </table>
        </div>
      </div>
      <div class=" card mb-3 p-2">
        <div class="card-header border-0 text-dark">
          <div class="row align-items-center">
            <div class="col-md-12">
              <h5 class="mb-0">User massage</h5>
            </div>
            
            <div class="col-md-12" id="delete_user_response"></div>
          </div>
        </div>
        <div class="card-body">
          <p><span class="font-weight-bold">Subject </span>: <span><?php echo $get_contact_message->subject; ?></span></p>
          <p class="d-flex justify-content-between mb-1">
            <label class="font-weight-bold">Message</label>
            <a href="#" class="btn btn-sm text-primary font-weight-bold" onclick="contact_message_reply_view(<?php echo $get_contact_message->contact_message_id ?>)">
              <u><span class="fas fa-reply"></span> Reply</u>
            </a>
          </p>
          <div class="border border-light p-2 rounded bg-light" >
            <div  class="p-2">
              <?php echo $get_contact_message->message; ?>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>