<?php
  require_once("../../session_check.php");
  require_once("../../../classes/main_classes.php");

  if(!isset($_POST["contact_message_id"])){
    die("<p class='alert alert-warning'>Invalid request</p>");
  }

  $contact_message_id=addslashes($_POST["contact_message_id"]);

  //OBJECTS
  $retrieveObj=new RETRIEVE();

  $get_contact_message=$retrieveObj->retriever("contact_messages","*","contact_message_id",$contact_message_id,"fetch");

  if($get_contact_message=="1020"){
    die("<p class='alert alert-warning'>Something went wrong, please try again later</p>");
  }
?>

<div class="page-header flex-wrap">
  <h3 class="page-title"> 
    Contact messages
  </h3>
  <p class="mt-1">
    <a href="#contact-messages-view" onclick="contact_messages_view()" class="text_cprimary_color"><u>Contact messages</u></a> > 
    <a href="#contact-messages-view" onclick="contact_message_details_view(<?php echo $get_contact_message->contact_message_id ?>)" class="text_cprimary_color"><u>
          <?php echo $get_contact_message->subject; ?></u>
          
    </a> > 
    <span>Reply</span>
  </p>
</div>
<div class="row">
  <div class="col-xl-12 col-lg-12">
    <div class="card-deck text-dark">
      <div class="card mb-3 p-2">
        <div class="card-header border-0">
          <div class="row align-items-center">
            <div class="col-md-12">
              <h5 class="mb-0">Reply to <i><?php echo $get_contact_message->firstname." ".$get_contact_message->lastname; ?></i></h5>
            </div>
            
            <div class="col-md-12" id="delete_user_response"></div>
          </div>
        </div>
        <div class="card-body">
          <form id="contact_message_reply_form">
            <div class="form-group">
              <label for="subject">Subject</label>
              <input class="form-control" type="text" name="subject" id="subject" placeholder="Subject">
            </div>
            <div class="form-group">
              <label for="message">Message</label>
              <textarea class="form-control" placeholder="Message" name="message" id="message" rows="5"></textarea>
            </div>
            <div class="form-group" id="contact_message_reply_response"></div>
            <div class="form-group text-center">
              <input type="hidden" name="contact_message_reply_note" value="<?php echo $contact_message_id ?>">
              <input type="hidden" name="email" value="<?php echo $get_contact_message->email; ?>">
              <button type="submit" class="btn bg_cprimary_color text-light" onclick="contact_message_reply(<?php echo $contact_message_id ?>)"><span class="fas fa-envelope"></span> Send Email</button>
            </div>
          </form>
        </div>
      </div>
      <div class="card mb-3 p-2">
        <div class="card-header text-dark">
          Replies
        </div>
        <div class="card-body" id="contact_message_replies_container">
          
        </div>
      </div>
    </div>
  </div>
</div>






<script type="text/javascript">
  $(document).ready(function () {
    contact_message_replies_view(<?php echo $contact_message_id ?>)
  })
</script>

