<?php
  require_once("../../session_check.php");
  require_once("../../../classes/main_classes.php");

  //OBJECTS
  $retrieveObj=new RETRIEVE();
  $allrowcountObj=new ALLROWCOUNT();
  $rowcountObj=new ROWCOUNT();

?>

<script type="text/javascript">
  var testimonial_image="";
</script>

<div class="page-header">
  <h3 class="page-title"> 
    Testimonials
  </h3>
  <p class="mt-1">
    <a href="#testimonials-view" onclick="testimonials_view()" class="text_cprimary_color"><u>Testimonials</u></a> > 
      <span>Add testimonial</span>
  </p>
</div>
<div class="row">
  <div class="col-xl-12 col-lg-12 stretch-card grid-margin">
   <div class="card bg_primary_dark_ascent p-3">
        <div class="card-header border-0">
          <div class="row align-items-center">
            <div class="col">
              <h4 class="mb-0 text-dark">Add testimonial</h4>
            </div>
          </div>
        </div>
        <div class="px-2">
          <form id="add_testimonial_form" class="row">
              <div class="col-md-6 my-2">
                <label class="text-dark font-weight-normal" for="t_fullname">Fullname*</label>
                <input class="form-control" type="text" name="t_fullname" placeholder="Enter fullname">
              </div>
              <div class="col-md-6 my-2">
                <label class="text-dark font-weight-normal" for="t_position">Position</label>
                <input class="form-control" type="text" name="t_position" placeholder="Enter position">
              </div>
              <div class="col-md-6 my-2">
                <label class="text-dark font-weight-normal" for="t_institution">Institution</label>
                <input class="form-control" type="text" name="t_institution" placeholder="Enter institution">
              </div>
              
              <div class="col-md-6 my-2">
                <label class="text-dark font-weight-normal" for="t_url">Url(link)</label>
                <input class="form-control" type="text" name="t_url" placeholder="Url (link) e.g https://example.com">
              </div>
              <div class="col-md-12 my-2">
                <label class="text-dark font-weight-normal" for="testimonial_image">Photo*</label>
                <input class="form-control" type="file" id="testimonial_image_">
              </div>
              <div class="col-md-12 my-2">
                <label class="text-dark font-weight-normal" for="t_message">Message</label>
                <textarea rows="4" class="form-control" placeholder="Testimonial message" name="t_message" id="t_message" class=""></textarea>
              </div>
              
              <div class="col-md-12 my-2" id="add_testimonial_response">
                
              </div>
              <div class="col-md-12 my-2 text-center">
                <input type="hidden" name="add_testimonial_note">
                <button type="submit" class="btn bg_cprimary_color text-light btn-block enter-btn" onclick="add_testimonial(testimonial_image)"><span class="fas fa-plus"></span> Add</button>
              </div>
            </form>
        </div>
      </div>
  </div>
</div>


<div id="uploadimageModal" class="modal" role="dialog">
  <div class="modal-dialog">
    <div class="modal-content bg_primary_dark_ascent">
          <div class="modal-header d-flex justify-content-between">
            <h4 class="modal-title text-light">Crop Image</h4>
            <button type="button" class="btn bg-dark" data-dismiss="modal">
              <span class="fas fa-times text-light"></span>
            </button>
          </div>
          <div class="modal-body">
            <div class="row">
                <div class="col-md-12 text-center">
                  <div id="image_demo" style="width:100%; margin-top:30px"></div>
                </div>
                <div class="col-md-12 text-center">
                  <button class="btn btn-light bg-dark text-light crop_image">Crop</button>
                </div>
            </div>
          </div>
      </div>
    </div>
</div>


<script>  
$(document).ready(function(){

  $image_crop = $('#image_demo').croppie({
    enableExif: true,
    viewport: {
      width:200,
      height:200,
      type:'square' //circle
    },
    boundary:{
      width:300,
      height:300
    }
  });
  


  $('#testimonial_image_').on('change', function(){
    var reader = new FileReader();
    reader.onload = function (event) {
      $image_crop.croppie('bind', {
        url: event.target.result
      }).then(function(){
        console.log('jQuery bind complete');
      });
    }
    reader.readAsDataURL(this.files[0]);
    $('#uploadimageModal').modal('show');
  });

  $('.crop_image').click(function(event){
    $image_crop.croppie('result', {
      type: 'canvas',
      size: "original", 
      format: "png",
      quality: 1
    }).then(function(response){
      testimonial_image=response;
      $('#uploadimageModal').modal('hide');
    })
  });

});  
</script>