<?php
  require_once("../../session_check.php");
  require_once("../../../classes/main_classes.php");

  if(!isset($_POST["b_id"])){
    die("<p class='alert alert-warning'>Invalid request</p>");
  }

  $b_id=addslashes($_POST["b_id"]);

  $retrieveObj=new RETRIEVE();

  //get last inserted item
  $get_blog=$retrieveObj->retriever("blog
      JOIN blog_categories ON blog_categories.b_category_id=blog.b_category_id
      WHERE blog.b_status='active' and blog.b_id='$b_id'","*","fetch");
  $blog_image=$get_blog->b_image;

  $get_blog_categories=$retrieveObj->retriever("blog_categories ORDER BY b_category_name","*","fetchAll");
?>



<h4 class="page-title">
  <span class="fas fa-blog"></span>
  Blog
</h4>
<p><a href="#" class="bold" onclick="blog_view()">Blog</a> <span class="fas fa-angle-right"></span> Edit blog post : <i><?php echo $get_blog->b_title; ?></i> </p>

<div class="content-wrapper ">
    <div class="row">
        <div class="col-md-12">
          <nav>
            <div class="nav nav-tabs" id="nav-tab" role="tablist">
              <a class="nav-item nav-link active" id="nav-information-tab" data-toggle="tab" href="#nav-information" role="tab" aria-controls="nav-information" aria-selected="true">Information</a>
              <a class="nav-item nav-link" id="nav-main-image-tab" data-toggle="tab" href="#nav-main-image" role="tab" aria-controls="nav-main-image" aria-selected="false">Image</a>
            </div>
          </nav>
          <div class="tab-content" id="nav-tabContent">
            <div class="tab-pane fade show active" id="nav-information" role="tabpanel" aria-labelledby="nav-information-tab">
                <div class="mx-auto card p-2">
                  <form id="edit_blog_form" class="row">
                    <div class="col-md-6">
                      <div class="my-2">
                        <input class="form-control" type="text" name="title" placeholder="Blog post title" value="<?php echo $get_blog->b_title; ?>">
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="my-2">
                        <select class="form-control" name="blog_category">
                          <option selected disabled>Blog category</option>
                          <?php
                            if($get_blog_categories!="1020"){
                              $selected_blog_category="";
                              foreach ($get_blog_categories as $blog_category) {
                                if($blog_category->b_category_id==$get_blog->b_category_id){
                                  $selected_blog_category=" selected ";
                                }else{
                                  $selected_blog_category="";
                                }

                            ?>
                                <option <?php echo $selected_blog_category; ?> value="<?php echo $blog_category->b_category_id; ?>"><?php echo $blog_category->b_category_name; ?></option>
                            <?php
                              }
                            }
                          ?>
                        </select>
                      </div>
                    </div>
                    <div class="col-md-12 pt-3">
                      <label for="">Blog post body :</label>
                      <textarea class="form-control" name="blog_post_body" id="blog_post_body"><?php echo $get_blog->b_body; ?></textarea>
                    </div>
                    <div class="col-md-12">
                      <div class="my-2" id="edit_blog_response">
                        
                      </div>

                      <div class="my-2">
                        <input type="hidden" name="edit_blog_note" value="<?php echo $get_blog->b_id ?>">
                        <button type="submit" class="btn btn-primary btn-block enter-btn" onclick="edit_blog()">Update</button>
                      </div>
                    </div>
                  </form>
                </div>
            </div>
            <div class="tab-pane fade" id="nav-main-image" role="tabpanel" aria-labelledby="nav-main-image-tab">
                <div class="mx-auto" style="max-width: 500px;">
                  <span class="hand_cursor mx-auto" data-toggle="collapse" data-target="#update_profile_container" id="profilePhotoContainer">
                      <?php 
                        if(!empty($get_blog->b_image)){
                          echo '<img id="blog_picture" src="../img/blogs/'.$get_blog->b_image.'?timestamp'.time().'" alt="..." style="max-height:250px" class="rounded mb-2 img-thumbnail" > ';
                        }else{
                          echo "<span class='fas fa-image fa-5x text-dark bg-light shadow-sm rounded border border-white' style='padding:8px 10px;'></span>";
                        }
                      ?>
                  </span>
                  <div id="update_profile_container" class="collapse" >
                    <span class="btn btn-primary btn-file my-1">
                        <input type="file" id="upload_image">
                    </span>
                  </div>
                  <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12" id="uploadimageContainer" style="display: none;">
                    <div class="row">
                            <div class="col-md-8 text-center">
                              <div id="image_demo" style="width:350px; margin-top:30px"></div>
                            </div>
                            <div class="col-md-4" style="padding-top:30px;">
                              <button class="btn btn-block btn-primary crop_image my-1">Update</button>
                          </div>
                        </div>
                  </div>
                </div>
            </div>
          </div>   
        </div>
    </div>
</div>

<script>  
  var editor = new Simditor({
    textarea: $('#blog_post_body')
    //optional options
  });
  
  var blog_image='<?php echo $blog_image ?>';
  $(document).ready(function(){
    var d=new Date();
    var upload_btn_action=$(this).text();
    var image_crop = $('#image_demo').croppie({
      enableExif: true,
      viewport: {
        width:200,
        height:125,
        type:'square' //circle
      },
      boundary:{
        width:300,
        height:300
      }
    });
    


    $('#upload_image').on('change', function(){
      var reader = new FileReader();
      reader.onload = function (event) {
        image_crop.croppie('bind', {
          url: event.target.result
        }).then(function(){
          console.log('jQuery bind complete');
        });
      }
      reader.readAsDataURL(this.files[0]);
      $('#uploadimageContainer').show();
      $('html, body').animate({
          scrollTop: $("#uploadimageContainer").offset().top
      }, 1000);
    });

    $('.crop_image').click(function(event){
      $.LoadingOverlay("show");
      upload_btn_action=$(this).text();
      image_crop.croppie('result', {
        type: 'canvas',
        size: "original", 
        format: "png",
        quality: 1
      }).then(function(response){
        $.ajax({
          url:"includes_/blogs/upload_blog_post_image.php",
          type: "POST",
          data:{"image": response,b_id:<?php echo $b_id ?>},
          
          cache: false,
             
          success:function(data)
          { 
            $.LoadingOverlay("hide", true); 
            //$('#uploadimageContainer').modal('hide');
            if(data==1){
              $("#blog_picture").attr("src","../img/blogs/"+blog_image+"?timestamp"+d.getTime())
              $("#uploadimageContainer").hide()
            }
          }
        });
      })
    });

  });  
</script>


