<?php
require_once("../session_check.php");
require_once("../../classes/main_classes.php");

if($sign_in_status=="out"){
	die("<p class='alert alert-warning'>Login Session expired</p>");
}

//OBJECTS
$retrieveObj=new RETRIEVE();
$rowcountObj=new ROWCOUNT();
$allrowcountObj=new ALLROWCOUNT();

$get_contact_us=$retrieveObj->retriever("contact_us ORDER BY c_id DESC LIMIT 5","*","fetchAll");
$get_contact_us_count=$allrowcountObj->allrowcounter("contact_us","*");

$get_blog_comments=$retrieveObj->retriever("blog JOIN blog_comments ON blog.b_id=blog_comments.b_id ORDER BY blog_comments.bc_id DESC LIMIT 5","*","fetchAll");
$get_blog_comments_count=$allrowcountObj->allrowcounter("blog JOIN blog_comments ON blog.b_id=blog_comments.b_id","*");


?>

<h4 class="page-title">
	<span class="la la-dashboard"></span>
	Dashboard
</h4>
	<div class="row">
		<div class="col-md-12 mb-3">
			<div class="card-deck">
				<div class="card card-stats card-warning hand_cursor" onclick="users_view()">
					<div class="card-body ">
						<div class="row">
							<div class="col-5">
								<div class="icon-big text-center">
									<i class="la la-users"></i>
								</div>
							</div>
							<div class="col-7 d-flex align-items-center">
								<div class="numbers">
									<p class="card-category">Users</p>
									<h4 class="card-title"><?php echo $allrowcountObj->allrowcounter("users","*"); ?></h4>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="card card-stats card-success hand_cursor" onclick="products_view()">
					<div class="card-body ">
						<div class="row">
							<div class="col-5">
								<div class="icon-big text-center">
									<i class="la la-cubes"></i>
								</div>
							</div>
							<div class="col-7 d-flex align-items-center">
								<div class="numbers">
									<p class="card-category">Products</p>
									<h4 class="card-title"><?php echo $allrowcountObj->allrowcounter("products","*"); ?></h4>
								</div>
							</div>
						</div>
					</div>
				</div>
			
				<div class="card card-stats card-danger hand_cursor" onclick="miscellaneous_goods_view()">
					<div class="card-body">
						<div class="row">
							<div class="col-5">
								<div class="icon-big text-center">
									<i class="la la-cubes"></i>
								</div>
							</div>
							<div class="col-7 d-flex align-items-center">
								<div class="numbers">
									<p class="card-category">Miscellaneous Goods</p>
									<h4 class="card-title"><?php echo $allrowcountObj->allrowcounter("miscellaneous_goods","*"); ?></h4>
								</div>
							</div>
						</div>
					</div>
				</div>
			
				<div class="card card-stats card-primary hand_cursor" onclick="blog_view()">
					<div class="card-body ">
						<div class="row">
							<div class="col-5">
								<div class="icon-big text-center">
									<i class="fas fa-blog"></i>
								</div>
							</div>
							<div class="col-7 d-flex align-items-center">
								<div class="numbers">
									<p class="card-category">Blog Posts</p>
									<h4 class="card-title"><?php echo $allrowcountObj->allrowcounter("blog","*"); ?></h4>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
				
		</div>

	</div>
	<div class="row card-deck">
		<div class="col-md-3 card">
				<div class="card-header">
					<h4 class="card-title">Recent contacts</h4>
				</div>
				<div class="card-body bg-light">
					<?php
						if($get_contact_us!="1020"){
					?>
						<table class="table table-striped">
					<?php
							foreach ($get_contact_us as $contact_us) {
					?>
								<tr class="hand_cursor" onclick="not_contact_us_details_view(<?php echo $contact_us->c_id ?>)">
									<td>
										<span><?php echo $contact_us->fullname; ?></span><br>
										<span class="text-muted">
											<?php echo $contact_us->email; ?>
										</span>
									</td>
								</tr>
					<?php
							}
					?>
						</table>
					<?php
						}else{
							echo "<p class='alert alert-info text-center'>There are no contacts currently.</p>";
						}
					?>		
				</div>
				<?php
					if($get_contact_us_count>5){
				?>
						<div class="text-center card-footer">
							<a href="#" onclick="contact_us_view()">View All</a>
						</div>
				<?php
					}
				?>
		</div>
		<div class="col-md-9 card">
			<div class="bg-white p-2">
				<h6 class="my-2 text-center">Recent blog comments</h6>
				<div class="card-body">
					<?php
						if($get_blog_comments!="1020"){
					?>
						<table class="table">
							<thead>
								<tr>
									<th>Blog title</th>
									<th>Comment Author</th>
									<th>Comment Date</th>
									<th></th>
								</tr>
							</thead>
							<tbody>
					<?php
							foreach ($get_blog_comments as $blog_comment) {
					?>
								<tr>
									<td><?php echo $blog_comment->b_title ?></td>
									<td><?php echo $blog_comment->bc_fullname ?></td>
									<td><?php echo date("d-m-Y H:i:s", strtotime($blog_comment->bc_time)); ?></td>
									<td>
										<button class="btn btn-info" onclick="blog_post_comment_reply_view(<?php echo $blog_comment->bc_id; ?>)">
											<span class="fas fa-info"></span>
											Details
										</button>
									</td>
								</tr>
					<?php
							}
					?>
							</tbody>
						</table>
					<?php
						}else{
							echo "<p class='alert alert-info text-center'>There are no comments currently.</p>";
						}
					?>		
				</div>
				<?php
					if($get_blog_comments_count>5){
				?>
						<div class="text-center card-footer">
							<a href="#" onclick="contact_us_view()">View All</a>
						</div>
				<?php
					}
				?>
			</div>
		</div>
	</div>
	

<script src="assets/js/demo.js?<?php echo date("Y-m-d").time() ?>"></script>