<?php
	require_once("../../classes/main_classes.php");
	require_once("../session_check.php");
	

	if($sign_in_status=="out" or $user_id==null){
        die("<p class='alert alert-warning'>Security error, this may be bacause your login session has expired</p>");
    }

	//OBJECTS
	$retrieveObj=new RETRIEVE();
	$insertObj=new INSERT();
	$rowcountObj=new ROWCOUNT();
	$updateObj=new UPDATE();
	$deleteObj=new DELETE();

	if(isset($_POST["user_signout_note"])){
		try{
			unset($_SESSION['gh_admin_in_email']);
			unset($_SESSION['gh_admin_in_id']);
			unset($_SESSION['gh_admin_in_type']);
			session_destroy();
			echo 1;
		}catch(Exception $e){
			echo 0;
		}
	}

	if(isset($_POST["add_user_note"])){
		if(empty($_POST["firstname"])){
			die("<p class='alert alert-warning'>Enter firstname</p>");
		}else if(empty($_POST["lastname"])){
			die("<p class='alert alert-warning'>Enter lastname</p>");
		}else if(empty($_POST["username"])){
			die("<p class='alert alert-warning'>Enter username</p>");
		}else if(empty($_POST["email"])){
			die("<p class='alert alert-warning'>Enter email</p>");
		}else if(empty($_POST["user_role"])){
			die("<p class='alert alert-warning'>Select user role</p>");
		}if(empty($_POST["password"])){
			die("<p class='alert alert-warning'>Enter Password</p>");
		}else if(empty($_POST["rpassword"])){
			die("<p class='alert alert-warning'>Re-enter password</p>");
		}else if($_POST["password"]!=$_POST["rpassword"]){
			die("<p class='alert alert-warning'>Passwords do not match</p>");
		}else if(strlen($_POST["password"])<8){
			die("<p class='alert alert-warning'>Your password is too short, make sure it is at least 8 characters long</p>");
		}

		//GET VALUES
		$firstname=addslashes($_POST["firstname"]);
		$lastname=addslashes($_POST["lastname"]);
		$username=addslashes($_POST["username"]);
		$email=addslashes($_POST["email"]);
		$user_role=addslashes($_POST["user_role"]);

		$password=addslashes($_POST["password"]);

		$password=password_hash($password, PASSWORD_DEFAULT);
		$fields=array("firstname","lastname","username","email","password");
		$data=array($firstname,$lastname,$username,$email,$password);

		$create_account=$insertObj->inserter("users",$fields,$data);
		if($create_account=="1"){
			//set role
			
			$get_user_id=$retrieveObj->retriever("users","*","email",$email,"fetch");
			if( $get_user_id!="1020"){
				//insert role
				$fields2=array("user_id","role_id");
				$data2=array($get_user_id->user_id,$user_role);

				$create_account2=$insertObj->inserter("user_roles",$fields2,$data2);
				if($create_account2=="1"){
					echo 1;
				}else{
					//failed
					$deleteObj->deleter("users","email",$email);
					echo 0;
				}
			}else{
				//failed
				$deleteObj->deleter("users","email",$email);
				echo 0;
			}
		}else if($create_account=="entry_exists"){
			echo "<p class='alert alert-warning'>Another user is using the email you entered</p>";
		}else{
			echo 0;
		}
	}

	if(isset($_POST["edit_user_note"])){
		$another_user_id=addslashes($_POST["edit_user_note"]);

		//VALIDATION
		if(empty($_POST["firstname"])){
			die("<p class='alert alert-warning'>Enter firstname</p>");
		}else if(empty($_POST["lastname"])){
			die("<p class='alert alert-warning'>Enter lastname</p>");
		}else if(empty($_POST["username"])){
			die("<p class='alert alert-warning'>Enter username</p>");
		}else if(empty($_POST["email"])){
			die("<p class='alert alert-warning'>Enter email</p>");
		}

		//GET VALUES
		$firstname=addslashes($_POST["firstname"]);
		$lastname=addslashes($_POST["lastname"]);
		$username=addslashes($_POST["username"]);
		$email=addslashes($_POST["email"]);


		$data="firstname='$firstname',lastname='$lastname',username='$username',email='$email'";

		$update=$updateObj->updater("users",$data,"user_id",$another_user_id);

		if($update=="1"){
			echo 1;
		}else if ($update=="0"){
			echo 0;
		}else if($update=="entry_exists"){
			die("<p class='alert alert-warning'>The email you entered is being used by another user</p>");
		}else{
			die("<p class='alert alert-warning'>Something went wrong, please try again later</p>");
		}
	}

	if(isset($_POST["delete_user_note"])){
		$d_user_id=addslashes($_POST["delete_user_note"]);

		//delete property from database
		$delete=$updateObj->updater("users","status='deleted'","user_id",$d_user_id);
		if($delete=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}
	if(isset($_POST["restore_user_note"])){
		$d_user_id=addslashes($_POST["restore_user_note"]);

		//delete property from database
		$restore=$updateObj->updater("users","status='active'","user_id",$d_user_id);
		if($restore=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}
	if(isset($_POST["permanently_delete_user_note"])){
		$d_user_id=addslashes($_POST["permanently_delete_user_note"]);

		//delete property from database
		$delete=$deleteObj->deleter("users","user_id",$d_user_id);
		if($delete=="1"){
			echo 1;
		}else if($delete=="delete_restricted"){
			echo "<p class='alert alert-warning'>You cannot delete this user, the user is associated with some important data</p>";
		}else{
			echo 0;
		}
		
	}

	if(isset($_POST["add_product_note"])){
		if(
			empty($_POST["product_name"]) 
			or empty($_POST["product_category"]) or 
			empty($_POST["price"]) or 
			empty($_POST["product_description"])
		){
			die("<p class='alert alert-warning'>Fill all fields</p>");
		}

		$product_name=addslashes($_POST["product_name"]);
		$product_category=addslashes($_POST["product_category"]);
		$price=addslashes($_POST["price"]);
		$product_description=addslashes($_POST["product_description"]);

		$fields=array(
			"p_name",
			"p_price",
			"p_category",
			"p_description",
			"user_id"
		);
		$data=array(
			$product_name,
			$price,
			$product_category,
			$product_description,
			$user_id
		);

		$insert=$insertObj->inserter("products",$fields,$data);

		if($insert=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}

	if(isset($_POST["add_blog_note"])){
		if(
			empty($_POST["title"]) 
			or empty($_POST["blog_category"]) or 
			empty($_POST["blog_post_body"])
		){
			die("<p class='alert alert-warning'>Fill all fields</p>");
		}

		$title=addslashes($_POST["title"]);
		$blog_category=addslashes($_POST["blog_category"]);
		$blog_post_body=addslashes($_POST["blog_post_body"]);

		$fields=array(
			"b_title",
			"b_category_id",
			"b_body",
			"user_id"
		);
		$data=array(
			$title,
			$blog_category,
			$blog_post_body,
			$user_id
		);

		$insert=$insertObj->inserter("blog",$fields,$data);

		if($insert=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}

	if(isset($_POST["add_miscellaneous_good_note"])){
		if(
			empty($_POST["mg_name"]) or
			empty($_POST["price"]) or 
			empty($_POST["mg_description"])
		){
			die("<p class='alert alert-warning'>Fill all fields</p>");
		}

		$mg_name=addslashes($_POST["mg_name"]);
		$price=addslashes($_POST["price"]);
		$mg_description=addslashes($_POST["mg_description"]);

		$fields=array(
			"mg_name",
			"mg_price",
			"mg_description",
			"user_id"
		);
		$data=array(
			$mg_name,
			$price,
			$mg_description,
			$user_id
		);

		$insert=$insertObj->inserter("miscellaneous_goods",$fields,$data);

		if($insert=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}

	if(isset($_POST["edit_product_note"])){
		if(
			empty($_POST["product_name"]) or 
			empty($_POST["product_category"]) or 
			empty($_POST["price"]) or 
			empty($_POST["product_description"])
		){
			die("<p class='alert alert-warning'>Fill all fields</p>");
		}else if(empty($_POST["edit_product_note"])){
			die(0);
		}

		$product_name=addslashes($_POST["product_name"]);
		$product_category=addslashes($_POST["product_category"]);
		$price=addslashes($_POST["price"]);
		$product_description=addslashes($_POST["product_description"]);
		$p_id=addslashes($_POST["edit_product_note"]);

		$data="
			p_name='$product_name',
			p_price='$price',
			p_category='$product_category',
			p_description='$product_description'
		";

		$update=$updateObj->updater("products",$data,"p_id",$p_id);

		if($update=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}

	if(isset($_POST["edit_blog_note"])){
		$current_date_time=date("Y-m-d H:i:s");

		if(
			empty($_POST["title"]) 
			or empty($_POST["blog_category"]) or 
			empty($_POST["blog_post_body"])
		){
			die("<p class='alert alert-warning'>Fill all fields</p>");
		}

		$title=addslashes($_POST["title"]);
		$blog_category=addslashes($_POST["blog_category"]);
		$blog_post_body=addslashes($_POST["blog_post_body"]);
		$b_id=addslashes($_POST["edit_blog_note"]);
		
		$data="
			b_title='$title',
			b_category_id='$blog_category',
			b_body='$blog_post_body',
			b_last_date_edited='$current_date_time'
		";

		$update=$updateObj->updater("blog",$data,"b_id",$b_id);

		if($update=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}

	if(isset($_POST["edit_miscellaneous_good_note"])){
		if(
			empty($_POST["mg_name"]) or 
			empty($_POST["price"]) or 
			empty($_POST["mg_description"])
		){
			die("<p class='alert alert-warning'>Fill all fields</p>");
		}else if(empty($_POST["edit_miscellaneous_good_note"])){
			die(0);
		}

		$mg_name=addslashes($_POST["mg_name"]);
		$price=addslashes($_POST["price"]);
		$mg_description=addslashes($_POST["mg_description"]);
		$mg_id=addslashes($_POST["edit_miscellaneous_good_note"]);

		$data="
			mg_name='$mg_name',
			mg_price='$price',
			mg_description='$mg_description'
		";

		$update=$updateObj->updater("miscellaneous_goods",$data,"mg_id",$mg_id);

		if($update=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}

	if(isset($_POST["add_product_supporting_images_note"])){
		if(empty($_FILES["upload_supporting_images"])){
			die("<p class='alert alert-warning'>Plase select images</p>");
		}
		
		//get last inserted item
		$get_product=$retrieveObj->retriever("products","*","products.user_id",$user_id,"products.p_id","DESC","fetch");

		//print_r($_FILES);
		$loop_count=0;
		foreach($_FILES['upload_supporting_images']['name'] as $key=>$val){
			$loop_count++;
			
		    $file_name = $_FILES['upload_supporting_images']['name'][$key];

		    $photo_id=str_replace("-", "_",date("Y-m-d")."".time());
		    $imageNameDir = "/../../img/products/";
			$imageName = "p_photo".$photo_id.rand(0,9).$loop_count.rand(0,9).'.png';
		 
		    // get file extension
		    $ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
		 
		    // get filename without extension
		    $filenamewithoutextension = pathinfo($file_name, PATHINFO_FILENAME);
		 
		    if (!file_exists(getcwd().$imageNameDir)) {
		        mkdir(getcwd().$imageNameDir, 0777);
		    }
		 
		    $filename_to_store = $filenamewithoutextension. '_' .uniqid(). '.' .$ext;
		    if(move_uploaded_file($_FILES['upload_supporting_images']['tmp_name'][$key], getcwd(). $imageNameDir.$imageName)){

		    }else{
		    	die("error");
		    }

		    $fields=array("p_id","p_image","p_image_type");
			$data=array($get_product->p_id,$imageName,"secondary_image");

			$query=$insertObj->inserter("product_images",$fields,$data);
		}
		echo 1;
	}

	if(isset($_POST["add_miscellaneous_good_supporting_images_note"])){
		if(empty($_FILES["upload_supporting_images"])){
			die("<p class='alert alert-warning'>Plase select images</p>");
		}
		
		//get last inserted item
		$get_miscellaneous_good=$retrieveObj->retriever("miscellaneous_goods","*","miscellaneous_goods.user_id",$user_id,"miscellaneous_goods.mg_id","DESC","fetch");

		//print_r($_FILES);
		$loop_count=0;
		foreach($_FILES['upload_supporting_images']['name'] as $key=>$val){
			$loop_count++;
			
		    $file_name = $_FILES['upload_supporting_images']['name'][$key];

		    $photo_id=str_replace("-", "_",date("Y-m-d")."".time());
		    $imageNameDir = "/../../img/miscellaneous_goods/";
			$imageName = "mg_photo".$photo_id.rand(0,9).$loop_count.rand(0,9).'.png';
		 
		    // get file extension
		    $ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
		 
		    // get filename without extension
		    $filenamewithoutextension = pathinfo($file_name, PATHINFO_FILENAME);
		 
		    if (!file_exists(getcwd().$imageNameDir)) {
		        mkdir(getcwd().$imageNameDir, 0777);
		    }
		 
		    $filename_to_store = $filenamewithoutextension. '_' .uniqid(). '.' .$ext;
		    if(move_uploaded_file($_FILES['upload_supporting_images']['tmp_name'][$key], getcwd(). $imageNameDir.$imageName)){

		    }else{
		    	die("error");
		    }

		    $fields=array("mg_id","mg_image","mg_image_type");
			$data=array($get_miscellaneous_good->mg_id,$imageName,"secondary_image");

			$query=$insertObj->inserter("miscellaneous_good_images",$fields,$data);
		}
		echo 1;
	}

	if(isset($_POST["remove_product_supporting_image_note"])){
		$p_image_id=addslashes($_POST["remove_product_supporting_image_note"]);

		//get photo name
		$get_image=$retrieveObj->retriever("product_images","*","p_image_id",$p_image_id,"fetch");

		if($get_image!="1020"){
			$image_name=$get_image->p_image;

			$delete=$deleteObj->deleter("product_images","p_image_id",$p_image_id);

			if($delete==1){
				unlink("../../img/products/".$image_name);
				echo 1;
			}else{
				echo 0;
			}
		}else{
			die(0);
		}
	}

	if(isset($_POST["remove_miscellaneous_good_supporting_image_note"])){
		$mg_image_id=addslashes($_POST["remove_miscellaneous_good_supporting_image_note"]);

		//get photo name
		$get_image=$retrieveObj->retriever("miscellaneous_good_images","*","mg_image_id",$mg_image_id,"fetch");

		if($get_image!="1020"){
			$image_name=$get_image->mg_image;

			$delete=$deleteObj->deleter("miscellaneous_good_images","mg_image_id",$mg_image_id);

			if($delete==1){
				unlink("../../img/miscellaneous_goods/".$image_name);
				echo 1;
			}else{
				echo 0;
			}
		}else{
			die(0);
		}
	}

	if(isset($_POST["add_more_product_supporting_images_note"])){
		if(empty($_FILES["upload_other_images"])){
			die("<p class='alert alert-warning'>Plase select images</p>");
		}
		
		//get last inserted item
		$p_id=addslashes($_POST["add_more_product_supporting_images_note"]);

		//print_r($_FILES);
		$loop_count=0;
		foreach($_FILES['upload_other_images']['name'] as $key=>$val){
			$loop_count++;
			
		    $file_name = $_FILES['upload_other_images']['name'][$key];

		    $photo_id=str_replace("-", "_",date("Y-m-d")."".time());
		    $imageNameDir = "/../../img/products/";
			$imageName = "p_photo".$photo_id.rand(0,9).$loop_count.rand(0,9).'.png';
		 
		    // get file extension
		    $ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
		 
		    // get filename without extension
		    $filenamewithoutextension = pathinfo($file_name, PATHINFO_FILENAME);
		 
		    if (!file_exists(getcwd().$imageNameDir)) {
		        mkdir(getcwd().$imageNameDir, 0777);
		    }
		 
		    $filename_to_store = $filenamewithoutextension. '_' .uniqid(). '.' .$ext;
		    move_uploaded_file($_FILES['upload_other_images']['tmp_name'][$key], getcwd(). $imageNameDir.$imageName);

		    $fields=array("p_id","p_image","p_image_type");
			$data=array($p_id,$imageName,"secondary_image");

			$query=$insertObj->inserter("product_images",$fields,$data);
		}
		echo 1;
	}

	if(isset($_POST["add_more_miscellaneous_good_supporting_images_note"])){
		if(empty($_FILES["upload_other_images"])){
			die("<p class='alert alert-warning'>Plase select images</p>");
		}
		
		//get last inserted item
		$mg_id=addslashes($_POST["add_more_miscellaneous_good_supporting_images_note"]);

		//print_r($_FILES);
		$loop_count=0;
		foreach($_FILES['upload_other_images']['name'] as $key=>$val){
			$loop_count++;
			
		    $file_name = $_FILES['upload_other_images']['name'][$key];

		    $photo_id=str_replace("-", "_",date("Y-m-d")."".time());
		    $imageNameDir = "/../../img/miscellaneous_goods/";
			$imageName = "mg_photo".$photo_id.rand(0,9).$loop_count.rand(0,9).'.png';
		 
		    // get file extension
		    $ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
		 
		    // get filename without extension
		    $filenamewithoutextension = pathinfo($file_name, PATHINFO_FILENAME);
		 
		    if (!file_exists(getcwd().$imageNameDir)) {
		        mkdir(getcwd().$imageNameDir, 0777);
		    }
		 
		    $filename_to_store = $filenamewithoutextension. '_' .uniqid(). '.' .$ext;
		    move_uploaded_file($_FILES['upload_other_images']['tmp_name'][$key], getcwd(). $imageNameDir.$imageName);

		    $fields=array("mg_id","mg_image","mg_image_type");
			$data=array($mg_id,$imageName,"secondary_image");

			$query=$insertObj->inserter("miscellaneous_good_images",$fields,$data);
		}
		echo 1;
	}


	if(isset($_POST["remove_product_note"])){
		$d_p_id=addslashes($_POST["remove_product_note"]);

		//delete property from database
		$delete=$updateObj->updater("products","p_status='deleted'","p_id",$d_p_id);
		if($delete=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}
	if(isset($_POST["remove_contact_us_note"])){
		$d_c_id=addslashes($_POST["remove_contact_us_note"]);

		//delete property from database
		$delete=$updateObj->updater("contact_us","c_status='deleted'","c_id",$d_c_id);
		if($delete=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}
	if(isset($_POST["remove_blog_note"])){
		$d_b_id=addslashes($_POST["remove_blog_note"]);

		//delete property from database
		$delete=$updateObj->updater("blog","b_status='deleted'","b_id",$d_b_id);
		if($delete=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}
	if(isset($_POST["remove_miscellaneous_good_note"])){
		$d_mg_id=addslashes($_POST["remove_miscellaneous_good_note"]);

		//delete property from database
		$delete=$updateObj->updater("miscellaneous_goods","mg_status='deleted'","mg_id",$d_mg_id);
		if($delete=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}
	if(isset($_POST["restore_product_note"])){
		$d_p_id=addslashes($_POST["restore_product_note"]);

		//delete property from database
		$restore=$updateObj->updater("products","p_status='active'","p_id",$d_p_id);
		if($restore=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}

	if(isset($_POST["restore_contact_us_note"])){
		$d_c_id=addslashes($_POST["restore_contact_us_note"]);

		//delete property from database
		$restore=$updateObj->updater("contact_us","c_status='active'","c_id",$d_c_id);
		if($restore=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}

	if(isset($_POST["restore_blog_note"])){
		$d_b_id=addslashes($_POST["restore_blog_note"]);

		//delete property from database
		$restore=$updateObj->updater("blog","b_status='active'","b_id",$d_b_id);
		if($restore=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}

	if(isset($_POST["restore_miscellaneous_good_note"])){
		$d_mg_id=addslashes($_POST["restore_miscellaneous_good_note"]);

		//delete property from database
		$restore=$updateObj->updater("miscellaneous_goods","mg_status='active'","mg_id",$d_mg_id);
		if($restore=="1"){
			echo 1;
		}else{
			echo 0;
		}
	}

	if(isset($_POST["delete_product_note"])){
		$d_p_id=addslashes($_POST["delete_product_note"]);

		//delete images
		$get_images_info=$retrieveObj->retriever("product_images","*","p_id",$d_p_id,"fetchAll");
		
		if($get_images_info!="1020"){
			foreach ($get_images_info as $image_info) {
				$image_name=$image_info->p_image;
				if(file_exists("../../../img/products/".$image_name)){
					unlink("../../../img/products/".$image_name);
				}
				
			}
			//delete property from database
			$delete=$deleteObj->deleter("products","p_id",$d_p_id);
			if($delete=="1"){
				echo 1;
			}else{
				echo 0;
			}
		}
		
	}

	if(isset($_POST["delete_blog_note"])){
		$d_b_id=addslashes($_POST["delete_blog_note"]);

		//delete images
		$get_blog_info=$retrieveObj->retriever("blog","*","b_id",$d_b_id,"fetch");
		
		if($get_blog_info!="1020"){
			$image_name=$get_blog_info->b_image;
			if(file_exists("../../../img/blogs/".$image_name)){
				unlink("../../../img/blogs/".$image_name);
			}
				
			//delete property from database
			$delete=$deleteObj->deleter("blog","b_id",$d_b_id);
			if($delete=="1"){
				echo 1;
			}else{
				echo 0;
			}
		}
		
	}

	if(isset($_POST["delete_blog_post_comment_note"])){
		$d_bc_id=addslashes($_POST["delete_blog_post_comment_note"]);
	
		//delete property from database
		$delete=$deleteObj->deleter("blog_comments","bc_id",$d_bc_id);
		if($delete=="1"){
			echo 1;
		}else{
			echo 0;
		}
		
		
	}

	if(isset($_POST["delete_contact_us_note"])){
		$d_c_id=addslashes($_POST["delete_contact_us_note"]);
	
		//delete property from database
		$delete=$deleteObj->deleter("contact_us","c_id",$d_c_id);
		if($delete=="1"){
			echo 1;
		}else{
			echo 0;
		}
		
		
	}

	if(isset($_POST["delete_blog_post_comment_reply_note"])){
		$d_bcr_id=addslashes($_POST["delete_blog_post_comment_reply_note"]);
	
		//delete property from database
		$delete=$deleteObj->deleter("blog_comment_replies","bcr_id",$d_bcr_id);
		if($delete=="1"){
			echo 1;
		}else{
			echo 0;
		}
		
		
	}

	if(isset($_POST["delete_miscellaneous_good_note"])){
		$d_mg_id=addslashes($_POST["delete_miscellaneous_good_note"]);

		//delete images
		$get_images_info=$retrieveObj->retriever("miscellaneous_good_images","*","mg_id",$d_mg_id,"fetchAll");
		
		if($get_images_info!="1020"){
			foreach ($get_images_info as $image_info) {
				$image_name=$image_info->mg_image;
				if(file_exists("../../../img/miscellaneous_goods/".$image_name)){
					unlink("../../../img/miscellaneous_goods/".$image_name);
				}
			}
			//delete property from database
			$delete=$deleteObj->deleter("miscellaneous_goods","mg_id",$d_mg_id);
			if($delete=="1"){
				echo 1;
			}else{
				echo 0;
			}
		}
		
	}

	if(isset($_POST["delete_blog_category_note"])){
		$b_category_id=addslashes($_POST["delete_blog_category_note"]);

		$delete=$deleteObj->deleter("blog_categories","b_category_id",$b_category_id);
		if($delete=="1"){
			echo 1;
		}else{
			echo 0;
		}
		
	}


	if(isset($_POST["add_blog_category_note"])){
		if(empty($_POST["category_name"])){
			die("<p class='alert alert-warning'></p>");
		}

		$category_name=addslashes($_POST["category_name"]);

		$fields=array("b_category_name");
		$data=array($category_name);

		$insert=$insertObj->inserter("blog_categories",$fields,$data);

		if($insert=="1"){
			echo 1;
		}else if($insert=="entry_exists"){
			echo "exists";
		}else{
			echo 0;
		}

	}

	if(isset($_POST["add_blog_comment_reply_note"])){
		if(empty($_POST["reply"])){
			die("<p class='alert alert-warning'>Enter reply text</p>");
		}

		$reply=addslashes($_POST["reply"]);
		$bc_id=addslashes($_POST["add_blog_comment_reply_note"]);

		$fields=array("bcr_text","user_id","bc_id");
		$data=array($reply,$user_id,$bc_id);

		$insert=$insertObj->inserter("blog_comment_replies",$fields,$data);

		if($insert=="1"){
			echo 1;
		}else if($insert=="entry_exists"){
			echo "exists";
		}else{
			echo 0;
		}

	}

	if(isset($_POST["edit_blog_comment_reply_note"])){
		if(empty($_POST["reply"])){
			die("<p class='alert alert-warning'>Enter reply text</p>");
		}

		$reply=addslashes($_POST["reply"]);
		$bcr_id=addslashes($_POST["edit_blog_comment_reply_note"]);

		$data="bcr_text='$reply'";

		$update=$updateObj->updater("blog_comment_replies",$data,"bcr_id",$bcr_id);

		if($update=="1"){
			echo 1;
		}else if($insert=="entry_exists"){
			echo "exists";
		}else{
			echo 0;
		}

	}


	if(isset($_POST["edit_blog_category_note"])){
		if(empty($_POST["category_name"])){
			die("<p class='alert alert-warning'></p>");
		}

		$b_category_id=addslashes($_POST["edit_blog_category_note"]);
		$category_name=addslashes($_POST["category_name"]);

		$data="b_category_name='$category_name'";

		$update=$updateObj->updater("blog_categories",$data,"b_category_id",$b_category_id);

		if($update=="1"){
			echo 1;
		}else if($insert=="entry_exists"){
			echo "exists";
		}else{
			echo 0;
		}

	}

	if(isset($_POST["set_all_notifications_to_seen_note"])){
		$update=$updateObj->updater("admin_notification_targets","ant_seen_status='1'","user_id",$user_id);

		if($update==1){
			echo 1;
		}else{
			echo 0;
		}
	}
	if(isset($_POST["reflesh_notifications_count_note"])){
		echo $get_notifications_count=$rowcountObj->rowcounter("admin_notifications JOIN admin_notification_targets ON admin_notifications.an_id=admin_notification_targets.an_id","*","admin_notification_targets.ant_seen_status",0);
	}
?>