<?php
  require_once("classes/main_classes.php");

  //OBJECTS
  $retrieveObj=new RETRIEVE();
  $rowcountObj=new ROWCOUNT();

  //PAGE LOCATION VARIABLES
  $plv_home="";
  $plv_products="";
  $plv_miscellaneous_goods="";
  $plv_blog=" active ";
  $plv_about="";
  $plv_contact="";

  $get_blog_categories=$retrieveObj->retriever("blog_categories","*","fetchAll");
  $get_recent_blog_posts=$retrieveObj->retriever("blog ORDER BY b_id DESC LIMIT 4","*","fetchAll");

?>


<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Blog - Raising Value</title>
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <meta content="Raising Value, Prof Stanley Chindikani Msiska" name="keywords">
  <meta content="View latest news from Raising Value. Raisingvalue is a product production, service provision and trading company established in 2020 by Mr. Stanley Chindikani Msiska. Raisingvalue deals with value addition to wide range of natural, agricultural, food, chemical and biological products; converting them into products of higher value." name="description">

  <!-- Favicons -->
  <link href="img/raising_value_logo.png" rel="icon">

  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,400i,600,700|Raleway:300,400,400i,500,500i,700,800,900" rel="stylesheet">

  <!-- Bootstrap CSS File -->
  <link href="lib/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="lib/bootstrap/css/custom_bootstrap.css" rel="stylesheet">

  <!-- Libraries CSS Files -->
  <link href="lib/nivo-slider/css/nivo-slider.css" rel="stylesheet">
  <link href="lib/owlcarousel/owl.carousel.css" rel="stylesheet">
  <link href="lib/owlcarousel/owl.transitions.css" rel="stylesheet">
  <link href="lib/font-awesome/css/font-awesome.min.css" rel="stylesheet">
  <link href="lib/animate/animate.min.css" rel="stylesheet">
  <link href="lib/venobox/venobox.css" rel="stylesheet">

  <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/fancybox/2.1.5/jquery.fancybox.min.css" media="screen">

  <!-- Nivo Slider Theme -->
  <link href="css/nivo-slider-theme.css" rel="stylesheet">

  <!-- Main Stylesheet File -->
  <link href="css/style.css" rel="stylesheet">
  <link href="lib/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">

  <!-- Responsive Stylesheet File -->
  <link href="css/responsive.css" rel="stylesheet">

  <!-- =======================================================
    Theme Name: eBusiness
    Theme URL: https://bootstrapmade.com/ebusiness-bootstrap-corporate-template/
    Author: BootstrapMade.com
    License: https://bootstrapmade.com/license/
  ======================================================= -->
</head>

<body data-spy="scroll" data-target="#navbar-example">

  <div id="preloader"></div>

  <?php include("main_header.php"); ?>
  <!-- Start Bottom Header -->
  <div class="header-bg page-area">
    <div class="home-overly"></div>
    <div class="container">
      <div class="row">
        <div class="col-md-12 col-sm-12 col-xs-12">
          <div class="slider-content text-center">
            <div class="header-bottom">
              <div class="layer2 wow zoomIn" data-wow-duration="1s" data-wow-delay=".4s">
                <h1 class="title2">Blog</h1>
              </div>
              <!--div class="layer3 wow zoomInUp" data-wow-duration="2s" data-wow-delay="1s">
                <h2 class="title3">Know more about us</h2>
              </div-->
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="blog-page area-padding" id="blogs_main_container">
    <div class="container">
      <div class="row">
        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
          <div class="page-head-blog">
            <div class="single-blog-page">
              <!-- search option start -->
              <!--form action="#"-->
                <div class="search-option">
                  <input type="text" id="blog_search_data" placeholder="Search...">
                  <a href="#!" class="button" onclick="search_blog()">
                      <i class="fa fa-search"></i>
                  </a>
                </div>
              <!--/form>
              <!-- search option end -->
            </div>
            <?php
              if($get_recent_blog_posts!="1020"){
            ?>
                <div class="single-blog-page">
                  <!-- recent start -->
                  <div class="left-blog">
                    <h4>recent post</h4>
                    <div class="recent-post">
                      <!-- start single post -->
                    <?php
                      foreach ($get_recent_blog_posts as $rb_post) {
                    ?>
                        <div class="recent-single-post">
                          <div class="post-img">
                            <a href="#!" onclick="blog_details_view(<?php echo $rb_post->b_id; ?>)">
                                 <img src="img/blogs/<?php echo $rb_post->b_image; ?>" alt="">
                              </a>
                          </div>
                          <div class="pst-content">
                            <p><a href="#!" onclick="blog_details_view(<?php echo $rb_post->b_id; ?>)"><?php echo $rb_post->b_title; ?></a></p>
                          </div>
                        </div>
                    <?php
                      }
                    ?>
                      <!-- End single post -->
                    </div>
                  </div>
                  <!-- recent end -->
                </div>
            <?php
              }
            ?>
                
            <?php
              if($get_blog_categories!="1020"){
            ?>
                <div class="single-blog-page">
                  <div class="left-blog">
                    <h4>categories</h4>
                    <ul>
                      <?php
                        foreach ($get_blog_categories as $blog_category) {
                      ?>
                          <li class="d-flex justify-content-between">
                            <a href="#!" onclick="blogs_view_by_category(<?php echo $blog_category->b_category_id ?>)"><?php echo $blog_category->b_category_name ?></a>
                            <span class="badge badge-primary p-1 my-auto mx-2">
                              <?php
                                echo $rowcountObj->rowcounter("blog","*","b_status='active' and b_category_id",$blog_category->b_category_id);
                              ?>  
                            </span>
                          </li>

                      <?php
                        }
                      ?>
                    </ul>
                  </div>
                </div>
            <?php
              }
            ?>
                
          </div>
        </div>
        <!-- End left sidebar -->
        <!-- Start single blog -->
        <div class="col-md-8 col-sm-8 col-xs-12 mb-2" id="blogs_head_container">
          <select class="btn btn-dark btn-sm px-1 shadow-sm" id="count_select" onchange="view_blogs_special(null)">
              <option disabled="">Count</option>
              <option value="5" selected>Show count (5)</option>
              <option value="10">Show count (10)</option>
              <option value="20">Show count (20)</option>
              <option value="50">Show count (50)</option>
              <option value="100">Show count (100)</option>
          </select>
        </div>
        <div class="col-md-8 col-sm-8 col-xs-12" id="blogs_container">
          
        </div>
        <div class="col-md-8 col-sm-8 col-xs-12" id="blog_details_container">
          
        </div>
      </div>
    </div>
  </div>
  <!-- End Blog Area -->
  

  <?php include("main_footer.php"); ?>

  <a href="#" class="back-to-top"><i class="fa fa-chevron-up"></i></a>

  <!-- JavaScript Libraries -->
  <script src="lib/jquery/jquery.min.js"></script>
  <script src="lib/bootstrap/js/bootstrap.min.js"></script>
  <script src="lib/owlcarousel/owl.carousel.min.js"></script>
  <script src="lib/venobox/venobox.min.js"></script>
  <script src="lib/knob/jquery.knob.js"></script>
  <script src="lib/wow/wow.min.js"></script>
  <script src="lib/parallax/parallax.js"></script>
  <script src="lib/easing/easing.min.js"></script>
  <script src="lib/nivo-slider/js/jquery.nivo.slider.js" type="text/javascript"></script>
  <script src="lib/appear/jquery.appear.js"></script>
  <script src="lib/isotope/isotope.pkgd.min.js"></script>
  

  <!-- Contact Form JavaScript File -->
  <script src="contactform/contactform.js"></script>
  <script src="lib/datatables/jquery.dataTables.min.js"></script>
  <script src="lib/datatables/dataTables.bootstrap4.min.js"></script>

  <script src="https://cdn.jsdelivr.net/npm/gasparesganga-jquery-loading-overlay@2.1.7/dist/loadingoverlay.min.js"></script>
  <script src="//cdnjs.cloudflare.com/ajax/libs/fancybox/2.1.5/jquery.fancybox.min.js?<?php echo date("Y-m-d").time() ?>"></script>

  <script src="js/main.js"></script>
  <script src="js/universal.js?<?php echo date("Y-m-d").time() ?>"></script> 
  <script src="js/js.js?<?php echo date("Y-m-d").time() ?>"></script> 
  <script type="text/javascript">
    var read_more_var_=<?php if(isset($_GET['read_more'])){ 
        echo $_GET['read_more'];
      }else{ 
        echo "undefined";
      }
    ?>;
    $(document).ready(function () {
      blogs_view()
      window.read_more_var = read_more_var_

      if(read_more_var!=null && read_more_var!="undefined"){
        blog_details_view(read_more_var)
      }
    })
  </script>
</body>

</html>
