<?php
	require_once("../../session_check.php");
    require_once("../../../classes/main_classes.php");

    //OBJECTS
    $retrieveObj=new RETRIEVE();
?>


<p class="text-center lead font-weight-bold"> Add Vehicle</p>
<div id="add_vehicle_item_container" class="bg-white rounded p-3 shadow-sm">
	<p class="text-center lead font-weight-bold"> <small class="text-muted">Basic information</small></p>
	<div id="response">
		<hr class="mx-auto mb-4" style="max-width: 80%">
	</div>

	<form id="add_vehicle_basic_info_form">
		<div class="row my-2">
			<div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-3">
				<label for="vehicle_name">Vehicle name</label>
			</div>
			<div class="col-12 col-sm-12 col-md-6 col-lg-9 col-xl-9">
				<input class="form-control" type="text" name="vehicle_name" id="vehicle_name">
			</div>
		</div>
		<div class="row my-2">
			
			<div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-3">
				<label for="vehicle_type">Body type</label>
			</div>
			<div class="col-12 col-sm-12 col-md-6 col-lg-9 col-xl-9">
				<?php
					//get types
					$get_types=$retrieveObj->retriever("vehicle_type","*","fetchAll");

					if($get_types!="1020"){

				?>
				<select class="form-control" name="vehicle_type">
				<?php
					foreach ($get_types as $type) {
			?>
						<option value='<?php echo $type->v_type_id ?>'><?php echo $type->v_type; ?></option>
			<?php
					}
				?>
				</select>
			<?php 
				}else{
					echo "<p class='alert alert-warning'>Please add vehicle body types on Body types menu to continue</p>";
				} 
			?>
			</div>
		</div>
		<div class="row my-2">
			
			<div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-3">
				<label for="vehicle_type">Make</label>
			</div>
			<div class="col-12 col-sm-12 col-md-6 col-lg-9 col-xl-9">
				<?php
					//get types
					$get_makes=$retrieveObj->retriever("vehicle_make","*","fetchAll");

					if($get_makes!="1020"){

				?>
				<select class="form-control" name="vehicle_make">
				<?php
					foreach ($get_makes as $make) {
			?>
						<option value='<?php echo $make->v_make_id ?>'><?php echo $make->v_make; ?></option>
			<?php
					}
				?>
				</select>
			<?php 
				}else{
					echo "<p class='alert alert-warning'>Please add vehicle Make on Makes menu to continue</p>";
				} 
			?>
			</div>
		</div>

		<div class="row my-2">
			<div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-3">
				<label for="vehicle_model">Model</label>
			</div>
			<div class="col-12 col-sm-12 col-md-6 col-lg-9 col-xl-9">
				<input class="form-control" type="text" name="vehicle_model" id="vehicle_model">
			</div>
		</div>
		<div class="row my-2">
			<div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-3">
				<label for="vehicle_year">Year</label>
			</div>
			<div class="col-12 col-sm-12 col-md-6 col-lg-9 col-xl-9">
				<input class="form-control" type="text" name="vehicle_year" id="vehicle_year" >
			</div>
		</div>
		
		
		<div class="row my-3 rounded">
			<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12">
				<div class="p-2 shadow-sm">
					<label for="vehicle_description">Description</label>
					<textarea class="form-control" name="vehicle_description" id="vehicle_description" rows="3"></textarea>
				</div>
			</div>
		</div>
		<div id="add_vehicle_basic_info_response">
			
		</div>
		<div class="py-3 text-right">
			<input type="hidden" name="add_vehicle_basic_info_note">
			<button class="btn bg_primary_color text-light ml-auto" type="submit" onclick="add_vehicle_basic_info()">Next <span class="fas fa-arrow-right"></span></button>
		</div>
	</form>
</div>

<script type="text/javascript">
	$(document).ready(function() {
		var editor = new Simditor({
		    textarea: $('#vehicle_description')
		    //optional options
		  });
		
	    $("#vehicle_year").attr({
	       "max" : new Date().getFullYear(),        // substitute your own
	       "min" : 1990          // values (or variables) here
	    });
	});
</script>
	