<?php
	require_once("../../session_check.php");
    require_once("../../../classes/main_classes.php");

    $retrieveObj=new RETRIEVE();

	//get last inserted item
	$get_v=$retrieveObj->retriever("vehicle join vehicle_type ON vehicle_type.v_type_id=vehicle.v_type_id","*","vehicle.added_by",$user_id,"vehicle.v_id","DESC","fetch");
?>

<p class="text-center lead font-weight-bold"> <small class="text-muted">Select main image for <strong><?php echo $get_v->v_type; ?></strong> </small></p>
<div id="response">
	<hr class="bg-light mx-auto mb-4" style="max-width: 80%">
</div>


<div class="row my-1">
	<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12">
		<div class="input-group bg-light">
			<label for="upload_image" class="input-group-append pt-2 pb-0 px-2">Main image &nbsp;</label>
			<input class="form-control" type="file" name="upload_image" id="upload_image">
		</div>	
	</div>
	<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12" id="uploadimageContainer" style="display: none;">
		<div class="row">
            <div class="col-md-8 text-center">
              <div id="image_demo" style="width:350px; margin-top:30px"></div>
            </div>
            <div class="col-md-4" style="padding-top:30px;">
              <p class="text-info">If you have supporting images click next else click Finish</p>
              
              <button class="btn btn-block btn-primary crop_image my-1">Next</button>
              <br>
              <button class="btn btn-block btn-danger crop_image my-1">Finish</button>
          </div>
        </div>
	</div>
</div>

<script>  
	
$(document).ready(function(){

  
  var upload_btn_action=$(this).text();
  var image_crop = $('#image_demo').croppie({
    enableExif: true,
    viewport: {
      width:200,
      height:119,
      type:'square' //circle
    },
    boundary:{
      width:300,
      height:300
    }
  });
  
  $('#upload_image').on('change', function(){
    var reader = new FileReader();
    reader.onload = function (event) {
      image_crop.croppie('bind', {
        url: event.target.result
      }).then(function(){
        console.log('jQuery bind complete');
      });
    }
    reader.readAsDataURL(this.files[0]);
    $('#uploadimageContainer').show();
  });

  $('.crop_image').click(function(event){
    $.LoadingOverlay("show");
  	upload_btn_action=$(this).text();
    image_crop.croppie('result', {
      type: 'canvas',
      size: "original", 
      format: "png",
      quality: 1
    }).then(function(response){
      $.ajax({
        url:"includes_/vehicle/upload_vehicle_main_image.php",
        type: "POST",
        data:{"image": response},
        
        cache: false,
           
        success:function(data)
        { 
          //$('#uploadimageContainer').modal('hide');
          $.LoadingOverlay("hide", true); 
          
          if(data==1){
          	if(upload_btn_action=="Next"){
          		//Uploaded and next
	            $("#main_section_container").load("includes_/vehicle/add_vehicle_other_images.php");
          	}else if(upload_btn_action=="Finish"){
          		//Uploaded and finish
                $("#main_section_container").html("<p class='alert alert-success'>Operation successful. Redirecting...</p>");
			         setTimeout(function(){ 
                  $("#main_section_container").load("includes_/vehicle/add_vehicle_info.php");
                }, 2000);
          	}
          }
          	
        }
      });
    })
  });

});  
</script>