<?php
	require_once("../../../classes/main_classes.php");

	//OBJECTS
	$retrieveObj=new RETRIEVE();

	$get_sold=$retrieveObj->retriever("vehicle 
      JOIN vehicle_type ON vehicle_type.v_type_id=vehicle.v_type_id 
      JOIN vehicle_make ON vehicle_make.v_make_id=vehicle.v_make_id 
      JOIN vehicle_images ON vehicle_images.v_id=vehicle.v_id 
      WHERE vehicle_images.image_type='primary_image' and vehicle.v_status='sold' GROUP BY vehicle.v_id ORDER BY vehicle.v_id DESC","DISTINCT *","fetchAll");

?>

<p class="text_primary_color font-weight-bold mb-1 d-flex justify-content-between">
	<span>Sold vehicles</span>
	<span>
		<a data-toggle="modal" data-target="#generateReportModal" class="nav-link fas fa-1x p-2 mb-2" href="#"><span class="text-dark fas fa-file-export"> Export</span></a>
	</span>
</p>
<div id="remove_vehicle_property_response"></div>
<div class="bg-white rounded p-3 shadow-sm">


	<?php
		$for_pdf='
			<div class="text-center mt-3">
				<img id="main_logo_img" src="../assets/img/sgw_logo.png" style="width: 172px;">
			</div>
			<div class="text-center mt-3 h3">Sold vehicles(VEHICLE SALES)</div>
			<div class="text-center mb-3 mt-2">'.date("d-m-Y").'</div>
			<table class="table" >
			<thead>
	   			<tr>
	   				<td>Image</td>
	   				<td>Name</td>
	   				<td>Body type</td>
	   				<td>Make</td>
	   				<td>Model</td>
	   				
	   				<td>Date added</td>
	   				
	   			</tr>
	   		</thead>
	   		<tbody>

		';
	?>
   	<table class="table" id="sold_properties_table">
   		
   		<thead>
   			<tr>
   				<td>Image</td>
   				<td>Name</td>
   				<td>Body type</td>
   				<td>Make</td>
   				<td>Model</td>
   				
   				<td>Date added</td>
   				<td></td>
   			</tr>
   		</thead>
   		<tbody>
   			<?php
				
                    if($get_sold!="1020"){
                    	$element_id="element_id";
                        foreach ($get_sold as $sold) {
                        	$element_id=$element_id."Ot";
			?>	
					<tr id="<?php echo $element_id ?>">	    		
						<td class="">
							<?php
								echo $image='<img class="m-1" style="max-height:75px;" src="../img/vehicles/'.$sold->image.'?timestamp'.time().'"/>';
							?>
						</td>
						<td>
							<?php 
								echo $v_name=$sold->v_name;
							?>
						</td>
						<td>
							<?php 
								echo $v_type=$sold->v_type;
							?>
						</td>
						<td>
							<?php 
								echo $v_make=$sold->v_make;
							?>
						</td>
						<td>
							<?php 
								echo $v_model=$sold->v_model;
							?>
						</td>
						
						<td>
							<?php echo $v_date_added=date("d-m-Y H:i:s", strtotime($sold->v_date_added)); ?>
						</td>
						
						<td id="<?php echo $element_id.'Dbtn' ?>">
							<?php
								$for_pdf_details_var='
									<div class="text-center mt-3">
										<img id="main_logo_img" src="../assets/img/sgw_logo.png" style="width: 172px;">
									</div>
									<div class="text-center mt-3 h3">Sold vehicle</div>
									<div class="text-center mb-3 mt-2">'.date("d-m-Y").'</div>

									<div class="container">
										<div style="width:100%" style="p-2">
											<img class="" style="height:300px;" src="../img/vehicles/'.$sold->image.'?timestamp'.time().'"/>
										</div>
										<div style="width:100%" style="p-2">
											<table class="table table-borderless">
												<tr>
													<td><strong>Vehicle name</strong></td>
													<td>'.$v_name.'</td>
												</tr>
												<tr>
													<td><strong>Vehicle Type</strong></td>
													<td>'.$v_type.'</td>
												</tr>
												<tr>
													<td><strong>Vehicle Make</strong></td>
													<td>'.$v_make.'</td>
												</tr>
												<tr>
													<td><strong>Vehicle Model</strong></td>
													<td>'.$v_model.'</td>
												</tr>
												
												<tr>
													<td><strong>Date Uploaded</strong></td>
													<td>'.$v_date_added.'</td>
												</tr>
												
												
											</table>
										</div>
										<div class="col-md-12">
											<p><strong>Desctiption</strong></p>
											<p>'.$sold->v_description.'</p>
										</div>
									</div>
								';

								$strI = serialize($for_pdf_details_var);
								$pdfDataDetails = urlencode($strI);

							?>
							<button class="btn text-primary" data-toggle="modal" data-target="#universalModalXl" onclick="view_sold_vehicle_details(<?php echo $sold->v_id; ?>)"><span class="fas fa-info"></span> </button>
							<button style="display: inline;" class="btn text-primary" onclick="edit_vehicle(<?php echo $sold->v_id ?>)"><span class="fas fa-edit"></span> </button>
							<form action="../file_generators/pdf_generator.php" method="POST" target="_blank" style="display: inline;">
				                <input type="hidden" name="exportPdf" value="<?php echo $pdfDataDetails ?>">
								<input type="hidden" name="downloadBtn">
				                <button type="submit" class="btn"><span class="fas fa-file-pdf text-danger"></span> </button>
				            </form>
							<form id="<?php echo $element_id.'form' ?>" class="mb-0" style="display: inline;">
				                <input type="hidden" name="remove_vehicle_property_note" value="<?php echo $sold->v_id ?>">
				                <button  onclick="remove_realestate_property('<?php echo $element_id.'form' ?>','<?php echo $element_id ?>','remove_vehicle_property_response')" type="submit" title="Remove" class="btn"><span class="fas fa-trash text-warning"> </span></button>
				            </form>
						</td>
					</tr>
			<?php
				$for_pdf=$for_pdf."
							<tr>
								<td>".$image."</td>
								<td>".$v_name."</td>
								<td>".$v_type."</td>
								<td>".$v_make."</td>
								<td>".$v_model."</td>
								
								
								<td>".$v_date_added."</td>

							</tr>
						";

					}
					$for_pdf=$for_pdf."</tbody></table>";
				}
			?>
   		</tbody>
   	</table>
   	<?php
		
		//generate data sending variables
		$str = serialize($for_pdf);
		$pdfData = urlencode($str);
	?>
</div>
<!--GENERATE REPORTS MODAL-->
<div class='modal fade transparent mt-5' id='generateReportModal' data-keyboard="false" data-backdrop="static" tabindex="-1">
    <div class='modal-dialog shadow-lg rounded' style="max-height: 400px;" >
		<div class='modal-content' >
			<div  class='text-dark modal-header'>
				<button  class='btn btn-danger btn-sm' data-dismiss='modal'>
					&times;
				</button>
			</div>
			<div class='modal-body text-center bg-light'>
				<div class="text-center row">
					<div style="width: 100%" class="text-center">
						<form action="../file_generators/pdf_generator.php" method="POST" target="_blank">
							<input type="hidden" name="exportPdf" value="<?php echo $pdfData ?>">
							<input type="hidden" name="downloadBtn">
							<button class="btn" type="submit" name=""><span class="fas fa-file-pdf fa-8x text-danger"></span></button><br />
							<label class="text-dark bold lead">Pdf</label>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<script>  
 $(document).ready(function(){  
 	
     var table = $('#sold_properties_table').DataTable({
      columnDefs: [
        {bSortable: false, targets: [8]} 
      ]
    });
    $("thead").addClass("font-weight-bold"); 
 });  
 </script> 

