<?php
  require_once("session_check.php");
  $current_location="customer_dashboard";

  if($user_id==null){
    header("location:index.php");
  }
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">
    <meta name="description" content="Track and pay your rent, Pay for items, etc.">
    <meta name="keywords" content="SGW, SGW Malawi, Real Estate Agent, Vehicle Dealer, Auctions">

    <title>SGW Customer Dashboard</title>
    <link rel="stylesheet" href="assets/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="customer_assets/css/Sidebar-Menu-1.css">
    <link rel="stylesheet" href="customer_assets/css/Sidebar-Menu.css">
    <link href="assets/croppie/croppie.css" rel="stylesheet">
    <link rel="stylesheet" href="customer_assets/css/styles.css">
    <link rel="stylesheet" href="customer_assets/css/dashboard_cards.css">
    <link rel="stylesheet" href="css/universal.css">

    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=ABeeZee">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:300,400,700">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto+Slab:300,400">
    <link rel="stylesheet" href="assets/fonts/font-awesome.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.2/css/all.min.css">
    <link href="assets/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
</head>

<body class="bg-light">
    <?php include("main_nav.php"); ?>
    <div id="wrapper">
        <div id="sidebar-wrapper" class="bg-light">
            <ul class="sidebar-nav">
                <!--li class="text-center mb-3"> 
                    
                </li-->
                <li class="pr-2 mt-4 pt-2"> 
                    <a href="#" class="text-dark" onclick="view_dashboard()"><span class="fas fa-tachometer-alt"></span> Dashboard </a>
                </li>
                
                <li class="pr-2"> 
                    <a href="#" data-toggle="collapse" data-target="#estate_agent_side" aria-expanded="false" aria-controls="estate_agent_side" class="text-dark ">
                         <p class="mb-0 d-flex justify-content-between">
                            <span><span class="fas fa-building"></span>&nbsp; Real Estate </span>
                            <span>
                                <i class="fa fa-chevron-circle-right fa-sm"></i>
                                <i class="fa fa-chevron-circle-down fa-sm"></i>
                            </span>
                        </p>
                    </a>
                    <div class="collapse" id="estate_agent_side">
                        <ul class="list-unstyled ml-5">
                            <li class=""><a href="#" class="text_primary_color text_primary_color_hover"onclick="view_relaestate_books()">Bookings</a></li>
                            <!--li class=""><a href="#" class="text_primary_color text_primary_color_hover"onclick="view_relaestate_reserves()">Reserves</a></li-->
                            <li class=""><a href="#" class="text_primary_color text_primary_color_hover"onclick="view_relaestate_rents()">Rents</a></li>
                            <!--li class=""><a href="#" class="text_primary_color text_primary_color_hover"onclick="view_relaestate_purchases()">Purchases</a></li-->
                        </ul>
                    </div>
                </li>

                <li class="pr-2"> 
                    <a href="#" data-toggle="collapse" data-target="#auctioneer_side" aria-expanded="false" aria-controls="auctioneer_side"  class="text-dark ">
                        <p class="mb-0 d-flex justify-content-between">
                            <span><span class="fas fa-hammer"></span>  Auctions </span>
                            <span>
                                <i class="fa fa-chevron-circle-right fa-sm"></i>
                                <i class="fa fa-chevron-circle-down fa-sm"></i>
                            </span>
                        </p> 
                    </a>
                    <div class="collapse" id="auctioneer_side">
                        <ul class="list-unstyled ml-5">
                            <li class=""><a href="#" class="text_primary_color text_primary_color_hover" onclick="view_auction_bids()">Bids</a></li>
                            <!--li class=""><a href="#" class="text_primary_color text_primary_color_hover">Sold</a></li-->
                            <li class=""><a href="#" class="text_primary_color text_primary_color_hover" onclick="view_auction_purchases()">Purchases</a></li>
                        </ul>
                    </div>
                </li>
            </ul>
        </div>
        <div class="page-content-wrapper bg-light">
            <div class="container-fluid pt-2 bg-light">
                <div class="row">
                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 d-flex justify-content-between">
                        <!--a class="btn btn-link text_primary_color" role="button" id="menu-toggle" href="#menu-toggle"><i class="fa fa-bars"></i></a-->
                        <a class="btn btn-link text-dark py-0 shadow" role="button" id="menu-toggle" href="#menu-toggle"><i class="fa fa-sm" id="sidebar_toggle_icon"></i></a>
                    </div>
                </div>
            </div>
            <div class="container-fluid mt-1" id="customer_main_section">
                
                
            </div>
        </div>
    </div>
    <!-- Modal -->
    <div id="universalModal" class="modal fade" role="dialog">
      <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">&times;</button>
          </div>
          <div class="modal-body" id="universalModalBody">
            
          </div>
        </div>
      </div>
    </div>
    <!-- Modal -->
    <div id="universalModalLg" class="modal fade" role="dialog">
      <div class="modal-dialog modal-lg">
        <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">&times;</button>
          </div>
          <div class="modal-body" id="universalModalLgBody">
            
          </div>
        </div>
      </div>
    </div>
   
    <!-- Modal -->
    <div id="universalModalXl" class="modal fade" role="dialog">
      <div class="modal-dialog modal-xl">
        <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">&times;</button>
          </div>
          <div class="modal-body" id="universalModalXlBody">
            
          </div>
        </div>
      </div>
    </div>
    <script src="assets/js/jquery.min.js"></script>
    <script src="assets/bootstrap/js/bootstrap.min.js"></script>
    <script src="assets/datatables/jquery.dataTables.min.js"></script>
    <script src="assets/datatables/dataTables.bootstrap4.min.js"></script>
    <script src="customer_assets/js/Sidebar-Menu.js"></script>
    <script type="text/javascript" src="assets/croppie/croppie.js"></script>
    <script src="js/universal.js?<?php echo date("Y-m-d").time() ?>"></script>
    <script src="js/customer.js?<?php echo date("Y-m-d").time() ?>"></script>
    <script type="text/javascript">
        function load_dashboard(){
            loading("customer_main_section");
            $("#customer_main_section").load("includes_/customer/dashboard.php");
        }
        $(document).ready(function () {
            //load dastboard
            load_dashboard()

            $("#dashboard_nav_link").addClass("bg-white");
            $("#dashboard_nav_link").addClass("rounded");

            var wrapper_pad = $('#wrapper');
            var wrapper_padding = wrapper_pad.css('padding-left');
            if(wrapper_padding!="250px"){
                
                $("#sidebar_toggle_icon").addClass("fa-arrow-right");
            }else{
                $("#sidebar_toggle_icon").addClass("fa-arrow-left");
                
            }
        });
    </script>
</body>

</html>