<?php
	require_once("../../session_check.php");
    require_once("../../classes/main_classes.php");

    //OBJECTS 
    $retrieveObj=new RETRIEVE();
    $updateObj=new UPDATE();
    $deleteObj=new DELETE();
    $sendemailObj=new SEND_EMAIL();
    $root_dir_getObj=new ROOTDIRGET();

    $current_date_time=date("Y-m-d H:i:s");
    $mailer_r_path="../../";

    //get root dir
    $root_dir=$root_dir_getObj->root_dir_getter();

    $get_administrators=$retrieveObj->retriever("users 
        JOIN user_roles ON user_roles.user_id=users.user_id
        JOIN user_role ON user_roles.role_id=user_role.role_id","*","user_role.user_role","admin","fetchAll");

    //notification about rent
        //get tenants that need to be notified
        $get_tenants=$retrieveObj->retriever("realestate 
            JOIN realestate_type ON realestate_type.r_type_id=realestate.r_type_id 
            JOIN realestate_rented ON realestate_rented.r_id=realestate.r_id
            JOIN users ON realestate_rented.user_id=users.user_id WHERE realestate.r_status='rent' GROUP BY realestate.r_id","*","fetchAll");

        if($get_tenants!="1020"){
            foreach ($get_tenants as $tenant) {
                $rent_expirely_date=$tenant->r_rent_expirely_date;
                $rent_expirely_note=$tenant->r_rent_expirely_note;

                $datediff =  strtotime($rent_expirely_date) - strtotime($current_date_time);
                $rent_expirely_days = round($datediff / (60 * 60 * 24));
                $actual_rent_expirely = $datediff / (60 * 60 * 24);

                //mail data
                $subject_="RENT STATUS";
                $body_="Dear ".$tenant->firstname." ".$tenant->lastname."(".$tenant->email."), Please note that your rent subscription will end on $rent_expirely_date, Please renew your rent before this day and time.<p>Regards<br> SGW TEAM</p>";

                if($rent_expirely_days<=10 and $rent_expirely_days>5 and $rent_expirely_note=="not_sent"){ //first note required
                    //send email note
                    $send_email=$sendemailObj->phpmailer_send($mailer_r_path,$subject_,$body_,$tenant->email);
                    //set note
                    if($send_email=="1"){
                        $set_note=$updateObj->updater("realestate_rented","r_rent_expirely_note='first_sent'","r_id='".$tenant->r_id."' and user_id",$tenant->user_id);
                    }
                    $send_email="";
                }else if($rent_expirely_days<=5 and $rent_expirely_days>0 and $rent_expirely_note=="first_sent"){ //second note required
                    //send email note
                    $send_email = $sendemailObj->phpmailer_send($mailer_r_path,$subject_,$body_,$tenant->email);
                    //set note
                    if($send_email=="1"){
                        $set_note=$updateObj->updater("realestate_rented","r_rent_expirely_note='second_sent'","r_id='".$tenant->r_id."' and user_id",$tenant->user_id);
                    }
                    $send_email="";
                    
                }else if($actual_rent_expirely<=0 and $rent_expirely_note=="second_sent"){ //last note required and close
                    //set r_rented_status = inactive
                    $set_rent_status_note=$updateObj->updater("realestate_rented","r_rented_status='inactive'","r_id='".$tenant->r_id."' and user_id",$tenant->user_id);  


                    $send_email_to_admin="";
                    //send email note
                        //sent to tenant
                        $sendemailObj->phpmailer_send($mailer_r_path,$subject_,$body_,$tenant->email);

                        //sent to admin
                        foreach ($get_administrators as $admin) {
                            //send email
                            $admin_subject_2 = "RENT STATUS";
                            $admin_body_2 = 
                            "
                                <p>This email is to notify you that rent subscription for ".$tenant->firstname." ".$tenant->lastname."(".$tenant->email.") <br>
                                <strong>Customer Information</strong><br>
                                Firstname : ".$tenant->firstname."<br>
                                Lastname : ".$tenant->lastname."<br>
                                Email : ".$tenant->email."<br>
                                Phone : ".$tenant->phone."<br>

                                <a href='$root_dir/admin'>Login</a> to your dashboard to see datails</p>
                                
                            ";

                            $send_email_to_admin=$sendemailObj->phpmailer_send($mailer_r_path,$admin_subject_2,$admin_body_2,$admin->email);
                        }
                    if($send_email_to_admin=="1"){
                        //set note
                        $set_note=$updateObj->updater("realestate_rented","r_rent_expirely_note='closing_sent'","r_id='".$tenant->r_id."' and user_id",$tenant->user_id);  
                    }
                    
                }                
            }
        }   

?>