<?php
	$session_path="../../session_check.php";
	$classes="../../classes/main_classes.php";

	require_once($session_path);
	require_once($classes);

	if($user_id==null){
	    echo "<p class='alert alert-warning'>You are not logged in</p>";
	}

	//OBJECTS
	$retrieveObj=new RETRIEVE();

	//get vehicles purchesed by cutomer
	$get_auctions=$retrieveObj->retriever("auction 
      JOIN auction_images ON auction_images.a_id=auction.a_id 
      JOIN auction_sold ON auction_sold.a_id=auction.a_id
      JOIN users ON auction_sold.user_id=users.user_id WHERE auction_sold.user_id='$user_id' GROUP BY auction.a_id","*","fetchAll");

	

?>



<p class="text_primary_color font-weight-bold mb-1">Auction</p>
<div class="bg-white rounded pb-3 shadow-sm">
    <p class="laed px-3 py-2 text-light bg-dark"> Purchases</p>

    <div class="container-fluid">
    	<table class="table table-borderless table-responsive-lg" id="vehicle_purchases_table">
	    	<thead>
	    		<tr>
	    			<th>Image</th>
	    			<th>Property name</th>
	    			<th>Price</th>
	    			<th>Date purchased</th>
	    			
	    			<th></th>
	    		</tr>
	    	</thead>
	    	<tbody>
	    		<?php
	    			if($get_auctions!="1020"){
	    				foreach ($get_auctions as $auction) {
	    		?>
						<tr>	    		
	    					<td class="">
	    						<img style="max-height: 50px;" class="img-fluid" src="img/auctions/<?php echo $auction->image."?timestamp".time() ?>" alt="Image" />
	    					</td>
	    					<td class="py-3"><?php echo $auction->a_name ?></td>
	    					<td class="py-3">MKW <?php echo money_format("%!n", $auction->sold_price)?></td>
	    					<td class="py-3"><?php echo date("d-m-Y H:i:s", strtotime($auction->sold_date)); ?></td>
	    					<td>
	    						<?php
	    							$get_current_bid_max_price=$retrieveObj->retriever("auction_bid JOIN users ON users.user_id=auction_bid.user_id","*","auction_bid.a_id",$auction->a_id,"auction_bid.a_bid_price","DESC","fetch");
                                $bid_max_price="";
                                if($get_current_bid_max_price=="1020"){
                                    $bid_max_price= $closed->a_bid_start_price;
                                }else{
                                    $bid_max_price= $get_current_bid_max_price->a_bid_price;
                                }
                                 $bid_max_price_=$bid_max_price;
 								$expected_commission_percentage=money_format("%!n", (($auction->expected_commission_percentage/100)*$bid_max_price_))."(".$auction->expected_commission_percentage."%)";


 									$get_date_paid=$retrieveObj->retriever("auction_sold","*","a_id='".$auction->a_id."' and user_id",$user_id,"fetch");
	                                $for_pdf_details_var='
	                                    <div class="text-center mt-3">
	                                        <img id="main_logo_img" src="../assets/img/sgw_logo.png" style="width: 172px;">
	                                    </div>
	                                    <div class="text-center mt-3 h3">Purchase from auction bid(AUCTION SALES)</div>
	                                    <div class="text-center mb-3 mt-2">'.date("d-m-Y").'</div>

	                                    <div class="container">
	                                        <div style="width:100%" style="p-2">
	                                            <img class="" style="height:300px;" src="../img/auctions/'.$auction->image.'?timestamp'.time().'"/>
	                                        </div>
	                                        <div style="width:100%" style="p-2">
	                                            <table class="table table-borderless">
	                                                <tr>
	                                                    <td><strong>Name</strong></td> 
	                                                    <td>'.$auction->a_name.'</td>
	                                                </tr>
	                                                
	                                                <tr>
	                                                    <td><strong>Start price</strong></td>
	                                                    <td>NKW'.money_format("%!n", $auction->a_bid_start_price).'</td>
	                                                </tr>
	                                                <tr>
	                                                    <td><strong>Bid won at</strong></td>
	                                                    <td>NKW'.money_format("%!n", $bid_max_price_).'</td>
	                                                </tr>
	                                                
	                                               
	                                                <tr>
	                                                    <td><strong>Bid winner</strong></td>
	                                                    <td>
	                                                        <p><strong>full name : </strong>'.$get_current_bid_max_price->firstname.' '.$get_current_bid_max_price->lastname.'</p>
	                                                        <p><strong>email : </strong>'.$get_current_bid_max_price->email.'</p>
	                                                        <p><strong>phone : </strong>'.$get_current_bid_max_price->phone.'</p>
	                                                    </td>
	                                                </tr>
	                                                <tr>
	                                                    <td><strong>Date paid</strong></td>
	                                                    <td>'.date("d-m-Y", strtotime($get_date_paid->sold_date)).'</td>
	                                                </tr>
	                                            </table>
	                                        </div>
	                                        <div class="col-md-12">
	                                            <p><strong>Desctiption</strong></p>
	                                            <p>'.$auction->a_description.'</p>
	                                        </div>
	                                    </div>
	                                ';

	                                $strI = serialize($for_pdf_details_var);
	                                $pdfDataDetails = urlencode($strI);

	                            ?>
	    						<form action="file_generators/pdf_generator.php" method="POST" target="_blank">
	                                <input type="hidden" name="exportPdf" value="<?php echo $pdfDataDetails ?>">
	                                <input type="hidden" name="downloadBtn">
	                                <button type="submit" class="btn"><span class="fas fa-file-pdf text-danger"></span> </button>
	                            </form>
	    					</td>
	    				</tr>
	    		<?php
	    				}
	    			}
	    		?>
	    	</tbody>
	    </table>
    </div>
	    

</div>	


<script>  
 $(document).ready(function(){  
     var table = $('#vehicle_purchases_table').DataTable({
      /*columnDefs: [
        {bSortable: false, targets: [4]} 
      ]*/
    }); 
 });  
 </script> 