<?php
	$session_path="../../session_check.php";
	$classes="../../classes/main_classes.php";

	require_once($session_path);
	require_once($classes);

	if($user_id==null){
	    echo "<p class='alert alert-warning'>You are not logged in</p>";
	}

	//OBJECTS
	$retrieveObj=new RETRIEVE();

	//get vehicles purchesed by cutomer
	$get_realestates=$retrieveObj->retriever("realestate 
		JOIN realestate_type ON realestate_type.r_type_id=realestate.r_type_id 
      JOIN realestate_images ON realestate_images.r_id=realestate.r_id 
      JOIN realestate_rented ON realestate_rented.r_id=realestate.r_id
      JOIN users ON realestate_rented.user_id=users.user_id WHERE realestate_rented.user_id='$user_id'  and realestate.r_status='rent' GROUP BY realestate.r_id","*","fetchAll");

?>


<p class="text_primary_color font-weight-bold mb-1">Real Estate</p>
<div class="bg-white rounded pb-3 shadow-sm">
    <p class="laed px-3 py-2 text-light bg-dark"> Books</p>

    <div class="container-fluid">
    	<table class="table table-borderless table-responsive-lg" id="vehicle_purchases_table">
	    	<thead>
	    		<tr>
	    			<th>Image</th>
	    			<th>Address</th>
	    			<th>Rent start date</th>
	    			<th>Rent expirely date</th>
	    			<th></th>
	    		</tr>
	    	</thead>
	    	<tbody>
	    		<?php
	    			if($get_realestates!="1020"){
	    				foreach ($get_realestates as $realestate) {
	    		?>
						<tr>	    		
	    					<td class="">
	    						<img style="max-height: 50px;" class="img-fluid" src="img/realestates/<?php echo $realestate->image."?timestamp".time() ?>" alt="Image" />
	    					</td>
	    					<td class="py-3"><?php echo $realestate->r_address ?></td>
	    					<td class="py-3"><?php echo date("d-m-Y H:i:s", strtotime($realestate->r_rented_date));?></td>
	    					<td class="py-3"><?php echo date("d-m-Y H:i:s", strtotime($realestate->r_rent_expirely_date)); ?></td>
	    					<td class="text-center">
	    						<?php
								$for_pdf_details_var='
									<div class="text-center mt-3">
										<img id="main_logo_img" src="../assets/img/sgw_logo.png" style="width: 172px;">
									</div>
									<div class="text-center mt-3 h3">Rented Property(REAL ESTATE)</div>
									<div class="text-center mb-3 mt-2">'.date("d-m-Y").'</div>

									<div class="container">
										<div style="width:100%" style="p-2">
											<img class="" style="height:300px;" src="../img/realestates/'.$realestate->image.'?timestamp'.time().'"/>
										</div>
										<div style="width:100%" style="p-2">
											<table class="table table-borderless">
												<tr>
													<td><strong>Real estate type</strong></td>
													<td>'.$realestate->r_type.'</td>
												</tr>
												<tr>
													<td><strong>Address</strong></td>
													<td>'.$realestate->r_address.'</td>
												</tr>
												<tr>
													<td><strong>Price per month</strong></td>
													<td>MKW'.$realestate->r_price.'</td>
												</tr>
												
												<tr>
													<td><strong>Rent start date</strong></td>
													<td>'.$realestate->r_rented_date.'</td>
												</tr>
												<tr>
													<td><strong>Rent end date</strong></td>
													<td>'.$realestate->r_rent_expirely_date.'</td>
												</tr>

												
												<tr>
													<td><strong>Tenant Info</strong></td>
													<td>
														<p><strong>full name : </strong>'.$realestate->firstname.' '.$realestate->lastname.'</p>
														<p><strong>email : </strong>'.$realestate->email.'</p>
														<p><strong>phone : </strong>'.$realestate->phone.'</p>
													</td>
												</tr>
											</table>
										</div>
										<div class="col-md-12">
											<p><strong>Desctiption</strong></p>
											<p>'.$realestate->r_description.'</p>
										</div>
									</div>
								';

								$strI = serialize($for_pdf_details_var);
								$pdfDataDetails = urlencode($strI);

							?>
	    						<button href="#!" class="btn bg_primary_color text-light" onclick="payment('<?php echo $realestate->r_id ?>','realestate','<?php echo $realestate->r_price ?>','rent')" data-toggle="modal" data-target="#universalModal"><span class="fa fa-credit-card bg-dark"></span> Pay</button> 
	    						<form action="file_generators/pdf_generator.php" style="display: inline;" method="POST" target="_blank">
					                <input type="hidden" name="exportPdf" value="<?php echo $pdfDataDetails ?>">
									<input type="hidden" name="downloadBtn">
					                <button type="submit" class="btn"><span class="fas fa-file-pdf text-danger"></span> </button>
					            </form>
	    					</td>
	    					
	    				</tr>
	    		<?php
	    				}
	    			}
	    		?>
	    	</tbody>
	    </table>
    </div>
	    

</div>	


<script>  
 $(document).ready(function(){  
     var table = $('#vehicle_purchases_table').DataTable({
      columnDefs: [
        {bSortable: false, targets: [4]} 
      ]
    }); 
 });  
 </script> 