<?php
  require_once("session_check.php");
  require_once("classes/main_classes.php");

  $retrieveObj=new RETRIEVE();
	//generate token
    $token_random = rand(1000, 10000);
    $business_name = "SGW";
    $date = date("Y-m-d");
    $token_id = $business_name.$token_random.$date;

    $amount_to_be_paid=$_SESSION["amount_to_be_paid"];
    $property_type=$_SESSION["property_type"];
    $property_id=$_SESSION["property_id"];

    //get property image
    $get_property_info="";
    $property_image="";
    if($property_type=="vehicle"){
      $get_property_info=$retrieveObj->retriever("vehicle JOIN vehicle_images ON vehicle_images.v_id=vehicle.v_id","*","vehicle.v_status='available' and vehicle_images.image_type='primary_image' and vehicle_images.v_id",$property_id,"fetch");
      $property_image="img/vehicles/".$get_property_info->image."?timestamp".time();
    }else if($property_type=="realestate"){
      $get_property_info=$retrieveObj->retriever("realestate  
        JOIN realestate_images ON realestate_images.r_id=realestate.r_id","*","realestate.r_id='$property_id' and realestate_images.image_type='primary_image' and realestate_images.r_id",$property_id,"fetch");
      $property_image="img/realestates/".$get_property_info->image."?timestamp".time();
    }else if($property_type=="auction"){
      $get_property_info=$retrieveObj->retriever("auction 
      JOIN auction_images ON auction_images.a_id=auction.a_id","*","auction.a_id",$property_id,"fetch");
      $property_image="img/auctions/".$get_property_info->image."?timestamp".time();
    }

    
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=yes">
    <title>SGW</title>
    <link rel="stylesheet" href="assets/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="css/scrolling-nav.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=ABeeZee">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:300,400,700">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto+Slab:300,400">
    <!--link rel="stylesheet" href="assets/fonts/font-awesome.min.css"-->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.2/css/all.min.css">
    <link rel="stylesheet" href="assets/fonts/ionicons.min.css">
    <link rel="stylesheet" href="assets/css/--mp--Animated-Service-Box-1.css">
    <link rel="stylesheet" href="assets/css/--mp--Animated-Service-Box.css">
    <link rel="stylesheet" href="assets/css/DA_About.css">
    <link rel="stylesheet" href="assets/css/Dark-Footer-1.css">
    <link rel="stylesheet" href="assets/css/Dark-Footer-2.css">
    <link rel="stylesheet" href="assets/css/Dark-Footer-3.css">
    <link rel="stylesheet" href="assets/css/Dark-Footer-4.css">
    <link rel="stylesheet" href="assets/css/Dark-Footer-5.css">
    <link rel="stylesheet" href="assets/css/Dark-Footer.css">
    <link rel="stylesheet" href="assets/css/Features-Clean.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/aos/2.1.1/aos.css">
    <link rel="stylesheet" href="assets/css/Login-Animate.css">
    <link rel="stylesheet" href="assets/css/Login-screen.css">
    <link rel="stylesheet" href="assets/css/sticky-dark-top-nav-with-dropdown.css">
    <link rel="stylesheet" href="assets/css/styles.css">
    
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/services.css">
    <link rel="stylesheet" href="css/universal.css">
    <link href="assets/croppie/croppie.css" rel="stylesheet">
</head>

<body class="container bg-light" style="font-family: Roboto, sans-serif;">
  <div class="row mx-5 mt-2 p-3 bg-light shadow rounded mx-auto" style="max-width: 400px;">
    <div class="col-12 col-sm-12 col-md-12 col-lg-12">
      <p class="text-center">
        <img class="mx-auto" id="main_logo_img" src="assets/img/sgw_logo.png" style="width: 172px;">
      </p>
      <p class="text-center lead text-dark">Payment Form</p>
    </div>
    <div class="col-12 col-sm-12 col-md-12 col-lg-12">
        <?php
            if(!empty($property_image)){
        ?>
            <img class="img-fluid rounded img-thumbnail" src="<?php echo $property_image ?>" alt="Image" />
        <?php
            }else{
                echo "<p class='text-center'><span class='fas fa-car fa-5x'></span></p>";
            }
        ?>
        
        <?php
          if(isset($_SESSION["activity"]) and $_SESSION["activity"]=="rent"){
        ?>
          <div class="my-1 row f_d_info">
            <div class="col-12 col-sm-5 col-md-4 col-lg-4">
              <label class="mt-2">Rent period</label>
            </div>
            <div class="col-12 col-sm-6 col-md-8 col-lg-8">
              <select class="form-control" id="rent_period" onchange="set_rent_period()">
                <option value="1">30 days</option>
                <option value="2">60 days</option>
                <option value="3">90 days</option>
              </select>
            </div>
          </div>
          <div class="my-1 row f_d_info">
            <div class="col-12 col-sm-12 col-md-4 col-lg-4">
              <label class="mt-2">Price</label>
            </div>
            <div class="col-12 col-sm-12 col-md-8 col-lg-8 mt-2">
              MKW <span class="" id="rent_price_container"></span>
            </div>
          </div>
          
        <?php
          }
        ?>

        <?php
          if(isset($_SESSION["activity"]) and $_SESSION["activity"]=="book"){
        ?>
          <div class="my-1 row f_d_info">
            <div class="col-12 col-sm-6 col-md-6 col-lg-6">
              <label class="mt-2">Number of days</label>
            </div>
            <div class="col-12 col-sm-6 col-md-6 col-lg-6">
              <input class="form-control" id="book_period_" value="1" min="1"  oninput="set_book_period()" />
            </div>
          </div>
          <div class="my-1 row f_d_info">
            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
              <label class="mt-2">Price</label>
            </div>
            <div class="col-12 col-sm-12 col-md-6 col-lg-6 mt-2">
              MKW <span class="" id="book_price_container"></span>
            </div>
          </div>
          
        <?php
          }
        ?>
    </div>

    <div class="px-3 py-3 col-12 col-sm-12 col-md-12 col-lg-12">
      <form id="transact" method="" action="">
        <input type="hidden" name="business_number" id="business_number" placeholder="" value="0990270931" required>
        <input type="hidden" name="token_id" id="token_id" placeholder="" value="" required="">
        <input type="hidden" name="amount" id="amount" placeholder="" value="<?php echo $amount_to_be_paid ?>" required="">
        <button type="submit" onClick="tester()" name="submit" class="btn btn-lg text-light rounded btn-block font-weight-bold" style="background-color: #032147">
          <!--span class="fas fa-money-check"></span--> 
          <img style="height: 50px;" src="img/logos/netsoftmoney_logo.png" border="0" alt="PayPal Logo">
        Checkout</button>
      </form> 
       <form id="complete_transaction" method="post" action="includes_/payments/netsoftmoney/netsoftmoney_handler.php" style="display:none;">
        <input type="hidden" name="business_number" id="business_number" placeholder="" value="+265999592820" required="">

        <input type="hidden" name="token" id="token" placeholder="" value="" required="">
        <input type="hidden" name="rent_period" id="rent_period" value="1">
        <input type="hidden" name="book_period" id="book_period" value="1">

        <?php
              if(isset($_SESSION["activity"]) and $_SESSION["activity"]=="rent"){
                //get rent start date
                $get_rent_start_date=$retrieveObj->retriever("realestate_rented","*","r_id",$property_id,"fetch");
            ?>
              <div class="my-1 input-group">
                <label class="input-group-append mt-1">Rent start date &nbsp;</label>
                <input class="form-control" type="date" name="rent_start_date" id="rent_start_date" required onchange="set_rent_paypal_button()" disabled value="<?php echo date('Y-m-d', strtotime($get_rent_start_date->r_rent_expirely_date)) ?>">
              </div>
            <?php
              }
            ?>

        <?php
          if(isset($_SESSION["activity"]) and $_SESSION["activity"]=="book"){
            //get rent start date
                $get_book_start_date=$retrieveObj->retriever("realestate_booked","*","r_id",$property_id,"fetch");
        ?>
          <div class="my-1 input-group">
            <label class="input-group-append mt-1">Book from &nbsp;</label>
            <input class="form-control" type="date" name="book_start_date" id="book_start_date" required onchange="set_book_paypal_button()" disabled value="<?php echo date('Y-m-d', strtotime($get_book_start_date->r_book_date_to)) ?>">
          </div>
        <?php
          }
        ?>
        
        <button type="submit" onClick="tester()" name="submit" class="primary btn btn-lg text-light rounded btn-block font-weight-bold netsoft_button" style="background-color: #032147">
          <!--span class="fas fa-money-check"></span--> 
          <img style="height: 50px;" src="img/logos/netsoftmoney_logo.png" border="0" alt="PayPal Logo">
        Complete Transaction</button>
      </form>
    </div>
      
  </div>

</body>
<script src="assets/js/jquery.min.js"></script>
<script src="assets/bootstrap/js/bootstrap.min.js"></script>
<script src="assets/jquery-easing/jquery.easing.min.js"></script>
<script type="text/javascript">
   function tester(){
      setTimeout(function(){ 
          $("#transact").hide();
          $("#complete_transaction").show();
          $(".f_d_info").hide();
      }, 5000);
  }; 

  function set_rent_period(){
    var r_days=$("#rent_period").val();
    
    $("#amount").val( r_days*"<?php echo $amount_to_be_paid ?>")
    $("#rent_price_container").html(r_days*"<?php echo $amount_to_be_paid?>");
  }

  function set_book_period(){
    var r_days=$("#book_period_").val();
    $("#book_period").val(r_days);
    $("#amount").val( r_days*"<?php echo $amount_to_be_paid ?>")
    $("#book_price_container").html(r_days*"<?php echo $amount_to_be_paid?>");
  }

  function set_book_paypal_button(){
    if(document.getElementById("book_start_date").value!=""){
      $(".netsoft_button").removeClass("disabledElement");
    }else{
      $(".netsoft_button").addClass("disabledElement");
    }
    
  }

  function set_rent_paypal_button(){
    if(document.getElementById("rent_start_date").value!=""){
      $(".netsoft_button").removeClass("disabledElement");
    }else{
      $(".netsoft_button").addClass("disabledElement");
    }
    
  }


  var activity='<?php echo $_SESSION["activity"] ?>';
  $(document).ready(function(){
    if(activity=="rent"){
      $("#amount").val("<?php echo 1*$amount_to_be_paid ?>")
      $("#rent_price_container").html("<?php echo money_format("%!n", 1*$amount_to_be_paid)?>");
      //$(".netsoft_button").addClass("disabledElement");
    }

    if(activity=="book"){
      $("#amount").val("<?php echo 1*$amount_to_be_paid ?>")
      $("#book_price_container").html("<?php echo money_format("%!n", 1*$amount_to_be_paid)?>");
      //$(".netsoft_button").addClass("disabledElement");
    }

    //onchange
  })
</script>
<script type="text/javascript" src="https://www.netsoftmoney.com/api/api2.js"></script>
<!--script type="text/javascript" src="https://www.netsoftmoney.com/api/api.js"></script-->