<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">
	
	<!-- Favicon -->
	<link href="images/fav.png" rel="shortcut icon" type="image/x-icon"/>

    <title>Natto | Recipes </title>

    <!-- Bootstrap core CSS-->
    <link href="vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
	<link href="css/style.css" rel="stylesheet">
	<link href="css/responsive.css" rel="stylesheet">
	<link href="css/mega.menu.css" rel="stylesheet">
	<link href="css/recipeowlslider.css" rel="stylesheet">
    
	<!-- Owl Carousel for this template-->
	<link rel="stylesheet" href="assets/owlcarousel/assets/owl.carousel.min.css"> 
	
    <!-- Fontawesome styles for this template-->
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
	
</head>

<body>
	<!--header start-->
		<header id="header" class="default">
			<div class="topbar">
					<div class="container">
						<div class="row">
							<div class="col-md-4">
								<div class="topbar-left text-center text-md-left">
									<ul class="list-inline">
										<li> <a href="contact.html"> Contact </a></li>
										<li> <a href="about.html"> About Us </a></li>
										<li> <a href="our_blog.html"> Blog </a></li>											
										<li> <a href="partner_with_us.html"> Become a Partner </a></li>		
									</ul>
								</div>
							</div>
							<div class="col-md-8">
								<div class="topbar-right text-center text-md-right">
									<ul class="list-inline">
										<li><a href="#"><i class="far fa-calendar-alt"></i>Table Bookings</a> </li>
										<li><a href="#"><i class="far fa-bookmark"></i>Bookmarks <span class="badge badge-secondary">2</span></a></li>										
										<li><a href="#"><i class="fas fa-shopping-cart"></i>Food Orders <span class="badge badge-secondary">3</span></a></li>										
																				
										<li class="nav-item dropdown">
										<a  class="dropdown-toggle-no-caret" href="#" id="accountDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-user-circle"></i>John Doe  <i class="fas fa-caret-down"></i></a>
											<div class="dropdown-menu dropdown-menu-right" aria-labelledby="accountDropdown">
											  <a class="dropdown-item" href="my_profile_dashbord.html"> My Profile</a>
											  <a class="dropdown-item" href="#"> Bookmarks</a>
											  <a class="dropdown-item" href="#"> Booking Tables</a>
											  <a class="dropdown-item" href="#"> Find Friends</a>
											  <a class="dropdown-item" href="setting.html"> Setting</a>
											  <a class="dropdown-item" href="signin.html"> Logout</a>
											 
										   </div>
										</li>									
									</ul>
								</div>
							</div>
						</div>
					</div>
			</div>
			<div class="menu">
				<div class="container">
					<div class="row">
						<div class="col-md-2 col-sm-12 col-xs-12">
							<div class="menu-left text-center text-md-left">
								<div class="logo-box">
									<a href="index.html"><img src="images/logo.svg" alt=""></a>
								</div>
							</div>
						</div>
						<div class="col-md-10 col-sm-12 col-xs-12">	
							<div class="menu-items">
								<nav class="navbar navbar-expand-lg navbar-light bg-light menu-right">										
									<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
										<span class="navbar-toggler-icon"></span>
									</button>

									<div class="collapse navbar-collapse" id="navbarSupportedContent">
										<ul class="navbar-nav mr-auto nav-text">
											<li class="nav-item active">
												<a class="nav-link" href="index.html">Home </a>
											</li>
											<li class="nav-item">
												<a class="nav-link" href="how_to_orders.html">How To Orders?</a>
											</li>
											<li class="nav-item">
												<a class="nav-link" href="recipes.html">Recipes</a>
											</li>
											<li class="nav-item">
												<a class="nav-link" href="partners.html">Partners</a>
											</li>
											<li class="nav-item dropdown">
												<a class="nav-link dropdown-toggle-no-caret" href="#" id="megaDropdown1" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> Pages <i class="fas fa-caret-down"></i></a>																										
												<div class="dropdown-menu mega-menu dropdown-menu-right">	
													<div class="row">
													<div class="col-md-3">
														<a class="dropdown-item" href="about.html"> About us</a>
														<a class="dropdown-item" href="recipe_details.html"> Recipes Detail View</a>
														<a class="dropdown-item" href="upload_recipe.html"> Upload Recipe</a>
														<a class="dropdown-item" href="partners.html"> Partners</a>
														<a class="dropdown-item" href="restaurant_detail.html"> Restaurant Detail View</a>
														<a class="dropdown-item" href="partner_with_us.html"> Become a Partner</a>
														<a class="dropdown-item" href="add_restaurant.html"> Add Restaurant</a>
														
													</div>
													<div class="col-md-3">		
														<a class="dropdown-item" href="add_driver.html"> Add Driver</a>
														<a class="dropdown-item" href="meals.html"> Meals</a>
														<a class="dropdown-item" href="meal_detail.html"> Meal Detail View</a>
														<a class="dropdown-item" href="checkout.html"> Checkout</a>
														<a class="dropdown-item" href="bill_slip.html"> Bill Slip</a>
														<a class="dropdown-item" href="browse_places.html"> Browse Places</a>
														<a class="dropdown-item" href="places_nearby.html"> Near Places</a>
													</div>
													<div class="col-md-3">																						
														<a class="dropdown-item" href="places_cafes.html"> Cafes & More</a>
														<a class="dropdown-item" href="upcoming_events.html"> Upcoming Events</a>
														<a class="dropdown-item" href="event_detail.html"> Event Detail View</a>
														<a class="dropdown-item" href="user_profile_view.html"> User Profile View</a>
														<a class="dropdown-item" href="my_profile_dashbord.html"> My Order Dashboard</a>
														<a class="dropdown-item" href="restaurant_partner_dashbord.html"> Restaurant Partner Dashboard</a>
														<a class="dropdown-item" href="driver_partner_dashbord.html"> Driver Partner Dashboard</a>
													</div>
													<div class="col-md-3">															
														<a class="dropdown-item" href="setting.html"> My Setting</a>
														<a class="dropdown-item" href="error_404.html"> Error 404</a>
														<a class="dropdown-item" href="signin.html"> Login Now</a>
														<a class="dropdown-item" href="faq.html"> FAQ</a>
														<a class="dropdown-item" href="our_blog.html"> Our Blog</a>
														<a class="dropdown-item" href="blog_detail.html"> Single Blog Detail View</a>
														<a class="dropdown-item" href="contact.html"> Contact</a>
													</div>
												</div>
												</div>	
											</li>
											<li class="nav-item">
												<a class="nav-link" href="browse_places.html">Browse Places</a>
											</li>
										</ul>											
									</div>
									
								</nav>
								<div class="icons-set">
									<ul class="list-inline">
										<li class="icon-items nav-item dropdown ">
										<a class="nav-link dropdown-toggle-no-caret" href="#" id="navbarDropdown1" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-search"></i></a>										
											<div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown1">	
											<div class="notification-item">													
												<div class="search-details">
													<form class="form-inline">
													  <input class="form-control " type="search" placeholder="Search" aria-label="Search">
													  <button class="s-btn btn-link " type="submit"><i class="fas fa-search"></i></button>
													</form>																																								
												</div>
											</div>												
										</div>		
										</li>
										<li class="icon-items nav-item dropdown">
										<a class="nav-link dropdown-toggle-no-caret" href="#" id="navbarDropdown2" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-bell"></i></a>
										<div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown2">	
											<div class="notification-item">
												<div class="property">
													<ul>
														<li><div class="setting"><a href="#">Setting</a></div></li>
														<li><div class="clear"><a href="#">Clear</a></div></li>
													</ul>
												</div>
												<div class="notification-details">														
													<div class="media">
														<div class="media-left">
															<a href="#"><img src="images/notification-img-2.png" alt=""></a>
														</div>
														<div class="media-body">
															<h4 class="media-heading">Jassica William</h4> 
															<p>comment on your Video.</p>																
															<div class="comment-date">10 min ago</div>
														</div>
													</div>													
													<div class="media">
														<div class="media-left">
															<a href="#"><img src="images/notification-img-3.png" alt=""></a>	
														</div>
														<div class="media-body">
															<h4 class="media-heading">Congratulations!</h4>
															<p>Your Order is Accepted.</p>																													
															<div class="comment-date">
																15 min ago
															</div>
														</div>
													</div>																										
													<div class="media">
														<div class="media-left">
															<a href="#"><img src="images/notification-img-4.png" alt=""></a>
														</div>
														<div class="media-body">
															<h4 class="media-heading">Order Delivered!</h4>
															<p>Your Order is Delivered.</p>
															<div class="comment-date">20 min ago</div>
														</div>
													</div>																																								
												</div>
											</div>												
										</div>	
										</li>
										<li class="partner-btn">
											<a href="partner_with_us.html" class="b-btn btn-link">Become a Partner</a>
										</li>										
									</ul>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>				
		</header>
	<!--header end-->	
	<!--title-bar start-->
	<section class="title-bar">
		<div class="container">
			<div class="row">
				<div class="col-md-6">
					<div class="left-title-text">
					<h3>Recipes</h3>
					</div>
				</div>
				<div class="col-md-6">
					<div class="right-title-text">  
						<ul>
							<li class="breadcrumb-item"><a href="index.html">Home</a></li>
							<li class="breadcrumb-item active" aria-current="page">Recipes</li>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--title-bar end-->
	<!--recipe-cover-banner start-->
	<section class="recipe-block-preview">
		<div class="recipe-banner" style="background-image: url(images/find-recipes/banner.jpg)"></div>
		<div class="container">
			<div class="find-recipes">
				<div class="row">	
					<div class="col-md-12">
						<div class="new-heading">
							<h1> Find Recipes </h1>
						</div>						
					</div>
				</div>
				<div class="row justify-content-center">	
					<div class="col-md-6">			
						<p>Aenean tellus ligula, pellentesque sit amet luctus eget, posuere eget sapien. Proin ultricies vestibulum sem non lobortis.</p>
					</div>						
				</div>
				<div class="row justify-content-center">	
					<div class="col-md-6">			
						<form>
							<input class="input-recipes" name="find-recipes" type="text" placeholder="Find recipes...">
							<div class="find-recipes-btn">							
								<div class="f-r-btn">
									<button class="find-recipe-btn btn-link"><i class="fas fa-search"></i>Search</button>
								</div>
							</div>
						</form>
					</div>						
				</div>
				<div class="row">	
					<div class="col-md-12">			
						<div class="or">
						 <span> or </span>
						</div>							
						<div class="upload">
							<a href="upload_recipe.html" class="upload-btn btn-link">Upload Video</a>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>	
	<!--recipe-cover-banner end-->	
	<!--recipes-categories start-->
	<section class="category-recipes">
		<div class="container">
			<div class="owl-carousel testimonial-carousel">					  
				<div class="item">
					<div class="recipe-item">
						<img src="images/homepage/recipes/recipe_01.jpg" alt="">
						 <div class="overlay">
							<div class="recipes-title">	
								<h6>North Indian</h6>
								<p>75 Videos</p>
							 </div>
						 </div>
					</div>
				</div>
				<div class="item">
					<div class="recipe-item">
						<img src="images/homepage/recipes/recipe_02.jpg" alt="">
						 <div class="overlay">
							<div class="recipes-title">	
								<h6>Fast Food</h6>
								<p>105 Videos</p>
							 </div>
						 </div>
					</div>
				</div>
				<div class="item">
					<div class="recipe-item">
						<img src="images/homepage/recipes/recipe_03.jpg" alt="">
						 <div class="overlay">
							<div class="recipes-title">	
								<h6>Italian Food</h6>
								<p>35 Videos</p>
							 </div>
						 </div>
					</div>
				</div>
				<div class="item">
					<div class="recipe-item">
						<img src="images/homepage/recipes/recipe_04.jpg" alt="">
						 <div class="overlay">
							<div class="recipes-title">	
								<h6>Chinese Food</h6>
								<p>60 Videos</p>
							 </div>
						 </div>
					</div>
				</div>
				<div class="item">				
					<div class="recipe-item">
						<img src="images/homepage/recipes/recipe_05.jpg" alt="">
						 <div class="overlay">
							<div class="recipes-title">	
								<h6>Street Food</h6>
								<p>45 Videos</p>
							 </div>
						 </div>
					</div>	
				</div>
				<div class="item">
					<div class="recipe-item">
						<img src="images/homepage/recipes/recipe_06.jpg" alt="">
						 <div class="overlay">
							<div class="recipes-title">	
								<h6>Bakery</h6>
								<p>20 Videos</p>
							 </div>
						 </div>
					</div>
				</div>								 
			</div>
		</div>
	</section>
	<!--recipes-categories end-->
	<!--main-video-and-suggested-people start-->
	<section class="main-video">
		<div class="container">
			<div class="row">
				<div class="col-lg-9 col-md-12 col-sm-12">
					<div class="video-9">
						<div class="top-img">
							<div class="bg-gradient"></div>
							<img src="images/find-recipes/main-video.jpg" alt="">
							<div class="top-items">
								<div class="views">
									<p><i class="fas fa-eye"></i>2m views</p>
								</div>
								<div class="video-time">
									<p><i class="far fa-clock"></i>12.08</p>
								</div>
							</div>
							<div class="bottom-items">
								<div class="video-title">
									<a href="recipe_details.html"><h4>Learn to cook easy egg gravey dishes</h4></a><br>									
								<div class="rating">
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="far fa-star"></i>								
									<span>4.5</span> 							
								</div>
								</div>
								
								<div class="published">
									<p>Published 5 March 2018</p>
								</div>
							</div>
							<div class="middle">
								<a href="recipe_details.html"><div class="play-btn"><i class="fas fa-play"></i></div></a>
							</div>
						</div>
					</div>
				</div>
				<!--main-video end-->
				<!--suggested-peoples start-->
				<div class="col-lg-3 col-md-4 ">
					<div class="suggested-peoples">
						<div class="suggestions full-width">
							<div class="sd-title">
								<h3>Suggested Peoples</h3>
								<i class="la la-ellipsis-v"></i>
							</div><!--sd-title end-->
							<div class="suggestions-list">
								<div class="suggestion-usd">
									<a href="user_profile_view.html"><img src="images/find-recipes/user-1.png" alt=""></a>
									<div class="sgt-text">
										<a href="user_profile_view.html"><h4>Johnson</h4></a>
										<span>7 Reviews</span>
									</div>
									<button><i class="fas fa-user-plus"></i></button>
								</div>
								<div class="suggestion-usd">
									<a href="user_profile_view.html"><img src="images/find-recipes/user-2.png" alt=""></a>
									<div class="sgt-text">
										<a href="user_profile_view.html"><h4>Jassia William</h4></a>
										<span>5 Reviews</span>
									</div>
									<button><i class="fas fa-user-plus"></i></button>
								</div>
								<div class="suggestion-usd">
									<a href="user_profile_view.html"><img src="images/find-recipes/user-3.png" alt=""></a>
									<div class="sgt-text">
										<a href="user_profile_view.html"><h4>Rock</h4></a>
										<span>0 Reviews</span>
									</div>
									<button><i class="fas fa-user-plus"></i></button>
								</div>
								<div class="suggestion-usd">
									<a href="user_profile_view.html"><img src="images/find-recipes/user-4.png" alt=""></a>
									<div class="sgt-text">
										<a href="user_profile_view.html"><h4>Davil Smith</h4></a>
										<span>10 Reviews</span>
									</div>
									<button><i class="fas fa-user-plus"></i></button>
								</div>
								<div class="suggestion-usd">
									<a href="user_profile_view.html"><img src="images/find-recipes/user-5.png" alt=""></a>
									<div class="sgt-text">
										<a href="user_profile_view.html"><h4>Ricky Doe</h4></a>
										<span>3 Reviews</span>
									</div>
									<button><i class="fas fa-user-plus"></i></button>
								</div>
							</div><!--suggestions-list end-->
						</div>
					</div>
				</div><!--suggested-peoples end-->			
			</div>
		</div>
	</section>
	<!-- main-video-and-suggested-people end-->	
	<!--recomended-for-you start-->
	<section class="recomended">			
		<div class="container">		
			<div class="row">	
				<div class="col-md-12">
					<div class="new-heading">
						<h1> Recomended For You </h1>
					</div>	
				</div>
			</div>
			<div class="row">
			<div class="col-lg-3 col-md-6 col-sm-12 col-xs-12">
					<div class="recipe-vdo">
						<div class="top">
							
							<div class="top-img">
								<div class="bg-gradient"></div>
								<img src="images/find-recipes/video-1.jpg" alt="">
							</div>
							<div class="top-items">
								<div class="views">
									<p><i class="fas fa-eye"></i>2m views</p>
								</div>
								<div class="video-time">
									<p><i class="far fa-clock"></i>12.08</p>
								</div>
							</div>
							<div class="middle">
								<a href="recipe_details.html"><div class="play-btn"><i class="fas fa-play"></i></div></a>
							</div>
						</div>
						<div class="video-bottom">
							<div class="bottom-text">
								<a href="recipe_details.html"><h4>Learn to cook easy vegetarian noodles</h4></a>
								<div class="v-published">Published 25 March 2019</div>
								<div class="star">
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>								
									<span>4.5</span> 
									<div class="comments"><a href="#"><i class="fas fa-comment-alt"></i>05</a></div>
								</div>								
							</div>
						</div>
					</div>					
				</div>
				<div class="col-lg-3 col-md-6 col-sm-12 col-xs-12">
					<div class="recipe-vdo">
						<div class="top">
							
							<div class="top-img">
								<div class="bg-gradient"></div>
								<img src="images/find-recipes/video-2.jpg" alt="">
							</div>
							<div class="top-items">
								<div class="views">
									<p><i class="fas fa-eye"></i>2m views</p>
								</div>
								<div class="video-time">
									<p><i class="far fa-clock"></i>12.08</p>
								</div>
							</div>
							<div class="middle">
								<a href="recipe_details.html"><div class="play-btn"><i class="fas fa-play"></i></div></a>
							</div>
						</div>
						<div class="video-bottom">
							<div class="bottom-text">
								<a href="recipe_details.html"><h4>Learn to cook easy tandoori chicken</h4></a>
								<div class="v-published">Published 20 March 2019</div>
								<div class="star">
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>								
									<span>4.5</span> 
									<div class="comments"><a href="#"><i class="fas fa-comment-alt"></i>05</a></div>
								</div>								
							</div>
						</div>
					</div>					
				</div>
				<div class="col-lg-3 col-md-6 col-sm-12 col-xs-12">
					<div class="recipe-vdo">
						<div class="top">							
							<div class="top-img">
								<div class="bg-gradient"></div>
								<img src="images/find-recipes/video-3.jpg" alt="">
							</div>
							<div class="top-items">
								<div class="views">
									<p><i class="fas fa-eye"></i>2m views</p>
								</div>
								<div class="video-time">
									<p><i class="far fa-clock"></i>12.08</p>
								</div>
							</div>
							<div class="middle">
								<a href="recipe_details.html"><div class="play-btn"><i class="fas fa-play"></i></div></a>
							</div>
						</div>
						<div class="video-bottom">
							<div class="bottom-text">
								<a href="recipe_details.html"><h4>Learn to cook easy vegetarian Burgur</h4></a>
								<div class="v-published">Published 10 March 2019</div>
								<div class="star">
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>								
									<span>4.5</span> 
									<div class="comments"><a href="#"><i class="fas fa-comment-alt"></i>05</a></div>
								</div>								
							</div>
						</div>
					</div>					
				</div>
				<div class="col-lg-3 col-md-6 col-sm-12 col-xs-12">
					<div class="recipe-vdo">
						<div class="top">
							
							<div class="top-img">
								<div class="bg-gradient"></div>
								<img src="images/find-recipes/video-4.jpg" alt="">
							</div>
							<div class="top-items">
								<div class="views">
									<p><i class="fas fa-eye"></i>2m views</p>
								</div>
								<div class="video-time">
									<p><i class="far fa-clock"></i>12.08</p>
								</div>
							</div>
							<div class="middle">
								<a href="recipe_details.html"><div class="play-btn"><i class="fas fa-play"></i></div></a>
							</div>
						</div>
						<div class="video-bottom">
							<div class="bottom-text">
								<a href="recipe_details.html"><h4>Learn to cook easy non veg Tangdi kabab</h4></a>
								<div class="v-published">Published 15 June 2019</div>
								<div class="star">
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>								
									<span>4.5</span> 
									<div class="comments"><a href="#"><i class="fas fa-comment-alt"></i>05</a></div>
								</div>								
							</div>
						</div>
					</div>					
				</div>
				<div class="col-lg-3 col-md-6 col-sm-12 col-xs-12">
					<div class="recipe-vdo">
						<div class="top">							
							<div class="top-img">
								<div class="bg-gradient"></div>
								<img src="images/find-recipes/video-5.jpg" alt="">
							</div>
							<div class="top-items">
								<div class="views">
									<p><i class="fas fa-eye"></i>2m views</p>
								</div>
								<div class="video-time">
									<p><i class="far fa-clock"></i>12.08</p>
								</div>
							</div>
							<div class="middle">
								<a href="recipe_details.html"><div class="play-btn"><i class="fas fa-play"></i></div></a>
							</div>
						</div>
						<div class="video-bottom">
							<div class="bottom-text">
								<a href="recipe_details.html"><h4>Learn to cook easy italian pasta</h4></a>
								<div class="v-published">Published 5 March 2019</div>
								<div class="star">
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>								
									<span>4.5</span> 
									<div class="comments"><a href="#"><i class="fas fa-comment-alt"></i>05</a></div>
								</div>								
							</div>
						</div>
					</div>					
				</div>
				<div class="col-lg-3 col-md-6 col-sm-12 col-xs-12">
					<div class="recipe-vdo">
						<div class="top">							
							<div class="top-img">
								<div class="bg-gradient"></div>
								<img src="images/find-recipes/video-6.jpg" alt="">
							</div>
							<div class="top-items">
								<div class="views">
									<p><i class="fas fa-eye"></i>2m views</p>
								</div>
								<div class="video-time">
									<p><i class="far fa-clock"></i>12.08</p>
								</div>
							</div>
							<div class="middle">
								<a href="recipe_details.html"><div class="play-btn"><i class="fas fa-play"></i></div></a>
							</div>
						</div>
						<div class="video-bottom">
							<div class="bottom-text">
								<a href="recipe_details.html"><h4>Learn to cook easy street food pani puri</h4></a>
								<div class="v-published">Published 21 July 2019</div>
								<div class="star">
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>								
									<span>4.5</span> 
									<div class="comments"><a href="#"><i class="fas fa-comment-alt"></i>05</a></div>
								</div>								
							</div>
						</div>
					</div>					
				</div>
				<div class="col-lg-3 col-md-6 col-sm-12 col-xs-12">
					<div class="recipe-vdo">
						<div class="top">
							
							<div class="top-img">
								<div class="bg-gradient"></div>
								<img src="images/find-recipes/video-7.jpg" alt="">
							</div>
							<div class="top-items">
								<div class="views">
									<p><i class="fas fa-eye"></i>2m views</p>
								</div>
								<div class="video-time">
									<p><i class="far fa-clock"></i>12.08</p>
								</div>
							</div>
							<div class="middle">
								<a href="recipe_details.html"><div class="play-btn"><i class="fas fa-play"></i></div></a>
							</div>
						</div>
						<div class="video-bottom">
							<div class="bottom-text">
								<a href="recipe_details.html"><h4>Learn to cook potato french fries at home</h4></a>
								<div class="v-published">Published 28 March 2019</div>
								<div class="star">
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>								
									<span>4.5</span> 
									<div class="comments"><a href="#"><i class="fas fa-comment-alt"></i>05</a></div>
								</div>								
							</div>
						</div>
					</div>					
				</div>
				<div class="col-lg-3 col-md-6 col-sm-12 col-xs-12">
					<div class="recipe-vdo">
						<div class="top">							
							<div class="top-img">
								<div class="bg-gradient"></div>
								<img src="images/find-recipes/video-8.jpg" alt="">
							</div>
							<div class="top-items">
								<div class="views">
									<p><i class="fas fa-eye"></i>2m views</p>
								</div>
								<div class="video-time">
									<p><i class="far fa-clock"></i>12.08</p>
								</div>
							</div>
							<div class="middle">
								<a href="recipe_details.html"><div class="play-btn"><i class="fas fa-play"></i></div></a>
							</div>
						</div>
						<div class="video-bottom">
							<div class="bottom-text">
								<a href="recipe_details.html"><h4>Learn to cook easy cheese pizza</h4></a>
								<div class="v-published">Published 20 March 2019</div>
								<div class="star">
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>								
									<span>4.5</span> 
									<div class="comments"><a href="#"><i class="fas fa-comment-alt"></i>05</a></div>
								</div>								
							</div>
						</div>
					</div>					
				</div>
			</div>
		</div>
	</section>
	<!--recomended-for-you end-->	
	<!--recent-uploaded start-->
	<section class="recent-uploaded">			
		<div class="container">		
			<div class="row">	
				<div class="col-md-12">
					<div class="new-heading">
						<h1> Recent Uploaded </h1>
					</div>	
				</div>
			</div>
			<div class="row">
			<div class="col-lg-3 col-md-6 col-sm-12 col-xs-12">
					<div class="recipe-vdo">
						<div class="top">							
							<div class="top-img">
								<div class="bg-gradient"></div>
								<img src="images/find-recipes/video-1.jpg" alt="">
							</div>
							<div class="top-items">
								<div class="views">
									<p><i class="fas fa-eye"></i>2m views</p>
								</div>
								<div class="video-time">
									<p><i class="far fa-clock"></i>12.08</p>
								</div>
							</div>
							<div class="middle">
								<a href="recipe_details.html"><div class="play-btn"><i class="fas fa-play"></i></div></a>
							</div>
						</div>
						<div class="video-bottom">
							<div class="bottom-text">
								<a href="recipe_details.html"><h4>Learn to cook easy vegetarian noodles</h4></a>
								<div class="v-published">Published 25 March 2019</div>
								<div class="star">
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>								
									<span>4.5</span> 
									<div class="comments"><a href="#"><i class="fas fa-comment-alt"></i>05</a></div>
								</div>								
							</div>
						</div>
					</div>					
				</div>
				<div class="col-lg-3 col-md-6 col-sm-12 col-xs-12">
					<div class="recipe-vdo">
						<div class="top">							
							<div class="top-img">
								<div class="bg-gradient"></div>
								<img src="images/find-recipes/video-2.jpg" alt="">
							</div>
							<div class="top-items">
								<div class="views">
									<p><i class="fas fa-eye"></i> 2m views</p>
								</div>
								<div class="video-time">
									<p><i class="far fa-clock"></i>12.08</p>
								</div>
							</div>
							<div class="middle">
								<a href="recipe_details.html"><div class="play-btn"><i class="fas fa-play"></i></div></a>
							</div>
						</div>
						<div class="video-bottom">
							<div class="bottom-text">
								<a href="recipe_details.html"><h4>Learn to cook easy tandoori chicken</h4></a>
								<div class="v-published">Published 20 March 2019</div>
								<div class="star">
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>								
									<span>4.5</span> 
									<div class="comments"><a href="#"><i class="fas fa-comment-alt"></i>05</a></div>
								</div>								
							</div>
						</div>
					</div>					
				</div>
				<div class="col-lg-3 col-md-6 col-sm-12 col-xs-12">
					<div class="recipe-vdo">
						<div class="top">							
							<div class="top-img">
								<div class="bg-gradient"></div>
								<img src="images/find-recipes/video-3.jpg" alt="">
							</div>
							<div class="top-items">
								<div class="views">
									<p><i class="fas fa-eye"></i>2m views</p>
								</div>
								<div class="video-time">
									<p><i class="far fa-clock"></i>12.08</p>
								</div>
							</div>
							<div class="middle">
								<a href="recipe_details.html"><div class="play-btn"><i class="fas fa-play"></i></div></a>
							</div>
						</div>
						<div class="video-bottom">
							<div class="bottom-text">
								<a href="recipe_details.html"><h4>Learn to cook easy vegetarian Burgur</h4></a>
								<div class="v-published">Published 10 March 2019</div>
								<div class="star">
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>								
									<span>4.5</span> 
									<div class="comments"><a href="#"><i class="fas fa-comment-alt"></i>05</a></div>
								</div>								
							</div>
						</div>
					</div>					
				</div>
				<div class="col-lg-3 col-md-6 col-sm-12 col-xs-12">
					<div class="recipe-vdo">
						<div class="top">							
							<div class="top-img">
								<div class="bg-gradient"></div>
								<img src="images/find-recipes/video-4.jpg" alt="">
							</div>
							<div class="top-items">
								<div class="views">
									<p><i class="fas fa-eye"></i>2m views</p>
								</div>
								<div class="video-time">
									<p><i class="far fa-clock"></i>12.08</p>
								</div>
							</div>
							<div class="middle">
								<a href="recipe_details.html"><div class="play-btn"><i class="fas fa-play"></i></div></a>
							</div>
						</div>
						<div class="video-bottom">
							<div class="bottom-text">
								<a href="recipe_details.html"><h4>Learn to cook easy non veg Tangdi kabab</h4></a>
								<div class="v-published">Published 15 June 2019</div>
								<div class="star">
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>								
									<span>4.5</span> 
									<div class="comments"><a href="#"><i class="fas fa-comment-alt"></i>05</a></div>
								</div>								
							</div>
						</div>
					</div>					
				</div>
				<div class="col-lg-3 col-md-6 col-sm-12 col-xs-12">
					<div class="recipe-vdo">
						<div class="top">
							
							<div class="top-img">
								<div class="bg-gradient"></div>
								<img src="images/find-recipes/video-5.jpg" alt="">
							</div>
							<div class="top-items">
								<div class="views">
									<p><i class="fas fa-eye"></i>2m views</p>
								</div>
								<div class="video-time">
									<p><i class="far fa-clock"></i>12.08</p>
								</div>
							</div>
							<div class="middle">
								<a href="recipe_details.html"><div class="play-btn"><i class="fas fa-play"></i></div></a>
							</div>
						</div>
						<div class="video-bottom">
							<div class="bottom-text">
								<a href="recipe_details.html"><h4>Learn to cook easy italian pasta</h4></a>
								<div class="v-published">Published 5 March 2019</div>
								<div class="star">
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>								
									<span>4.5</span> 
									<div class="comments"><a href="#"><i class="fas fa-comment-alt"></i>05</a></div>
								</div>								
							</div>
						</div>
					</div>					
				</div>
				<div class="col-lg-3 col-md-6 col-sm-12 col-xs-12">
					<div class="recipe-vdo">
						<div class="top">
							
							<div class="top-img">
								<div class="bg-gradient"></div>
								<img src="images/find-recipes/video-6.jpg" alt="">
							</div>
							<div class="top-items">
								<div class="views">
									<p><i class="fas fa-eye"></i>2m views</p>
								</div>
								<div class="video-time">
									<p><i class="far fa-clock"></i>12.08</p>
								</div>
							</div>
							<div class="middle">
								<a href="recipe_details.html"><div class="play-btn"><i class="fas fa-play"></i></div></a>
							</div>
						</div>
						<div class="video-bottom">
							<div class="bottom-text">
								<a href="recipe_details.html"><h4>Learn to cook easy street food pani puri</h4></a>
								<div class="v-published">Published 21 July 2019</div>
								<div class="star">
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>								
									<span>4.5</span> 
									<div class="comments"><a href="#"><i class="fas fa-comment-alt"></i>05</a></div>
								</div>								
							</div>
						</div>
					</div>					
				</div>
				<div class="col-lg-3 col-md-6 col-sm-12 col-xs-12">
					<div class="recipe-vdo">
						<div class="top">
							
							<div class="top-img">
								<div class="bg-gradient"></div>
								<img src="images/find-recipes/video-7.jpg" alt="">
							</div>
							<div class="top-items">
								<div class="views">
									<p><i class="fas fa-eye"></i>2m views</p>
								</div>
								<div class="video-time">
									<p><i class="far fa-clock"></i>12.08</p>
								</div>
							</div>
							<div class="middle">
								<a href="recipe_details.html"><div class="play-btn"><i class="fas fa-play"></i></div></a>
							</div>
						</div>
						<div class="video-bottom">
							<div class="bottom-text">
								<a href="recipe_details.html"><h4>Learn to cook potato french fries at home</h4></a>
								<div class="v-published">Published 28 March 2019</div>
								<div class="star">
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>								
									<span>4.5</span> 
									<div class="comments"><a href="#"><i class="fas fa-comment-alt"></i>05</a></div>
								</div>								
							</div>
						</div>
					</div>					
				</div>
				<div class="col-lg-3 col-md-6 col-sm-12 col-xs-12">
					<div class="recipe-vdo">
						<div class="top">
							
							<div class="top-img">
								<div class="bg-gradient"></div>
								<img src="images/find-recipes/video-8.jpg" alt="">
							</div>
							<div class="top-items">
								<div class="views">
									<p><i class="fas fa-eye"></i>2m views</p>
								</div>
								<div class="video-time">
									<p><i class="far fa-clock"></i>12.08</p>
								</div>
							</div>
							<div class="middle">
								<a href="recipe_details.html"><div class="play-btn"><i class="fas fa-play"></i></div></a>
							</div>
						</div>
						<div class="video-bottom">
							<div class="bottom-text">
								<a href="recipe_details.html"><h4>Learn to cook easy cheese pizza</h4></a>
								<div class="v-published">Published 20 March 2019</div>
								<div class="star">
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>
									<i class="fas fa-star"></i>								
									<span>4.5</span> 
									<div class="comments"><a href="#"><i class="fas fa-comment-alt"></i>05</a></div>
								</div>								
							</div>
						</div>
					</div>					
				</div>
			</div>
			<div class="video-see-btn">
				<a href="#" class="m-btn btn-link">Show All</a>
			</div>
		</div>
	</section>
	<!--recent-uploaded end-->
		
	<!--over-15000-restaurants start-->
	<section class="over-restaurants">
		<div class="container">
			<div class="row">
				<div class="col-lg-9 col-md-8">
					<div class="restaurants-links">
						<h1>Choose From Over 15,000 Restaurants</h1>
						<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam augue justo, euismod at purus quis, dictum iaculis lorem. Sed dictum, dolor sit amet feugiat posuere, ante arcu iaculis tortor</p>
					</div>
				</div>
				<div class="col-lg-3 col-md-4">
					<div class="view-restaurants">
						<a href="partners.html" class="m-btn r-btn-link">View Restaurants</a>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--over-15000-restaurants end-->	
	<!--footer start-->
	<footer class="footer">
		<div class="subscribe-now line">
			<div class="container">
				<div class="row justify-content-between">
					<div class="col-lg-5 col-md-6">
						<div class="subscribe-newsletter">
							<div class="sub-text">
								<p>Connect with us for update and offers.</p>
							</div>
							<form>
								<input class="input-subscribe" name="newsletter" type="text" placeholder="Enter your email address">
								<div class="subscribe-btn">							
									<div class="s-n-btn">
										<button class="newsletter-btn btn-link">Subscribe Now</button>
									</div>
								</div>
							</form>
						</div>
					</div>
					<div class="col-lg-2 col-md-3">
						<div class="language">	
							<form method="post" enctype="multipart/form-data" id="form-language">
							<div class="btn-group open">
								<button class="lang-btn l-btn-link dropdown-toggle-no-caret" data-toggle="dropdown" aria-expanded="true">
									<i class="fas fa-globe"></i><span class="hidden-xs">English</span><i class="fas fa-caret-down"></i>
								</button>
								<ul class="dropdown-menu">
									<li><a href="javascript:;">English</a></li>
									<li><a href="javascript:;">Spanish</a></li>
									<li><a href="javascript:;">Hindi</a></li>
									<li><a href="javascript:;">Punjabi</a></li>
								</ul>
							</div>
						</form>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="container">
			<div class="row">
				<div class="col-lg-3 col-md-4 col-sm-12 col-xs-12">
					<div class="img-title">
						<a href="index.html"><img src="images/logo-2.svg" alt=""></a>
					</div>
					<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam interdum leo at finibus ornare. 
					Aliquam gravida condimentum neque, vel ultrices purus dignissim a. </p>
				</div>
				<div class="col-md-3 col-sm-12 col-xs-12">
					<div class="link-title">
						<h4>About Natto</h4>
						<ul class="links">
							<li><a href="about.html">About Us</a></li>
							<li><a href="#">Careers</a></li>
							<li><a href="our_blog.html">Blog</a></li>
							<li><a href="#">Developers</a></li>
							<li><a href="#">Mobile Apps</a></li>
							<li><a href="contact.html">Contact</a></li>
						</ul>
					</div>					
				</div>
				<div class="col-lg-3 col-md-4 col-sm-12 col-xs-12">
					<div class="link-title">
						<h4>Business</h4>
						<ul class="links">
							<li><a href="add_restaurant.html">Add a Restaurant</a></li>
							<li><a href="#">Buniess Order Guidelines</a></li>
							<li><a href="#">Orders</a></li>
							<li><a href="#">Book</a></li>
							<li><a href="#">Trace</a></li>
							<li><a href="#">Advertise</a></li>
						</ul>
					</div>					
				</div>
				<div class="col-lg-3 col-md-4 col-sm-12 col-xs-12">
					<div class="link-title">
						<h4>Partner With Us</h4>
						<ul class="links">
							<li><a href="add_restaurant.html">For Restaurants</a></li>
							<li><a href="add_driver.html">For Driver</a></li>							
						</ul>
						<div class="social-btns">
							<a href="#"><div class="social-btn soc-btn"><i class="fab fa-facebook-f"></i></div></a>
							<a href="#"><div class="social-btn soc-btn"><i class="fab fa-twitter"></i></div></a>
							<a href="#"><div class="social-btn soc-btn"><i class="fab fa-instagram"></i></div></a>
							<a href="#"><div class="social-btn soc-btn"><i class="fab fa-linkedin-in"></i></div></a>
							<a href="#"><div class="social-btn soc-btn"><i class="fab fa-youtube"></i></div></a>
						</div>
					</div>					
				</div>				
			</div>
		</div>
		<div class="privacy-cards">
			<div class="container">
				<div class="row">
					<div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
						<div class="privacy-terms">
							<ul>
								<li><a href="#">Privacy</a></li>
								<li><a href="#">Terms & Conditions</a></li>
								<li><a href="#">Sitemap</a></li>
							</ul>
						</div>
					</div>
					<div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
						<div class="cards">
							<img src="images/cards.png" alt="">
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="copyright">
			<div class="container">
				<div class="row">
					<div class="col-lg-12 col-md-12">
						<div class="copyright-text">
						<i class="far fa-copyright"></i>Copyright 2019 <a href="index.html">Natto</a> by Gambol. All Rights Reserved.
						</div>
					</div>			
				</div>
			</div>
		</div>
	</footer>
	<!--footer end-->  

    <!-- Bootstrap core JavaScript-->
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <!-- Core plugin JavaScript-->
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
	<!-- Assect scripts for this page-->
	<script src="assets/owlcarousel/owl.carousel.js"></script>
	<script src="js/recipeowlslider.js"></script>
	<script src="js/custom.js"></script>
	
  </body>
</html>
